<?php
/*
Plugin Name: AI Tarot Reader
Description: فال تاروت با استفاده از هوش مصنوعی و مدل ChatGPT
Version: 1.0
Author: Homan Imani
*/

defined('ABSPATH') || exit;

// Load scripts and styles
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_script('ai-tarot-js', plugin_dir_url(__FILE__) . 'ai-tarot.js', ['jquery'], null, true);
    wp_enqueue_style('ai-tarot-css', plugin_dir_url(__FILE__) . 'ai-tarot.css');

    wp_localize_script('ai-tarot-js', 'ai_tarot_ajax', [
        'ajax_url' => admin_url('admin-ajax.php'),
    ]);
});

// Shortcode to show tarot form
add_shortcode('ai_tarot_reader', function () {
    ob_start(); ?>
    <div class="ai-tarot">
        <textarea id="user_question" placeholder="سؤال خود را بنویسید..."></textarea>
        <button id="draw_cards">گرفتن فال</button>
        <div id="tarot_result"></div>
    </div>
    <?php return ob_get_clean();
});

// Handle AJAX
add_action('wp_ajax_ai_tarot_get_reading', 'ai_tarot_get_reading');
add_action('wp_ajax_nopriv_ai_tarot_get_reading', 'ai_tarot_get_reading');

function ai_tarot_get_reading()
{
    $question = sanitize_text_field($_POST['question']);
    $cards = ai_tarot_draw_cards(3);
    $card_names = implode('، ', $cards);
    $prompt = "سؤال: $question\nکارت‌های انتخاب‌شده: $card_names\nتعبیر فال را به زبان فارسی و روان بنویس.";

    $response = wp_remote_post('https://api.openai.com/v1/chat/completions', [
        'headers' => [
            'Content-Type' => 'application/json',
            'Authorization' => 'Bearer ' . OPENAI_API_KEY,
        ],
        'body' => json_encode([
            'model' => 'gpt-3.5-turbo',
            'messages' => [
                ['role' => 'user', 'content' => $prompt]
            ]
        ])
    ]);

    if (is_wp_error($response)) {
        wp_send_json_error('ارتباط با سرور برقرار نشد.');
    }

    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);
    

error_log('AI Response: ' . print_r($data, true));



    if (!isset($data['choices'][0]['message']['content'])) {
        wp_send_json_error('پاسخی از هوش مصنوعی دریافت نشد.');
    }

    wp_send_json_success([
        'cards' => $cards,
        'reading' => trim($data['choices'][0]['message']['content'])
    ]);
}

// Draw 3 random Persian tarot cards
function ai_tarot_draw_cards($count = 3)
{
    $cards = [
        'جادوگر', 'امپراتور', 'امپراتریس', 'پاپ', 'عاشق', 'ارابه', 'قدرت', 'مرد آویزان',
        'مرگ', 'اعتدال', 'شیطان', 'برج', 'ستاره', 'ماه', 'خورشید', 'داوری', 'دنیا',
        'دلقک', 'شمشیر نه', 'چوبدست دو', 'سکه سه', 'جام شاهزاده', 'جام ملکه'
    ];
    shuffle($cards);
    return array_slice($cards, 0, $count);
}
