/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-13 05:16:34 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=1075 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=31529 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=3194 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_audit_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `network_id` bigint(20) NOT NULL DEFAULT 0,
  `site_id` bigint(20) NOT NULL DEFAULT 0,
  `username` varchar(60) NOT NULL DEFAULT '',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `level` varchar(25) NOT NULL DEFAULT '',
  `event_type` varchar(25) NOT NULL DEFAULT '',
  `details` text NOT NULL,
  `stacktrace` text NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  `country_code` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `ip` (`ip`),
  KEY `level` (`level`),
  KEY `event_type` (`event_type`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_debug_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `logtime` int(10) unsigned DEFAULT NULL,
  `level` varchar(25) NOT NULL DEFAULT '',
  `network_id` bigint(20) NOT NULL DEFAULT 0,
  `site_id` bigint(20) NOT NULL DEFAULT 0,
  `message` text NOT NULL,
  `type` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) NOT NULL DEFAULT '',
  `username` varchar(150) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int(10) unsigned DEFAULT NULL,
  `ip_or_host` varchar(100) DEFAULT NULL,
  `referer_info` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `country_code` varchar(50) DEFAULT NULL,
  `event_data` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int(10) unsigned DEFAULT NULL,
  `meta_key1` varchar(255) NOT NULL,
  `meta_key2` varchar(255) NOT NULL,
  `meta_key3` varchar(255) NOT NULL,
  `meta_key4` varchar(255) NOT NULL,
  `meta_key5` varchar(255) NOT NULL,
  `meta_value1` varchar(255) NOT NULL,
  `meta_value2` text NOT NULL,
  `meta_value3` text NOT NULL,
  `meta_value4` longtext NOT NULL,
  `meta_value5` longtext NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_logged_in_users` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `ip_address` varchar(45) NOT NULL DEFAULT '',
  `site_id` bigint(20) NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  `expires` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_id` (`user_id`),
  KEY `created` (`created`),
  KEY `expires` (`expires`),
  KEY `user_id` (`user_id`),
  KEY `site_id` (`site_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int(10) unsigned DEFAULT NULL,
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `released` int(10) unsigned DEFAULT NULL,
  `failed_login_ip` varchar(100) NOT NULL DEFAULT '',
  `lock_reason` varchar(128) NOT NULL DEFAULT '',
  `unlock_key` varchar(128) NOT NULL DEFAULT '',
  `is_lockout_email_sent` tinyint(1) NOT NULL DEFAULT 1,
  `backtrace_log` text NOT NULL,
  `ip_lookup_result` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `failed_login_ip` (`failed_login_ip`),
  KEY `is_lockout_email_sent` (`is_lockout_email_sent`),
  KEY `unlock_key` (`unlock_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_message_store` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `message_key` text NOT NULL,
  `message_value` text NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_permanent_block` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) NOT NULL DEFAULT '',
  `block_reason` varchar(128) NOT NULL DEFAULT '',
  `country_origin` varchar(50) NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int(10) unsigned DEFAULT NULL,
  `unblock` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `blocked_ip` (`blocked_ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_jetpack_sync_queue` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `queue_id` varchar(50) NOT NULL,
  `event_id` varchar(100) NOT NULL,
  `event_payload` longtext NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`),
  KEY `event_id` (`event_id`),
  KEY `queue_id` (`queue_id`),
  KEY `queue_id_event_id` (`queue_id`,`event_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM AUTO_INCREMENT=125 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=121722 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=12726 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1827 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=205 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=184 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=205 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=196 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=25516 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM AUTO_INCREMENT=311 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM AUTO_INCREMENT=103 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM AUTO_INCREMENT=929 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=127 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=148 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wt_iew_action_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_type` varchar(255) NOT NULL,
  `item_type` varchar(255) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `created_at` int(11) NOT NULL DEFAULT 0,
  `status` int(11) NOT NULL DEFAULT 0,
  `status_text` varchar(255) NOT NULL,
  `offset` int(11) NOT NULL DEFAULT 0,
  `total` int(11) NOT NULL DEFAULT 0,
  `data` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wt_iew_mapping_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_type` varchar(255) NOT NULL,
  `item_type` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("866", "action_scheduler/migration_hook", "failed", "2025-06-05 20:49:44", "2025-06-05 20:49:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749156584;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749156584;}", "1", "1", "2025-06-05 20:49:57", "2025-06-05 20:49:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1049", "woocommerce_cleanup_draft_orders", "complete", "2025-11-22 08:21:06", "2025-11-22 07:21:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763799666;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763799666;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-22 09:01:43", "2025-11-22 08:01:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1048", "wc-admin_import_orders", "complete", "2025-11-20 09:25:37", "2025-11-20 08:25:37", "10", "[1819]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763630737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763630737;}", "5", "1", "2025-11-20 10:03:49", "2025-11-20 09:03:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("15", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2025-02-24 18:39:49", "2025-02-24 18:39:49", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-02-24 18:40:28", "2025-02-24 22:10:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1038", "woocommerce_cleanup_draft_orders", "complete", "2025-11-13 07:15:13", "2025-11-13 06:15:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763018113;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763018113;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-13 07:33:50", "2025-11-13 06:33:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1045", "woocommerce_cleanup_draft_orders", "complete", "2025-11-20 07:57:18", "2025-11-20 06:57:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763625438;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763625438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-20 08:14:16", "2025-11-20 07:14:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1071", "woocommerce_cleanup_draft_orders", "complete", "2025-12-11 14:12:47", "2025-12-11 13:12:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765462367;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765462367;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-11 14:47:53", "2025-12-11 13:47:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1040", "woocommerce_cleanup_draft_orders", "complete", "2025-11-15 07:39:59", "2025-11-15 06:39:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763192399;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763192399;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-15 07:41:24", "2025-11-15 06:41:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("679", "action_scheduler/migration_hook", "failed", "2025-02-28 10:43:12", "2025-02-28 10:43:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1740739392;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1740739392;}", "1", "1", "2025-02-28 10:43:20", "2025-02-28 14:13:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1041", "woocommerce_cleanup_draft_orders", "complete", "2025-11-16 07:41:24", "2025-11-16 06:41:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763278884;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763278884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-16 07:52:56", "2025-11-16 06:52:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1042", "woocommerce_cleanup_draft_orders", "complete", "2025-11-17 07:52:56", "2025-11-17 06:52:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763365976;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763365976;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-17 07:53:19", "2025-11-17 06:53:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1043", "woocommerce_cleanup_draft_orders", "complete", "2025-11-18 07:53:19", "2025-11-18 06:53:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763452399;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763452399;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-18 07:54:41", "2025-11-18 06:54:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1044", "woocommerce_cleanup_draft_orders", "complete", "2025-11-19 07:54:41", "2025-11-19 06:54:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763538881;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763538881;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-19 07:57:18", "2025-11-19 06:57:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("838", "action_scheduler/migration_hook", "failed", "2025-05-17 18:05:56", "2025-05-17 18:05:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747505156;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747505156;}", "1", "1", "2025-05-17 18:06:34", "2025-05-17 18:06:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1073", "wc-admin_import_orders", "complete", "2025-12-12 00:59:56", "2025-12-11 23:59:56", "10", "[1825]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765501196;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765501196;}", "5", "1", "2025-12-12 01:01:20", "2025-12-12 00:01:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1070", "woocommerce_cleanup_draft_orders", "complete", "2025-12-10 13:45:24", "2025-12-10 12:45:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765374324;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765374324;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-10 14:12:47", "2025-12-10 13:12:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1069", "woocommerce_cleanup_draft_orders", "complete", "2025-12-09 13:39:05", "2025-12-09 12:39:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765287545;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765287545;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-09 13:45:24", "2025-12-09 12:45:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1068", "woocommerce_cleanup_draft_orders", "complete", "2025-12-08 13:34:04", "2025-12-08 12:34:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765200844;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765200844;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-08 13:39:05", "2025-12-08 12:39:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1067", "woocommerce_cleanup_draft_orders", "complete", "2025-12-07 13:30:21", "2025-12-07 12:30:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765114221;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765114221;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-07 13:34:04", "2025-12-07 12:34:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1066", "woocommerce_cleanup_draft_orders", "complete", "2025-12-06 13:25:53", "2025-12-06 12:25:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765027553;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765027553;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-06 13:30:21", "2025-12-06 12:30:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1064", "wc-admin_import_orders", "complete", "2025-12-04 11:51:49", "2025-12-04 10:51:49", "10", "[1824]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1764849109;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1764849109;}", "5", "1", "2025-12-04 12:09:31", "2025-12-04 11:09:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1065", "woocommerce_cleanup_draft_orders", "complete", "2025-12-05 13:13:34", "2025-12-05 12:13:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764940414;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764940414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-05 13:25:53", "2025-12-05 12:25:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1059", "woocommerce_cleanup_draft_orders", "complete", "2025-12-02 12:38:58", "2025-12-02 11:38:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764679138;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764679138;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-02 13:07:30", "2025-12-02 12:07:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1057", "woocommerce_cleanup_draft_orders", "complete", "2025-11-30 10:55:57", "2025-11-30 09:55:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764500157;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764500157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-30 11:13:08", "2025-11-30 10:13:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1051", "woocommerce_cleanup_draft_orders", "complete", "2025-11-24 09:27:45", "2025-11-24 08:27:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763976465;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763976465;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-24 09:29:33", "2025-11-24 08:29:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1052", "woocommerce_cleanup_draft_orders", "complete", "2025-11-25 09:29:33", "2025-11-25 08:29:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764062973;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764062973;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-25 09:47:24", "2025-11-25 08:47:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1053", "woocommerce_cleanup_draft_orders", "complete", "2025-11-26 09:47:24", "2025-11-26 08:47:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764150444;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764150444;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-26 10:38:30", "2025-11-26 09:38:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1054", "woocommerce_cleanup_draft_orders", "complete", "2025-11-27 10:38:30", "2025-11-27 09:38:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764239910;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764239910;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-27 10:47:20", "2025-11-27 09:47:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1055", "woocommerce_cleanup_draft_orders", "complete", "2025-11-28 10:47:20", "2025-11-28 09:47:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764326840;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764326840;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-28 10:47:47", "2025-11-28 09:47:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1072", "woocommerce_cleanup_draft_orders", "complete", "2025-12-12 14:47:53", "2025-12-12 13:47:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765550873;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765550873;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-12 14:52:04", "2025-12-12 13:52:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1061", "wc-admin_import_orders", "complete", "2025-12-03 00:43:49", "2025-12-02 23:43:49", "10", "[1823]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1764722629;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1764722629;}", "5", "1", "2025-12-03 00:44:22", "2025-12-02 23:44:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1062", "woocommerce_cleanup_draft_orders", "complete", "2025-12-04 13:12:12", "2025-12-04 12:12:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764853932;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764853932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-04 13:13:34", "2025-12-04 12:13:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1063", "wc-admin_import_orders", "complete", "2025-12-03 21:15:26", "2025-12-03 20:15:26", "10", "[1823]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1764796526;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1764796526;}", "5", "1", "2025-12-03 21:34:44", "2025-12-03 20:34:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1060", "woocommerce_cleanup_draft_orders", "complete", "2025-12-03 13:07:30", "2025-12-03 12:07:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764767250;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764767250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-03 13:12:12", "2025-12-03 12:12:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1058", "woocommerce_cleanup_draft_orders", "complete", "2025-12-01 11:13:08", "2025-12-01 10:13:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764587588;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764587588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-01 12:38:58", "2025-12-01 11:38:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1056", "woocommerce_cleanup_draft_orders", "complete", "2025-11-29 10:47:47", "2025-11-29 09:47:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764413267;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764413267;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-29 10:55:57", "2025-11-29 09:55:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1050", "woocommerce_cleanup_draft_orders", "complete", "2025-11-23 09:01:43", "2025-11-23 08:01:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763888503;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763888503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-23 09:27:45", "2025-11-23 08:27:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1047", "wc-admin_import_orders", "complete", "2025-11-20 09:25:23", "2025-11-20 08:25:23", "10", "[1819]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763630723;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763630723;}", "5", "1", "2025-11-20 09:25:23", "2025-11-20 08:25:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1074", "woocommerce_cleanup_draft_orders", "pending", "2025-12-13 14:52:04", "2025-12-13 13:52:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765637524;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765637524;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1046", "woocommerce_cleanup_draft_orders", "complete", "2025-11-21 08:14:16", "2025-11-21 07:14:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763712856;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763712856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-21 08:21:06", "2025-11-21 07:21:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1039", "woocommerce_cleanup_draft_orders", "complete", "2025-11-14 07:33:50", "2025-11-14 06:33:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763105630;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763105630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-14 07:39:59", "2025-11-14 06:39:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1037", "woocommerce_cleanup_draft_orders", "complete", "2025-11-12 07:14:47", "2025-11-12 06:14:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762931687;s:18:\"\0*\0first_timestamp\";i:1740422282;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762931687;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-12 07:15:13", "2025-11-12 06:15:13", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "wc_update_product_default_cat");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("14", "15", "ایجاد فعالیت", "2025-02-24 18:39:49", "2025-02-24 18:39:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("15", "15", "عملیات توسط WP Cron شروع شد", "2025-02-24 18:40:28", "2025-02-24 18:40:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("16", "15", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.", "2025-02-24 18:40:28", "2025-02-24 18:40:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("3135", "1054", "عملیات توسط WP Cron کامل شد", "2025-11-27 10:47:20", "2025-11-27 09:47:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("3124", "1051", "ایجاد فعالیت", "2025-11-23 09:27:45", "2025-11-23 08:27:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3088", "1039", "ایجاد فعالیت", "2025-11-13 07:33:50", "2025-11-13 06:33:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3118", "1049", "ایجاد فعالیت", "2025-11-21 08:21:06", "2025-11-21 07:21:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3119", "1049", "عملیات توسط WP Cron شروع شد", "2025-11-22 09:01:43", "2025-11-22 08:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3120", "1049", "عملیات توسط WP Cron کامل شد", "2025-11-22 09:01:43", "2025-11-22 08:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3121", "1050", "ایجاد فعالیت", "2025-11-22 09:01:43", "2025-11-22 08:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3122", "1050", "عملیات توسط WP Cron شروع شد", "2025-11-23 09:27:45", "2025-11-23 08:27:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3180", "1069", "عملیات توسط WP Cron کامل شد", "2025-12-09 13:45:24", "2025-12-09 12:45:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3179", "1069", "عملیات توسط WP Cron شروع شد", "2025-12-09 13:45:24", "2025-12-09 12:45:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3178", "1069", "ایجاد فعالیت", "2025-12-08 13:39:05", "2025-12-08 12:39:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3158", "1063", "ایجاد فعالیت", "2025-12-03 21:15:22", "2025-12-03 20:15:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("3154", "1061", "عملیات توسط WP Cron کامل شد", "2025-12-03 00:44:22", "2025-12-02 23:44:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("3156", "1060", "عملیات توسط WP Cron کامل شد", "2025-12-03 13:12:12", "2025-12-03 12:12:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("3155", "1060", "عملیات توسط WP Cron شروع شد", "2025-12-03 13:12:12", "2025-12-03 12:12:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("3145", "1058", "ایجاد فعالیت", "2025-11-30 11:13:08", "2025-11-30 10:13:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("3146", "1058", "عملیات توسط WP Cron شروع شد", "2025-12-01 12:38:58", "2025-12-01 11:38:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3142", "1057", "ایجاد فعالیت", "2025-11-29 10:55:57", "2025-11-29 09:55:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3141", "1056", "عملیات توسط WP Cron کامل شد", "2025-11-29 10:55:57", "2025-11-29 09:55:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3130", "1053", "ایجاد فعالیت", "2025-11-25 09:47:24", "2025-11-25 08:47:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3131", "1053", "عملیات توسط WP Cron شروع شد", "2025-11-26 10:38:30", "2025-11-26 09:38:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("3132", "1053", "عملیات توسط WP Cron کامل شد", "2025-11-26 10:38:30", "2025-11-26 09:38:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("3129", "1052", "عملیات توسط WP Cron کامل شد", "2025-11-25 09:47:24", "2025-11-25 08:47:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3128", "1052", "عملیات توسط WP Cron شروع شد", "2025-11-25 09:47:24", "2025-11-25 08:47:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3127", "1052", "ایجاد فعالیت", "2025-11-24 09:29:33", "2025-11-24 08:29:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2567", "866", "ایجاد فعالیت", "2025-06-05 20:48:44", "2025-06-05 20:48:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2568", "866", "عملیات توسط WP Cron شروع شد", "2025-06-05 20:49:57", "2025-06-05 20:49:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2569", "866", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-06-05 20:49:57", "2025-06-05 20:49:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3116", "1046", "عملیات توسط WP Cron شروع شد", "2025-11-21 08:21:06", "2025-11-21 07:21:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3117", "1046", "عملیات توسط WP Cron کامل شد", "2025-11-21 08:21:06", "2025-11-21 07:21:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2483", "838", "ایجاد فعالیت", "2025-05-17 18:04:56", "2025-05-17 18:04:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2484", "838", "عملیات توسط WP Cron شروع شد", "2025-05-17 18:06:34", "2025-05-17 18:06:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2485", "838", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-05-17 18:06:34", "2025-05-17 18:06:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3144", "1057", "عملیات توسط WP Cron کامل شد", "2025-11-30 11:13:08", "2025-11-30 10:13:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2006", "679", "ایجاد فعالیت", "2025-02-28 10:42:12", "2025-02-28 10:42:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2007", "679", "عملیات توسط Async Request شروع شد", "2025-02-28 10:43:20", "2025-02-28 10:43:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2008", "679", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-02-28 10:43:20", "2025-02-28 10:43:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("3134", "1054", "عملیات توسط WP Cron شروع شد", "2025-11-27 10:47:20", "2025-11-27 09:47:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("3133", "1054", "ایجاد فعالیت", "2025-11-26 10:38:30", "2025-11-26 09:38:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("3193", "1074", "ایجاد فعالیت", "2025-12-12 14:52:04", "2025-12-12 13:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3192", "1072", "عملیات توسط WP Cron کامل شد", "2025-12-12 14:52:04", "2025-12-12 13:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3082", "1037", "ایجاد فعالیت", "2025-11-11 07:14:47", "2025-11-11 06:14:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3125", "1051", "عملیات توسط WP Cron شروع شد", "2025-11-24 09:29:33", "2025-11-24 08:29:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3126", "1051", "عملیات توسط WP Cron کامل شد", "2025-11-24 09:29:33", "2025-11-24 08:29:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3191", "1072", "عملیات توسط WP Cron شروع شد", "2025-12-12 14:52:04", "2025-12-12 13:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3187", "1072", "ایجاد فعالیت", "2025-12-11 14:47:53", "2025-12-11 13:47:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3186", "1071", "عملیات توسط WP Cron کامل شد", "2025-12-11 14:47:53", "2025-12-11 13:47:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3176", "1068", "عملیات توسط WP Cron شروع شد", "2025-12-08 13:39:05", "2025-12-08 12:39:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3177", "1068", "عملیات توسط WP Cron کامل شد", "2025-12-08 13:39:05", "2025-12-08 12:39:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3123", "1050", "عملیات توسط WP Cron کامل شد", "2025-11-23 09:27:45", "2025-11-23 08:27:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3083", "1037", "عملیات توسط WP Cron شروع شد", "2025-11-12 07:15:13", "2025-11-12 06:15:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("3084", "1037", "عملیات توسط WP Cron کامل شد", "2025-11-12 07:15:13", "2025-11-12 06:15:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("3085", "1038", "ایجاد فعالیت", "2025-11-12 07:15:13", "2025-11-12 06:15:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("3113", "1048", "ایجاد فعالیت", "2025-11-20 09:25:32", "2025-11-20 08:25:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("3091", "1040", "ایجاد فعالیت", "2025-11-14 07:39:59", "2025-11-14 06:39:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3092", "1040", "عملیات توسط WP Cron شروع شد", "2025-11-15 07:41:24", "2025-11-15 06:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3093", "1040", "عملیات توسط WP Cron کامل شد", "2025-11-15 07:41:24", "2025-11-15 06:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3094", "1041", "ایجاد فعالیت", "2025-11-15 07:41:24", "2025-11-15 06:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3095", "1041", "عملیات توسط WP Cron شروع شد", "2025-11-16 07:52:56", "2025-11-16 06:52:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("3096", "1041", "عملیات توسط WP Cron کامل شد", "2025-11-16 07:52:56", "2025-11-16 06:52:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("3097", "1042", "ایجاد فعالیت", "2025-11-16 07:52:56", "2025-11-16 06:52:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("3098", "1042", "عملیات توسط WP Cron شروع شد", "2025-11-17 07:53:19", "2025-11-17 06:53:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("3099", "1042", "عملیات توسط WP Cron کامل شد", "2025-11-17 07:53:19", "2025-11-17 06:53:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("3100", "1043", "ایجاد فعالیت", "2025-11-17 07:53:19", "2025-11-17 06:53:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("3101", "1043", "عملیات توسط WP Cron شروع شد", "2025-11-18 07:54:41", "2025-11-18 06:54:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3102", "1043", "عملیات توسط WP Cron کامل شد", "2025-11-18 07:54:41", "2025-11-18 06:54:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3103", "1044", "ایجاد فعالیت", "2025-11-18 07:54:41", "2025-11-18 06:54:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3104", "1044", "عملیات توسط WP Cron شروع شد", "2025-11-19 07:57:18", "2025-11-19 06:57:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3105", "1044", "عملیات توسط WP Cron کامل شد", "2025-11-19 07:57:18", "2025-11-19 06:57:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3106", "1045", "ایجاد فعالیت", "2025-11-19 07:57:18", "2025-11-19 06:57:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3107", "1045", "عملیات توسط WP Cron شروع شد", "2025-11-20 08:14:16", "2025-11-20 07:14:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3108", "1045", "عملیات توسط WP Cron کامل شد", "2025-11-20 08:14:16", "2025-11-20 07:14:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3109", "1046", "ایجاد فعالیت", "2025-11-20 08:14:16", "2025-11-20 07:14:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3110", "1047", "ایجاد فعالیت", "2025-11-20 09:25:18", "2025-11-20 08:25:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3111", "1047", "عملیات توسط WP Cron شروع شد", "2025-11-20 09:25:23", "2025-11-20 08:25:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3112", "1047", "عملیات توسط WP Cron کامل شد", "2025-11-20 09:25:23", "2025-11-20 08:25:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3185", "1071", "عملیات توسط WP Cron شروع شد", "2025-12-11 14:47:53", "2025-12-11 13:47:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3169", "1066", "ایجاد فعالیت", "2025-12-05 13:25:53", "2025-12-05 12:25:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3168", "1065", "عملیات توسط WP Cron کامل شد", "2025-12-05 13:25:53", "2025-12-05 12:25:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3167", "1065", "عملیات توسط WP Cron شروع شد", "2025-12-05 13:25:53", "2025-12-05 12:25:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3166", "1065", "ایجاد فعالیت", "2025-12-04 13:13:34", "2025-12-04 12:13:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3163", "1064", "عملیات توسط WP Cron کامل شد", "2025-12-04 12:09:31", "2025-12-04 11:09:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3164", "1062", "عملیات توسط WP Cron شروع شد", "2025-12-04 13:13:34", "2025-12-04 12:13:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3165", "1062", "عملیات توسط WP Cron کامل شد", "2025-12-04 13:13:34", "2025-12-04 12:13:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3159", "1063", "عملیات توسط WP Cron شروع شد", "2025-12-03 21:34:44", "2025-12-03 20:34:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3160", "1063", "عملیات توسط WP Cron کامل شد", "2025-12-03 21:34:44", "2025-12-03 20:34:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3175", "1068", "ایجاد فعالیت", "2025-12-07 13:34:04", "2025-12-07 12:34:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3174", "1067", "عملیات توسط WP Cron کامل شد", "2025-12-07 13:34:04", "2025-12-07 12:34:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3170", "1066", "عملیات توسط WP Cron شروع شد", "2025-12-06 13:30:21", "2025-12-06 12:30:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3171", "1066", "عملیات توسط WP Cron کامل شد", "2025-12-06 13:30:21", "2025-12-06 12:30:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3172", "1067", "ایجاد فعالیت", "2025-12-06 13:30:21", "2025-12-06 12:30:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3173", "1067", "عملیات توسط WP Cron شروع شد", "2025-12-07 13:34:04", "2025-12-07 12:34:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3157", "1062", "ایجاد فعالیت", "2025-12-03 13:12:12", "2025-12-03 12:12:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("3183", "1070", "عملیات توسط WP Cron کامل شد", "2025-12-10 14:12:47", "2025-12-10 13:12:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3162", "1064", "عملیات توسط WP Cron شروع شد", "2025-12-04 12:09:31", "2025-12-04 11:09:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3161", "1064", "ایجاد فعالیت", "2025-12-04 11:51:44", "2025-12-04 10:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3151", "1060", "ایجاد فعالیت", "2025-12-02 13:07:30", "2025-12-02 12:07:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("3147", "1058", "عملیات توسط WP Cron کامل شد", "2025-12-01 12:38:58", "2025-12-01 11:38:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3148", "1059", "ایجاد فعالیت", "2025-12-01 12:38:58", "2025-12-01 11:38:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3149", "1059", "عملیات توسط WP Cron شروع شد", "2025-12-02 13:07:30", "2025-12-02 12:07:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("3150", "1059", "عملیات توسط WP Cron کامل شد", "2025-12-02 13:07:30", "2025-12-02 12:07:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("3087", "1038", "عملیات توسط WP Cron کامل شد", "2025-11-13 07:33:50", "2025-11-13 06:33:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3086", "1038", "عملیات توسط WP Cron شروع شد", "2025-11-13 07:33:50", "2025-11-13 06:33:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3115", "1048", "عملیات توسط WP Cron کامل شد", "2025-11-20 10:03:49", "2025-11-20 09:03:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3114", "1048", "عملیات توسط WP Cron شروع شد", "2025-11-20 10:03:49", "2025-11-20 09:03:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3182", "1070", "عملیات توسط WP Cron شروع شد", "2025-12-10 14:12:47", "2025-12-10 13:12:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3089", "1039", "عملیات توسط WP Cron شروع شد", "2025-11-14 07:39:58", "2025-11-14 06:39:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3090", "1039", "عملیات توسط WP Cron کامل شد", "2025-11-14 07:39:59", "2025-11-14 06:39:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3153", "1061", "عملیات توسط WP Cron شروع شد", "2025-12-03 00:44:22", "2025-12-02 23:44:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("3152", "1061", "ایجاد فعالیت", "2025-12-03 00:43:44", "2025-12-02 23:43:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3143", "1057", "عملیات توسط WP Cron شروع شد", "2025-11-30 11:13:07", "2025-11-30 10:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("3140", "1056", "عملیات توسط WP Cron شروع شد", "2025-11-29 10:55:57", "2025-11-29 09:55:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3136", "1055", "ایجاد فعالیت", "2025-11-27 10:47:20", "2025-11-27 09:47:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("3137", "1055", "عملیات توسط WP Cron شروع شد", "2025-11-28 10:47:47", "2025-11-28 09:47:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3138", "1055", "عملیات توسط WP Cron کامل شد", "2025-11-28 10:47:47", "2025-11-28 09:47:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3139", "1056", "ایجاد فعالیت", "2025-11-28 10:47:47", "2025-11-28 09:47:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3181", "1070", "ایجاد فعالیت", "2025-12-09 13:45:24", "2025-12-09 12:45:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3184", "1071", "ایجاد فعالیت", "2025-12-10 14:12:47", "2025-12-10 13:12:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3188", "1073", "ایجاد فعالیت", "2025-12-12 00:59:51", "2025-12-11 23:59:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3189", "1073", "عملیات توسط WP Cron شروع شد", "2025-12-12 01:01:20", "2025-12-12 00:01:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("3190", "1073", "عملیات توسط WP Cron کامل شد", "2025-12-12 01:01:20", "2025-12-12 00:01:20");

/* INSERT TABLE DATA: wp_aiowps_audit_log */
INSERT INTO `wp_aiowps_audit_log` VALUES("14", "1", "1", "eric", "104.28.194.6", "info", "successful_login", "{\"successful_login\":{\"username\":\"eric\"}}", "a:22:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:46:\"/home/cp62750/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:132:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:131:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:217;s:4:\"args\";a:1:{i:0;s:132:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:120:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:101:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:498;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:41:\"/home/cp62750/public_html/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:39:\"/home/cp62750/public_html/wp-config.php\";s:4:\"line\";i:102;s:4:\"args\";a:1:{i:0;s:41:\"/home/cp62750/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:39:\"/home/cp62750/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:44:\"/home/cp62750/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:37:\"/home/cp62750/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:35:\"/home/cp62750/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:44:\"/home/cp62750/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1764424822", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("2", "1", "1", "gozo", "37.221.52.181", "info", "successful_login", "{\"successful_login\":{\"username\":\"gozo\"}}", "a:22:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:46:\"/home/cp62750/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:132:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:131:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:217;s:4:\"args\";a:1:{i:0;s:132:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:120:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:101:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:498;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:41:\"/home/cp62750/public_html/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:39:\"/home/cp62750/public_html/wp-config.php\";s:4:\"line\";i:102;s:4:\"args\";a:1:{i:0;s:41:\"/home/cp62750/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:39:\"/home/cp62750/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:44:\"/home/cp62750/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:37:\"/home/cp62750/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:35:\"/home/cp62750/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:44:\"/home/cp62750/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1758201015", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("3", "1", "1", "gozo", "37.221.52.181", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"gozo\",\"force_logout\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:714;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:51:\"/home/cp62750/public_html/wp-includes/pluggable.php\";s:4:\"line\";i:676;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:132:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:809;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:131:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:217;s:4:\"args\";a:1:{i:0;s:132:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:11;a:6:{s:4:\"file\";s:120:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:101:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:498;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:41:\"/home/cp62750/public_html/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:39:\"/home/cp62750/public_html/wp-config.php\";s:4:\"line\";i:102;s:4:\"args\";a:1:{i:0;s:41:\"/home/cp62750/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:39:\"/home/cp62750/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:44:\"/home/cp62750/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:37:\"/home/cp62750/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:35:\"/home/cp62750/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:44:\"/home/cp62750/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1758201021", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4", "1", "1", "eric", "37.221.52.181", "info", "successful_login", "{\"successful_login\":{\"username\":\"eric\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:46:\"/home/cp62750/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:91:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/includes/class-wc-form-handler.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:13:\"process_login\";s:5:\"class\";s:15:\"WC_Form_Handler\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:41:\"/home/cp62750/public_html/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:39:\"/home/cp62750/public_html/wp-config.php\";s:4:\"line\";i:102;s:4:\"args\";a:1:{i:0;s:41:\"/home/cp62750/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:39:\"/home/cp62750/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:44:\"/home/cp62750/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:37:\"/home/cp62750/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:35:\"/home/cp62750/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:44:\"/home/cp62750/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1758201028", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("5", "1", "1", "aghamiri.rad2@gmail.com", "134.98.153.51", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"aghamiri.rad2@gmail.com\",\"known\":false}}", "a:18:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:51:\"/home/cp62750/public_html/wp-includes/pluggable.php\";s:4:\"line\";i:623;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:46:\"/home/cp62750/public_html/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:91:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/includes/class-wc-form-handler.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:13:\"process_login\";s:5:\"class\";s:15:\"WC_Form_Handler\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:41:\"/home/cp62750/public_html/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:39:\"/home/cp62750/public_html/wp-config.php\";s:4:\"line\";i:102;s:4:\"args\";a:1:{i:0;s:41:\"/home/cp62750/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:15;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:39:\"/home/cp62750/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:44:\"/home/cp62750/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:37:\"/home/cp62750/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:35:\"/home/cp62750/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:44:\"/home/cp62750/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1758344050", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("6", "1", "1", "aghamiri.rad2@gmail.com", "134.98.153.51", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"aghamiri.rad2@gmail.com\",\"known\":false}}", "a:18:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:51:\"/home/cp62750/public_html/wp-includes/pluggable.php\";s:4:\"line\";i:623;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:46:\"/home/cp62750/public_html/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:91:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/includes/class-wc-form-handler.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:13:\"process_login\";s:5:\"class\";s:15:\"WC_Form_Handler\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:41:\"/home/cp62750/public_html/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:39:\"/home/cp62750/public_html/wp-config.php\";s:4:\"line\";i:102;s:4:\"args\";a:1:{i:0;s:41:\"/home/cp62750/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:15;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:39:\"/home/cp62750/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:44:\"/home/cp62750/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:37:\"/home/cp62750/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:35:\"/home/cp62750/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:44:\"/home/cp62750/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1758344087", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("7", "1", "1", "Ghazalehmousavi420@gmail.com", "78.46.143.8", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"Ghazalehmousavi420@gmail.com\",\"known\":false}}", "a:18:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:51:\"/home/cp62750/public_html/wp-includes/pluggable.php\";s:4:\"line\";i:623;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:46:\"/home/cp62750/public_html/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:91:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/includes/class-wc-form-handler.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:13:\"process_login\";s:5:\"class\";s:15:\"WC_Form_Handler\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:41:\"/home/cp62750/public_html/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:39:\"/home/cp62750/public_html/wp-config.php\";s:4:\"line\";i:102;s:4:\"args\";a:1:{i:0;s:41:\"/home/cp62750/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:15;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:39:\"/home/cp62750/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:44:\"/home/cp62750/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:37:\"/home/cp62750/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:35:\"/home/cp62750/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:44:\"/home/cp62750/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1758606931", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("8", "1", "1", "", "37.27.123.112", "info", "core_updated", "{\"core_updated\":{\"old_version\":\"6.8.2\",\"new_version\":\"6.8.3\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:145;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"core_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:59:\"/home/cp62750/public_html/wp-admin/includes/update-core.php\";s:4:\"line\";i:1596;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:67:\"/home/cp62750/public_html/wp-admin/includes/class-core-upgrader.php\";s:4:\"line\";i:178;s:8:\"function\";s:11:\"update_core\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:74:\"/home/cp62750/public_html/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:13:\"Core_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:74:\"/home/cp62750/public_html/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:715;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/update.php\";s:4:\"line\";i:861;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/update.php\";s:4:\"line\";i:304;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1759297009", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("9", "1", "1", "", "37.27.123.112", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"core\",\"slug\":\"default\",\"version\":\"6.8.3\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:76:\"/home/cp62750/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:76:\"/home/cp62750/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:74:\"/home/cp62750/public_html/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:74:\"/home/cp62750/public_html/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/update.php\";s:4:\"line\";i:861;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/update.php\";s:4:\"line\";i:304;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1759469978", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("10", "1", "1", "eric", "37.19.95.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"eric\"}}", "a:22:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:46:\"/home/cp62750/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:132:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:131:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:217;s:4:\"args\";a:1:{i:0;s:132:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:120:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:101:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:498;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:41:\"/home/cp62750/public_html/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:39:\"/home/cp62750/public_html/wp-config.php\";s:4:\"line\";i:102;s:4:\"args\";a:1:{i:0;s:41:\"/home/cp62750/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:39:\"/home/cp62750/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:44:\"/home/cp62750/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:37:\"/home/cp62750/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:35:\"/home/cp62750/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:44:\"/home/cp62750/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1762794864", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("11", "1", "1", "", "37.27.127.144", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"core\",\"slug\":\"default\",\"version\":\"6.8.3\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:76:\"/home/cp62750/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:76:\"/home/cp62750/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:74:\"/home/cp62750/public_html/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:74:\"/home/cp62750/public_html/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/update.php\";s:4:\"line\";i:861;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/update.php\";s:4:\"line\";i:304;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1763358102", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("12", "1", "1", "sbesharati.5de@gmail.com", "80.187.124.123", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"sbesharati.5de@gmail.com\",\"known\":false}}", "a:18:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:51:\"/home/cp62750/public_html/wp-includes/pluggable.php\";s:4:\"line\";i:623;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:46:\"/home/cp62750/public_html/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:91:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/includes/class-wc-form-handler.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:13:\"process_login\";s:5:\"class\";s:15:\"WC_Form_Handler\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:41:\"/home/cp62750/public_html/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:39:\"/home/cp62750/public_html/wp-config.php\";s:4:\"line\";i:102;s:4:\"args\";a:1:{i:0;s:41:\"/home/cp62750/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:15;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:39:\"/home/cp62750/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:44:\"/home/cp62750/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:37:\"/home/cp62750/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:35:\"/home/cp62750/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:44:\"/home/cp62750/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1763391812", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("13", "1", "1", "eric", "37.32.37.72", "info", "successful_login", "{\"successful_login\":{\"username\":\"eric\"}}", "a:22:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:46:\"/home/cp62750/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:132:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:131:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:217;s:4:\"args\";a:1:{i:0;s:132:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:120:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:101:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:498;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:41:\"/home/cp62750/public_html/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:39:\"/home/cp62750/public_html/wp-config.php\";s:4:\"line\";i:102;s:4:\"args\";a:1:{i:0;s:41:\"/home/cp62750/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:39:\"/home/cp62750/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:44:\"/home/cp62750/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:37:\"/home/cp62750/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:35:\"/home/cp62750/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:44:\"/home/cp62750/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1764327730", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("15", "1", "1", "", "37.27.127.144", "info", "core_updated", "{\"core_updated\":{\"old_version\":\"6.8.3\",\"new_version\":\"6.9\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:145;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"core_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:59:\"/home/cp62750/public_html/wp-admin/includes/update-core.php\";s:4:\"line\";i:1603;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:67:\"/home/cp62750/public_html/wp-admin/includes/class-core-upgrader.php\";s:4:\"line\";i:178;s:8:\"function\";s:11:\"update_core\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:74:\"/home/cp62750/public_html/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:13:\"Core_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:74:\"/home/cp62750/public_html/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:715;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/update.php\";s:4:\"line\";i:861;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/update.php\";s:4:\"line\";i:304;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1764742618", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("16", "1", "1", "", "37.27.127.144", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"core\",\"slug\":\"default\",\"version\":\"6.9\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:76:\"/home/cp62750/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:76:\"/home/cp62750/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:74:\"/home/cp62750/public_html/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:74:\"/home/cp62750/public_html/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/update.php\";s:4:\"line\";i:890;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/update.php\";s:4:\"line\";i:337;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1764783480", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("17", "1", "1", "", "37.27.127.144", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"core\",\"slug\":\"default\",\"version\":\"6.9\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:76:\"/home/cp62750/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:76:\"/home/cp62750/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:74:\"/home/cp62750/public_html/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:74:\"/home/cp62750/public_html/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/update.php\";s:4:\"line\";i:890;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/update.php\";s:4:\"line\";i:337;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1765000422", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("18", "1", "1", "eric", "190.103.176.32", "info", "successful_login", "{\"successful_login\":{\"username\":\"eric\"}}", "a:22:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:115:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:46:\"/home/cp62750/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:132:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:131:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:217;s:4:\"args\";a:1:{i:0;s:132:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:120:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:101:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:498;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:41:\"/home/cp62750/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:39:\"/home/cp62750/public_html/wp-config.php\";s:4:\"line\";i:102;s:4:\"args\";a:1:{i:0;s:41:\"/home/cp62750/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:37:\"/home/cp62750/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:39:\"/home/cp62750/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:44:\"/home/cp62750/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:37:\"/home/cp62750/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:35:\"/home/cp62750/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:44:\"/home/cp62750/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1765602666", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("19", "1", "1", "eric", "190.103.176.32", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Duplicator\",\"version\":\"1.5.14\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:65:\"/home/cp62750/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:69:\"/home/cp62750/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:60:\"/home/cp62750/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:49:\"/home/cp62750/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1765602737", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("20", "1", "1", "eric", "190.103.176.32", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"duplicator\",\"version\":\"1.5.14\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:76:\"/home/cp62750/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:76:\"/home/cp62750/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:65:\"/home/cp62750/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:69:\"/home/cp62750/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:60:\"/home/cp62750/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:49:\"/home/cp62750/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1765602742", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("21", "1", "1", "eric", "190.103.176.32", "info", "plugin_activated", "{\"plugin\":{\"name\":\"\\u062f\\u0627\\u067e\\u0644\\u06cc\\u06a9\\u06cc\\u062a\\u0648\\u0631 - \\u0627\\u0641\\u0632\\u0648\\u0646\\u0647 \\u0645\\u0647\\u0627\\u062c\\u0631\\u062a \\u0648 \\u067e\\u0634\\u062a\\u06cc\\u0628\\u0627\\u0646\\u200c\\u06af\\u06cc\\u0631\\u06cc \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633\",\"version\":\"1.5.14\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:117:\"/home/cp62750/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:55:\"/home/cp62750/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:48:\"/home/cp62750/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:54:\"/home/cp62750/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:46:\"/home/cp62750/public_html/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1765602792", "");

/* INSERT TABLE DATA: wp_aiowps_logged_in_users */
INSERT INTO `wp_aiowps_logged_in_users` VALUES("5", "1", "eric", "190.103.176.32", "1", "1765602666", "1765775466");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("84", "53", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("83", "53", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("85", "52", "_wp_trash_meta_status", "0");
INSERT INTO `wp_commentmeta` VALUES("86", "52", "_wp_trash_meta_time", "1764327860");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("52", "1454", "MyBlog", "", "http://mnbdaa.com", "185.36.81.36", "2025-08-14 11:21:53", "2025-08-14 11:21:53", "<strong>itstitle</strong>\n\nexcerptsa", "0", "spam", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "trackback", "0", "0");
INSERT INTO `wp_comments` VALUES("53", "1683", "Ayda", "aida.sepehri@tahoo.com", "", "2.177.241.113", "2025-09-18 18:59:15", "2025-09-18 18:59:15", "دیدگاهی ندارم", "0", "0", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_7_11 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/20H360 Instagram 398.0.0.38.81 (iPhone10,6; iOS 16_7_11; en_US; en; scale=3.00; 1125x2436; IABMV/1; 791504951)", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("50", "1728", "ووکامرس", "", "", "", "2025-03-16 12:35:03", "2025-03-16 13:35:03", "وضعیت سفارش از پیش‌نویس به در انتظار پرداخت تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("51", "1728", "ووکامرس", "", "", "", "2025-03-16 12:35:03", "2025-03-16 13:35:03", "در انتظار انتقال مستقیم بانکی(BACS) وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("48", "1692", "ووکامرس", "", "", "", "2025-03-15 20:57:19", "2025-03-15 17:27:19", "وضعیت سفارش از پیش‌نویس به در انتظار پرداخت تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("49", "1692", "ووکامرس", "", "", "", "2025-03-15 20:57:19", "2025-03-15 17:27:19", "در انتظار انتقال مستقیم بانکی(BACS) وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20251213_d8a7d8b1db8cdaa9d8aad8a7d8b1d9", "22cfe313ef2fe4dd4708_20251213051605", "22", "2025-12-13 05:16:34", "eric", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-13 05:16:05\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:8:\"10.11.14\";s:10:\"VersionPHP\";s:6:\"8.1.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:39:\"20251213_d8a7d8b1db8cdaa9d8aad8a7d8b1d9\";s:4:\"Hash\";s:35:\"22cfe313ef2fe4dd4708_20251213051605\";s:8:\"NameHash\";s:75:\"20251213_d8a7d8b1db8cdaa9d8aad8a7d8b1d9_22cfe313ef2fe4dd4708_20251213051605\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20251213_d8a7d8b1db8cdaa9d8aad8a7d8b1d9_22cfe313ef2fe4dd4708_20251213051605_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.3\";s:6:\"WPUser\";s:4:\"eric\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20251213_d8a7d8b1db8cdaa9d8aad8a7d8b1d9_22cfe313ef2fe4dd4708_20251213051605_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/home/cp62750/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1710;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:12408;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-13 05:16:05\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:8:\"10.11.14\";s:10:\"VersionPHP\";s:6:\"8.1.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20251213_d8a7d8b1db8cdaa9d8aad8a7d8b1d9\";s:4:\"Hash\";s:35:\"22cfe313ef2fe4dd4708_20251213051605\";s:8:\"NameHash\";s:75:\"20251213_d8a7d8b1db8cdaa9d8aad8a7d8b1d9_22cfe313ef2fe4dd4708_20251213051605\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20251213_d8a7d8b1db8cdaa9d8aad8a7d8b1d9_22cfe313ef2fe4dd4708_20251213051605_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:39:\"/home/cp62750/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20251213_d8a7d8b1db8cdaa9d8aad8a7d8b1d9_22cfe313ef2fe4dd4708_20251213051605_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:146:\"/home/cp62750/public_html/wp-content/backups-dup-lite/tmp/20251213_d8a7d8b1db8cdaa9d8aad8a7d8b1d9_22cfe313ef2fe4dd4708_20251213051605_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:34:\"/home/cp62750/public_html/wp-admin\";i:1;s:37:\"/home/cp62750/public_html/wp-includes\";i:2;s:46:\"/home/cp62750/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:25:\"/home/cp62750/public_html\";i:1;s:25:\"/home/cp62750/public_html\";i:2;s:36:\"/home/cp62750/public_html/wp-content\";i:3;s:44:\"/home/cp62750/public_html/wp-content/uploads\";i:4;s:44:\"/home/cp62750/public_html/wp-content/plugins\";i:5;s:47:\"/home/cp62750/public_html/wp-content/mu-plugins\";i:6;s:43:\"/home/cp62750/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:57:\"/home/cp62750/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_jetpack_sync_queue */
INSERT INTO `wp_jetpack_sync_queue` VALUES("124", "sync", "jpsq_sync-1740680846.036492-367509-1", "a:6:{i:0;s:14:\"updated_option\";i:1;a:3:{i:0;s:14:\"active_plugins\";i:1;a:9:{i:0;s:27:\"js_composer/js_composer.php\";i:1;s:45:\"livejournal-importer/livejournal-importer.php\";i:2;s:63:\"product-import-export-for-woo/product-import-export-for-woo.php\";i:3;s:29:\"rss-importer/rss-importer.php\";i:4;s:35:\"tumblr-importer/tumblr-importer.php\";i:5;s:19:\"us-core/us-core.php\";i:6;s:45:\"woocommerce-payments/woocommerce-payments.php\";i:7;s:27:\"woocommerce/woocommerce.php\";i:8;s:41:\"wordpress-importer/wordpress-importer.php\";}i:2;a:3:{i:0;s:27:\"js_composer/js_composer.php\";i:5;s:19:\"us-core/us-core.php\";i:7;s:27:\"woocommerce/woocommerce.php\";}}i:2;i:1;i:3;d:1740680846.0362980365753173828125;i:4;b:0;i:5;a:14:{s:13:\"wpcom_user_id\";N;s:16:\"external_user_id\";i:1;s:12:\"display_name\";s:4:\"eric\";s:10:\"user_email\";s:20:\"tabmehrnaz@gmail.com\";s:10:\"user_roles\";a:1:{i:0;s:13:\"administrator\";}s:15:\"translated_role\";s:13:\"administrator\";s:7:\"is_cron\";b:0;s:7:\"is_rest\";b:0;s:9:\"is_xmlrpc\";b:0;s:10:\"is_wp_rest\";b:0;s:7:\"is_ajax\";b:0;s:11:\"is_wp_admin\";b:1;s:6:\"is_cli\";b:0;s:8:\"from_url\";s:42:\"https://erictarot.com/wp-admin/plugins.php\";}}", "2025-02-27 18:27:26");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:26:{i:1765603041;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1765603129;a:2:{s:24:\"aiowps_hourly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:26:\"aios_15_minutes_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"aios-every-15-minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1765604116;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1765604199;a:2:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1765604281;a:2:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1765604288;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1765605999;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765607799;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765607881;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765622560;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765628329;a:1:{s:23:\"aiowps_daily_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765628330;a:1:{s:23:\"aiowps_clean_old_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765643799;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765643805;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765643807;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765644170;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765651081;a:2:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765654960;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765659600;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765810800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765816881;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765902999;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765966422;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766146729;a:1:{s:24:\"aiowps_weekly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766681020;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "https://erictarot.com", "on");
INSERT INTO `wp_options` VALUES("3", "home", "https://erictarot.com", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "اریک تاروت - کارت تاروت - فال تاروت", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "کارت تاروت - فال تاروت - جزوه تاروت - فال روزانه", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "1", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "tabmehrnaz@gmail.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "6", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:213:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:49:\"vc_grid_item/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?vc_grid_item=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"vc_grid_item/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?vc_grid_item=$matches[1]&wc-api=$matches[3]\";s:55:\"vc_grid_item/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"vc_grid_item/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"vc_grid_item/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"vc_grid_item/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1305&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:73:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc/file/transient(/(.*))?/?$\";s:110:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc/file/transient=$matches[6]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:84:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:8:{i:0;s:21:\"ai-tarot/ai-tarot.php\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:25:\"gtranslate/gtranslate.php\";i:4;s:27:\"js_composer/js_composer.php\";i:5;s:19:\"us-core/us-core.php\";i:6;s:27:\"woocommerce/woocommerce.php\";i:7;s:27:\"wp-crontrol/wp-crontrol.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "a:5:{i:0;s:66:\"/home/cp62750/public_html/wp-content/plugins/ai-tarot/ai-tarot.php\";i:2;s:65:\"/home/cp62750/public_html/wp-content/plugins/ai-tarot/ai-tarot.js\";i:3;s:81:\"/home/cp62750/public_html/wp-content/plugins/ai-tarot/tarot_meanings_78cards.json\";i:4;s:70:\"/home/cp62750/public_html/wp-content/themes/webariyo2022/functions.php\";i:5;s:66:\"/home/cp62750/public_html/wp-content/themes/webariyo2022/style.css\";}", "off");
INSERT INTO `wp_options` VALUES("41", "template", "webariyo2022", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "webariyo2022", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "customer", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "60717", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:1:{s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";a:2:{i:0;s:15:\"AIO_WP_Security\";i:1;s:17:\"uninstall_handler\";}}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "Atlantic/Azores", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "1305", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "1696", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1772021325", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:130:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:9:\"edit_post\";b:1;s:9:\"read_post\";b:1;s:11:\"delete_post\";b:1;s:18:\"edit_us_page_block\";b:1;s:18:\"read_us_page_block\";b:1;s:20:\"delete_us_page_block\";b:1;s:19:\"edit_us_page_blocks\";b:1;s:26:\"edit_others_us_page_blocks\";b:1;s:21:\"delete_us_page_blocks\";b:1;s:22:\"publish_us_page_blocks\";b:1;s:27:\"read_private_us_page_blocks\";b:1;s:29:\"delete_private_us_page_blocks\";b:1;s:31:\"delete_published_us_page_blocks\";b:1;s:28:\"delete_others_us_page_blocks\";b:1;s:27:\"edit_private_us_page_blocks\";b:1;s:29:\"edit_published_us_page_blocks\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "WPLANG", "fa_IR", "auto");
INSERT INTO `wp_options` VALUES("105", "user_count", "3", "off");
INSERT INTO `wp_options` VALUES("106", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("107", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("122", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:3:\"6.9\";s:5:\"files\";a:584:{i:0;s:31:\"accordion-heading/style-rtl.css\";i:1;s:35:\"accordion-heading/style-rtl.min.css\";i:2;s:27:\"accordion-heading/style.css\";i:3;s:31:\"accordion-heading/style.min.css\";i:4;s:28:\"accordion-item/style-rtl.css\";i:5;s:32:\"accordion-item/style-rtl.min.css\";i:6;s:24:\"accordion-item/style.css\";i:7;s:28:\"accordion-item/style.min.css\";i:8;s:29:\"accordion-panel/style-rtl.css\";i:9;s:33:\"accordion-panel/style-rtl.min.css\";i:10;s:25:\"accordion-panel/style.css\";i:11;s:29:\"accordion-panel/style.min.css\";i:12;s:23:\"accordion/style-rtl.css\";i:13;s:27:\"accordion/style-rtl.min.css\";i:14;s:19:\"accordion/style.css\";i:15;s:23:\"accordion/style.min.css\";i:16;s:23:\"archives/editor-rtl.css\";i:17;s:27:\"archives/editor-rtl.min.css\";i:18;s:19:\"archives/editor.css\";i:19;s:23:\"archives/editor.min.css\";i:20;s:22:\"archives/style-rtl.css\";i:21;s:26:\"archives/style-rtl.min.css\";i:22;s:18:\"archives/style.css\";i:23;s:22:\"archives/style.min.css\";i:24;s:20:\"audio/editor-rtl.css\";i:25;s:24:\"audio/editor-rtl.min.css\";i:26;s:16:\"audio/editor.css\";i:27;s:20:\"audio/editor.min.css\";i:28;s:19:\"audio/style-rtl.css\";i:29;s:23:\"audio/style-rtl.min.css\";i:30;s:15:\"audio/style.css\";i:31;s:19:\"audio/style.min.css\";i:32;s:19:\"audio/theme-rtl.css\";i:33;s:23:\"audio/theme-rtl.min.css\";i:34;s:15:\"audio/theme.css\";i:35;s:19:\"audio/theme.min.css\";i:36;s:21:\"avatar/editor-rtl.css\";i:37;s:25:\"avatar/editor-rtl.min.css\";i:38;s:17:\"avatar/editor.css\";i:39;s:21:\"avatar/editor.min.css\";i:40;s:20:\"avatar/style-rtl.css\";i:41;s:24:\"avatar/style-rtl.min.css\";i:42;s:16:\"avatar/style.css\";i:43;s:20:\"avatar/style.min.css\";i:44;s:21:\"button/editor-rtl.css\";i:45;s:25:\"button/editor-rtl.min.css\";i:46;s:17:\"button/editor.css\";i:47;s:21:\"button/editor.min.css\";i:48;s:20:\"button/style-rtl.css\";i:49;s:24:\"button/style-rtl.min.css\";i:50;s:16:\"button/style.css\";i:51;s:20:\"button/style.min.css\";i:52;s:22:\"buttons/editor-rtl.css\";i:53;s:26:\"buttons/editor-rtl.min.css\";i:54;s:18:\"buttons/editor.css\";i:55;s:22:\"buttons/editor.min.css\";i:56;s:21:\"buttons/style-rtl.css\";i:57;s:25:\"buttons/style-rtl.min.css\";i:58;s:17:\"buttons/style.css\";i:59;s:21:\"buttons/style.min.css\";i:60;s:22:\"calendar/style-rtl.css\";i:61;s:26:\"calendar/style-rtl.min.css\";i:62;s:18:\"calendar/style.css\";i:63;s:22:\"calendar/style.min.css\";i:64;s:25:\"categories/editor-rtl.css\";i:65;s:29:\"categories/editor-rtl.min.css\";i:66;s:21:\"categories/editor.css\";i:67;s:25:\"categories/editor.min.css\";i:68;s:24:\"categories/style-rtl.css\";i:69;s:28:\"categories/style-rtl.min.css\";i:70;s:20:\"categories/style.css\";i:71;s:24:\"categories/style.min.css\";i:72;s:19:\"code/editor-rtl.css\";i:73;s:23:\"code/editor-rtl.min.css\";i:74;s:15:\"code/editor.css\";i:75;s:19:\"code/editor.min.css\";i:76;s:18:\"code/style-rtl.css\";i:77;s:22:\"code/style-rtl.min.css\";i:78;s:14:\"code/style.css\";i:79;s:18:\"code/style.min.css\";i:80;s:18:\"code/theme-rtl.css\";i:81;s:22:\"code/theme-rtl.min.css\";i:82;s:14:\"code/theme.css\";i:83;s:18:\"code/theme.min.css\";i:84;s:22:\"columns/editor-rtl.css\";i:85;s:26:\"columns/editor-rtl.min.css\";i:86;s:18:\"columns/editor.css\";i:87;s:22:\"columns/editor.min.css\";i:88;s:21:\"columns/style-rtl.css\";i:89;s:25:\"columns/style-rtl.min.css\";i:90;s:17:\"columns/style.css\";i:91;s:21:\"columns/style.min.css\";i:92;s:33:\"comment-author-name/style-rtl.css\";i:93;s:37:\"comment-author-name/style-rtl.min.css\";i:94;s:29:\"comment-author-name/style.css\";i:95;s:33:\"comment-author-name/style.min.css\";i:96;s:29:\"comment-content/style-rtl.css\";i:97;s:33:\"comment-content/style-rtl.min.css\";i:98;s:25:\"comment-content/style.css\";i:99;s:29:\"comment-content/style.min.css\";i:100;s:26:\"comment-date/style-rtl.css\";i:101;s:30:\"comment-date/style-rtl.min.css\";i:102;s:22:\"comment-date/style.css\";i:103;s:26:\"comment-date/style.min.css\";i:104;s:31:\"comment-edit-link/style-rtl.css\";i:105;s:35:\"comment-edit-link/style-rtl.min.css\";i:106;s:27:\"comment-edit-link/style.css\";i:107;s:31:\"comment-edit-link/style.min.css\";i:108;s:32:\"comment-reply-link/style-rtl.css\";i:109;s:36:\"comment-reply-link/style-rtl.min.css\";i:110;s:28:\"comment-reply-link/style.css\";i:111;s:32:\"comment-reply-link/style.min.css\";i:112;s:30:\"comment-template/style-rtl.css\";i:113;s:34:\"comment-template/style-rtl.min.css\";i:114;s:26:\"comment-template/style.css\";i:115;s:30:\"comment-template/style.min.css\";i:116;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:117;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:118;s:38:\"comments-pagination-numbers/editor.css\";i:119;s:42:\"comments-pagination-numbers/editor.min.css\";i:120;s:34:\"comments-pagination/editor-rtl.css\";i:121;s:38:\"comments-pagination/editor-rtl.min.css\";i:122;s:30:\"comments-pagination/editor.css\";i:123;s:34:\"comments-pagination/editor.min.css\";i:124;s:33:\"comments-pagination/style-rtl.css\";i:125;s:37:\"comments-pagination/style-rtl.min.css\";i:126;s:29:\"comments-pagination/style.css\";i:127;s:33:\"comments-pagination/style.min.css\";i:128;s:29:\"comments-title/editor-rtl.css\";i:129;s:33:\"comments-title/editor-rtl.min.css\";i:130;s:25:\"comments-title/editor.css\";i:131;s:29:\"comments-title/editor.min.css\";i:132;s:23:\"comments/editor-rtl.css\";i:133;s:27:\"comments/editor-rtl.min.css\";i:134;s:19:\"comments/editor.css\";i:135;s:23:\"comments/editor.min.css\";i:136;s:22:\"comments/style-rtl.css\";i:137;s:26:\"comments/style-rtl.min.css\";i:138;s:18:\"comments/style.css\";i:139;s:22:\"comments/style.min.css\";i:140;s:20:\"cover/editor-rtl.css\";i:141;s:24:\"cover/editor-rtl.min.css\";i:142;s:16:\"cover/editor.css\";i:143;s:20:\"cover/editor.min.css\";i:144;s:19:\"cover/style-rtl.css\";i:145;s:23:\"cover/style-rtl.min.css\";i:146;s:15:\"cover/style.css\";i:147;s:19:\"cover/style.min.css\";i:148;s:22:\"details/editor-rtl.css\";i:149;s:26:\"details/editor-rtl.min.css\";i:150;s:18:\"details/editor.css\";i:151;s:22:\"details/editor.min.css\";i:152;s:21:\"details/style-rtl.css\";i:153;s:25:\"details/style-rtl.min.css\";i:154;s:17:\"details/style.css\";i:155;s:21:\"details/style.min.css\";i:156;s:20:\"embed/editor-rtl.css\";i:157;s:24:\"embed/editor-rtl.min.css\";i:158;s:16:\"embed/editor.css\";i:159;s:20:\"embed/editor.min.css\";i:160;s:19:\"embed/style-rtl.css\";i:161;s:23:\"embed/style-rtl.min.css\";i:162;s:15:\"embed/style.css\";i:163;s:19:\"embed/style.min.css\";i:164;s:19:\"embed/theme-rtl.css\";i:165;s:23:\"embed/theme-rtl.min.css\";i:166;s:15:\"embed/theme.css\";i:167;s:19:\"embed/theme.min.css\";i:168;s:19:\"file/editor-rtl.css\";i:169;s:23:\"file/editor-rtl.min.css\";i:170;s:15:\"file/editor.css\";i:171;s:19:\"file/editor.min.css\";i:172;s:18:\"file/style-rtl.css\";i:173;s:22:\"file/style-rtl.min.css\";i:174;s:14:\"file/style.css\";i:175;s:18:\"file/style.min.css\";i:176;s:23:\"footnotes/style-rtl.css\";i:177;s:27:\"footnotes/style-rtl.min.css\";i:178;s:19:\"footnotes/style.css\";i:179;s:23:\"footnotes/style.min.css\";i:180;s:23:\"freeform/editor-rtl.css\";i:181;s:27:\"freeform/editor-rtl.min.css\";i:182;s:19:\"freeform/editor.css\";i:183;s:23:\"freeform/editor.min.css\";i:184;s:22:\"gallery/editor-rtl.css\";i:185;s:26:\"gallery/editor-rtl.min.css\";i:186;s:18:\"gallery/editor.css\";i:187;s:22:\"gallery/editor.min.css\";i:188;s:21:\"gallery/style-rtl.css\";i:189;s:25:\"gallery/style-rtl.min.css\";i:190;s:17:\"gallery/style.css\";i:191;s:21:\"gallery/style.min.css\";i:192;s:21:\"gallery/theme-rtl.css\";i:193;s:25:\"gallery/theme-rtl.min.css\";i:194;s:17:\"gallery/theme.css\";i:195;s:21:\"gallery/theme.min.css\";i:196;s:20:\"group/editor-rtl.css\";i:197;s:24:\"group/editor-rtl.min.css\";i:198;s:16:\"group/editor.css\";i:199;s:20:\"group/editor.min.css\";i:200;s:19:\"group/style-rtl.css\";i:201;s:23:\"group/style-rtl.min.css\";i:202;s:15:\"group/style.css\";i:203;s:19:\"group/style.min.css\";i:204;s:19:\"group/theme-rtl.css\";i:205;s:23:\"group/theme-rtl.min.css\";i:206;s:15:\"group/theme.css\";i:207;s:19:\"group/theme.min.css\";i:208;s:21:\"heading/style-rtl.css\";i:209;s:25:\"heading/style-rtl.min.css\";i:210;s:17:\"heading/style.css\";i:211;s:21:\"heading/style.min.css\";i:212;s:19:\"html/editor-rtl.css\";i:213;s:23:\"html/editor-rtl.min.css\";i:214;s:15:\"html/editor.css\";i:215;s:19:\"html/editor.min.css\";i:216;s:20:\"image/editor-rtl.css\";i:217;s:24:\"image/editor-rtl.min.css\";i:218;s:16:\"image/editor.css\";i:219;s:20:\"image/editor.min.css\";i:220;s:19:\"image/style-rtl.css\";i:221;s:23:\"image/style-rtl.min.css\";i:222;s:15:\"image/style.css\";i:223;s:19:\"image/style.min.css\";i:224;s:19:\"image/theme-rtl.css\";i:225;s:23:\"image/theme-rtl.min.css\";i:226;s:15:\"image/theme.css\";i:227;s:19:\"image/theme.min.css\";i:228;s:29:\"latest-comments/style-rtl.css\";i:229;s:33:\"latest-comments/style-rtl.min.css\";i:230;s:25:\"latest-comments/style.css\";i:231;s:29:\"latest-comments/style.min.css\";i:232;s:27:\"latest-posts/editor-rtl.css\";i:233;s:31:\"latest-posts/editor-rtl.min.css\";i:234;s:23:\"latest-posts/editor.css\";i:235;s:27:\"latest-posts/editor.min.css\";i:236;s:26:\"latest-posts/style-rtl.css\";i:237;s:30:\"latest-posts/style-rtl.min.css\";i:238;s:22:\"latest-posts/style.css\";i:239;s:26:\"latest-posts/style.min.css\";i:240;s:18:\"list/style-rtl.css\";i:241;s:22:\"list/style-rtl.min.css\";i:242;s:14:\"list/style.css\";i:243;s:18:\"list/style.min.css\";i:244;s:22:\"loginout/style-rtl.css\";i:245;s:26:\"loginout/style-rtl.min.css\";i:246;s:18:\"loginout/style.css\";i:247;s:22:\"loginout/style.min.css\";i:248;s:19:\"math/editor-rtl.css\";i:249;s:23:\"math/editor-rtl.min.css\";i:250;s:15:\"math/editor.css\";i:251;s:19:\"math/editor.min.css\";i:252;s:18:\"math/style-rtl.css\";i:253;s:22:\"math/style-rtl.min.css\";i:254;s:14:\"math/style.css\";i:255;s:18:\"math/style.min.css\";i:256;s:25:\"media-text/editor-rtl.css\";i:257;s:29:\"media-text/editor-rtl.min.css\";i:258;s:21:\"media-text/editor.css\";i:259;s:25:\"media-text/editor.min.css\";i:260;s:24:\"media-text/style-rtl.css\";i:261;s:28:\"media-text/style-rtl.min.css\";i:262;s:20:\"media-text/style.css\";i:263;s:24:\"media-text/style.min.css\";i:264;s:19:\"more/editor-rtl.css\";i:265;s:23:\"more/editor-rtl.min.css\";i:266;s:15:\"more/editor.css\";i:267;s:19:\"more/editor.min.css\";i:268;s:30:\"navigation-link/editor-rtl.css\";i:269;s:34:\"navigation-link/editor-rtl.min.css\";i:270;s:26:\"navigation-link/editor.css\";i:271;s:30:\"navigation-link/editor.min.css\";i:272;s:29:\"navigation-link/style-rtl.css\";i:273;s:33:\"navigation-link/style-rtl.min.css\";i:274;s:25:\"navigation-link/style.css\";i:275;s:29:\"navigation-link/style.min.css\";i:276;s:33:\"navigation-submenu/editor-rtl.css\";i:277;s:37:\"navigation-submenu/editor-rtl.min.css\";i:278;s:29:\"navigation-submenu/editor.css\";i:279;s:33:\"navigation-submenu/editor.min.css\";i:280;s:25:\"navigation/editor-rtl.css\";i:281;s:29:\"navigation/editor-rtl.min.css\";i:282;s:21:\"navigation/editor.css\";i:283;s:25:\"navigation/editor.min.css\";i:284;s:24:\"navigation/style-rtl.css\";i:285;s:28:\"navigation/style-rtl.min.css\";i:286;s:20:\"navigation/style.css\";i:287;s:24:\"navigation/style.min.css\";i:288;s:23:\"nextpage/editor-rtl.css\";i:289;s:27:\"nextpage/editor-rtl.min.css\";i:290;s:19:\"nextpage/editor.css\";i:291;s:23:\"nextpage/editor.min.css\";i:292;s:24:\"page-list/editor-rtl.css\";i:293;s:28:\"page-list/editor-rtl.min.css\";i:294;s:20:\"page-list/editor.css\";i:295;s:24:\"page-list/editor.min.css\";i:296;s:23:\"page-list/style-rtl.css\";i:297;s:27:\"page-list/style-rtl.min.css\";i:298;s:19:\"page-list/style.css\";i:299;s:23:\"page-list/style.min.css\";i:300;s:24:\"paragraph/editor-rtl.css\";i:301;s:28:\"paragraph/editor-rtl.min.css\";i:302;s:20:\"paragraph/editor.css\";i:303;s:24:\"paragraph/editor.min.css\";i:304;s:23:\"paragraph/style-rtl.css\";i:305;s:27:\"paragraph/style-rtl.min.css\";i:306;s:19:\"paragraph/style.css\";i:307;s:23:\"paragraph/style.min.css\";i:308;s:35:\"post-author-biography/style-rtl.css\";i:309;s:39:\"post-author-biography/style-rtl.min.css\";i:310;s:31:\"post-author-biography/style.css\";i:311;s:35:\"post-author-biography/style.min.css\";i:312;s:30:\"post-author-name/style-rtl.css\";i:313;s:34:\"post-author-name/style-rtl.min.css\";i:314;s:26:\"post-author-name/style.css\";i:315;s:30:\"post-author-name/style.min.css\";i:316;s:25:\"post-author/style-rtl.css\";i:317;s:29:\"post-author/style-rtl.min.css\";i:318;s:21:\"post-author/style.css\";i:319;s:25:\"post-author/style.min.css\";i:320;s:33:\"post-comments-count/style-rtl.css\";i:321;s:37:\"post-comments-count/style-rtl.min.css\";i:322;s:29:\"post-comments-count/style.css\";i:323;s:33:\"post-comments-count/style.min.css\";i:324;s:33:\"post-comments-form/editor-rtl.css\";i:325;s:37:\"post-comments-form/editor-rtl.min.css\";i:326;s:29:\"post-comments-form/editor.css\";i:327;s:33:\"post-comments-form/editor.min.css\";i:328;s:32:\"post-comments-form/style-rtl.css\";i:329;s:36:\"post-comments-form/style-rtl.min.css\";i:330;s:28:\"post-comments-form/style.css\";i:331;s:32:\"post-comments-form/style.min.css\";i:332;s:32:\"post-comments-link/style-rtl.css\";i:333;s:36:\"post-comments-link/style-rtl.min.css\";i:334;s:28:\"post-comments-link/style.css\";i:335;s:32:\"post-comments-link/style.min.css\";i:336;s:26:\"post-content/style-rtl.css\";i:337;s:30:\"post-content/style-rtl.min.css\";i:338;s:22:\"post-content/style.css\";i:339;s:26:\"post-content/style.min.css\";i:340;s:23:\"post-date/style-rtl.css\";i:341;s:27:\"post-date/style-rtl.min.css\";i:342;s:19:\"post-date/style.css\";i:343;s:23:\"post-date/style.min.css\";i:344;s:27:\"post-excerpt/editor-rtl.css\";i:345;s:31:\"post-excerpt/editor-rtl.min.css\";i:346;s:23:\"post-excerpt/editor.css\";i:347;s:27:\"post-excerpt/editor.min.css\";i:348;s:26:\"post-excerpt/style-rtl.css\";i:349;s:30:\"post-excerpt/style-rtl.min.css\";i:350;s:22:\"post-excerpt/style.css\";i:351;s:26:\"post-excerpt/style.min.css\";i:352;s:34:\"post-featured-image/editor-rtl.css\";i:353;s:38:\"post-featured-image/editor-rtl.min.css\";i:354;s:30:\"post-featured-image/editor.css\";i:355;s:34:\"post-featured-image/editor.min.css\";i:356;s:33:\"post-featured-image/style-rtl.css\";i:357;s:37:\"post-featured-image/style-rtl.min.css\";i:358;s:29:\"post-featured-image/style.css\";i:359;s:33:\"post-featured-image/style.min.css\";i:360;s:34:\"post-navigation-link/style-rtl.css\";i:361;s:38:\"post-navigation-link/style-rtl.min.css\";i:362;s:30:\"post-navigation-link/style.css\";i:363;s:34:\"post-navigation-link/style.min.css\";i:364;s:27:\"post-template/style-rtl.css\";i:365;s:31:\"post-template/style-rtl.min.css\";i:366;s:23:\"post-template/style.css\";i:367;s:27:\"post-template/style.min.css\";i:368;s:24:\"post-terms/style-rtl.css\";i:369;s:28:\"post-terms/style-rtl.min.css\";i:370;s:20:\"post-terms/style.css\";i:371;s:24:\"post-terms/style.min.css\";i:372;s:31:\"post-time-to-read/style-rtl.css\";i:373;s:35:\"post-time-to-read/style-rtl.min.css\";i:374;s:27:\"post-time-to-read/style.css\";i:375;s:31:\"post-time-to-read/style.min.css\";i:376;s:24:\"post-title/style-rtl.css\";i:377;s:28:\"post-title/style-rtl.min.css\";i:378;s:20:\"post-title/style.css\";i:379;s:24:\"post-title/style.min.css\";i:380;s:26:\"preformatted/style-rtl.css\";i:381;s:30:\"preformatted/style-rtl.min.css\";i:382;s:22:\"preformatted/style.css\";i:383;s:26:\"preformatted/style.min.css\";i:384;s:24:\"pullquote/editor-rtl.css\";i:385;s:28:\"pullquote/editor-rtl.min.css\";i:386;s:20:\"pullquote/editor.css\";i:387;s:24:\"pullquote/editor.min.css\";i:388;s:23:\"pullquote/style-rtl.css\";i:389;s:27:\"pullquote/style-rtl.min.css\";i:390;s:19:\"pullquote/style.css\";i:391;s:23:\"pullquote/style.min.css\";i:392;s:23:\"pullquote/theme-rtl.css\";i:393;s:27:\"pullquote/theme-rtl.min.css\";i:394;s:19:\"pullquote/theme.css\";i:395;s:23:\"pullquote/theme.min.css\";i:396;s:39:\"query-pagination-numbers/editor-rtl.css\";i:397;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:398;s:35:\"query-pagination-numbers/editor.css\";i:399;s:39:\"query-pagination-numbers/editor.min.css\";i:400;s:31:\"query-pagination/editor-rtl.css\";i:401;s:35:\"query-pagination/editor-rtl.min.css\";i:402;s:27:\"query-pagination/editor.css\";i:403;s:31:\"query-pagination/editor.min.css\";i:404;s:30:\"query-pagination/style-rtl.css\";i:405;s:34:\"query-pagination/style-rtl.min.css\";i:406;s:26:\"query-pagination/style.css\";i:407;s:30:\"query-pagination/style.min.css\";i:408;s:25:\"query-title/style-rtl.css\";i:409;s:29:\"query-title/style-rtl.min.css\";i:410;s:21:\"query-title/style.css\";i:411;s:25:\"query-title/style.min.css\";i:412;s:25:\"query-total/style-rtl.css\";i:413;s:29:\"query-total/style-rtl.min.css\";i:414;s:21:\"query-total/style.css\";i:415;s:25:\"query-total/style.min.css\";i:416;s:20:\"query/editor-rtl.css\";i:417;s:24:\"query/editor-rtl.min.css\";i:418;s:16:\"query/editor.css\";i:419;s:20:\"query/editor.min.css\";i:420;s:19:\"quote/style-rtl.css\";i:421;s:23:\"quote/style-rtl.min.css\";i:422;s:15:\"quote/style.css\";i:423;s:19:\"quote/style.min.css\";i:424;s:19:\"quote/theme-rtl.css\";i:425;s:23:\"quote/theme-rtl.min.css\";i:426;s:15:\"quote/theme.css\";i:427;s:19:\"quote/theme.min.css\";i:428;s:23:\"read-more/style-rtl.css\";i:429;s:27:\"read-more/style-rtl.min.css\";i:430;s:19:\"read-more/style.css\";i:431;s:23:\"read-more/style.min.css\";i:432;s:18:\"rss/editor-rtl.css\";i:433;s:22:\"rss/editor-rtl.min.css\";i:434;s:14:\"rss/editor.css\";i:435;s:18:\"rss/editor.min.css\";i:436;s:17:\"rss/style-rtl.css\";i:437;s:21:\"rss/style-rtl.min.css\";i:438;s:13:\"rss/style.css\";i:439;s:17:\"rss/style.min.css\";i:440;s:21:\"search/editor-rtl.css\";i:441;s:25:\"search/editor-rtl.min.css\";i:442;s:17:\"search/editor.css\";i:443;s:21:\"search/editor.min.css\";i:444;s:20:\"search/style-rtl.css\";i:445;s:24:\"search/style-rtl.min.css\";i:446;s:16:\"search/style.css\";i:447;s:20:\"search/style.min.css\";i:448;s:20:\"search/theme-rtl.css\";i:449;s:24:\"search/theme-rtl.min.css\";i:450;s:16:\"search/theme.css\";i:451;s:20:\"search/theme.min.css\";i:452;s:24:\"separator/editor-rtl.css\";i:453;s:28:\"separator/editor-rtl.min.css\";i:454;s:20:\"separator/editor.css\";i:455;s:24:\"separator/editor.min.css\";i:456;s:23:\"separator/style-rtl.css\";i:457;s:27:\"separator/style-rtl.min.css\";i:458;s:19:\"separator/style.css\";i:459;s:23:\"separator/style.min.css\";i:460;s:23:\"separator/theme-rtl.css\";i:461;s:27:\"separator/theme-rtl.min.css\";i:462;s:19:\"separator/theme.css\";i:463;s:23:\"separator/theme.min.css\";i:464;s:24:\"shortcode/editor-rtl.css\";i:465;s:28:\"shortcode/editor-rtl.min.css\";i:466;s:20:\"shortcode/editor.css\";i:467;s:24:\"shortcode/editor.min.css\";i:468;s:24:\"site-logo/editor-rtl.css\";i:469;s:28:\"site-logo/editor-rtl.min.css\";i:470;s:20:\"site-logo/editor.css\";i:471;s:24:\"site-logo/editor.min.css\";i:472;s:23:\"site-logo/style-rtl.css\";i:473;s:27:\"site-logo/style-rtl.min.css\";i:474;s:19:\"site-logo/style.css\";i:475;s:23:\"site-logo/style.min.css\";i:476;s:27:\"site-tagline/editor-rtl.css\";i:477;s:31:\"site-tagline/editor-rtl.min.css\";i:478;s:23:\"site-tagline/editor.css\";i:479;s:27:\"site-tagline/editor.min.css\";i:480;s:26:\"site-tagline/style-rtl.css\";i:481;s:30:\"site-tagline/style-rtl.min.css\";i:482;s:22:\"site-tagline/style.css\";i:483;s:26:\"site-tagline/style.min.css\";i:484;s:25:\"site-title/editor-rtl.css\";i:485;s:29:\"site-title/editor-rtl.min.css\";i:486;s:21:\"site-title/editor.css\";i:487;s:25:\"site-title/editor.min.css\";i:488;s:24:\"site-title/style-rtl.css\";i:489;s:28:\"site-title/style-rtl.min.css\";i:490;s:20:\"site-title/style.css\";i:491;s:24:\"site-title/style.min.css\";i:492;s:26:\"social-link/editor-rtl.css\";i:493;s:30:\"social-link/editor-rtl.min.css\";i:494;s:22:\"social-link/editor.css\";i:495;s:26:\"social-link/editor.min.css\";i:496;s:27:\"social-links/editor-rtl.css\";i:497;s:31:\"social-links/editor-rtl.min.css\";i:498;s:23:\"social-links/editor.css\";i:499;s:27:\"social-links/editor.min.css\";i:500;s:26:\"social-links/style-rtl.css\";i:501;s:30:\"social-links/style-rtl.min.css\";i:502;s:22:\"social-links/style.css\";i:503;s:26:\"social-links/style.min.css\";i:504;s:21:\"spacer/editor-rtl.css\";i:505;s:25:\"spacer/editor-rtl.min.css\";i:506;s:17:\"spacer/editor.css\";i:507;s:21:\"spacer/editor.min.css\";i:508;s:20:\"spacer/style-rtl.css\";i:509;s:24:\"spacer/style-rtl.min.css\";i:510;s:16:\"spacer/style.css\";i:511;s:20:\"spacer/style.min.css\";i:512;s:20:\"table/editor-rtl.css\";i:513;s:24:\"table/editor-rtl.min.css\";i:514;s:16:\"table/editor.css\";i:515;s:20:\"table/editor.min.css\";i:516;s:19:\"table/style-rtl.css\";i:517;s:23:\"table/style-rtl.min.css\";i:518;s:15:\"table/style.css\";i:519;s:19:\"table/style.min.css\";i:520;s:19:\"table/theme-rtl.css\";i:521;s:23:\"table/theme-rtl.min.css\";i:522;s:15:\"table/theme.css\";i:523;s:19:\"table/theme.min.css\";i:524;s:24:\"tag-cloud/editor-rtl.css\";i:525;s:28:\"tag-cloud/editor-rtl.min.css\";i:526;s:20:\"tag-cloud/editor.css\";i:527;s:24:\"tag-cloud/editor.min.css\";i:528;s:23:\"tag-cloud/style-rtl.css\";i:529;s:27:\"tag-cloud/style-rtl.min.css\";i:530;s:19:\"tag-cloud/style.css\";i:531;s:23:\"tag-cloud/style.min.css\";i:532;s:28:\"template-part/editor-rtl.css\";i:533;s:32:\"template-part/editor-rtl.min.css\";i:534;s:24:\"template-part/editor.css\";i:535;s:28:\"template-part/editor.min.css\";i:536;s:27:\"template-part/theme-rtl.css\";i:537;s:31:\"template-part/theme-rtl.min.css\";i:538;s:23:\"template-part/theme.css\";i:539;s:27:\"template-part/theme.min.css\";i:540;s:24:\"term-count/style-rtl.css\";i:541;s:28:\"term-count/style-rtl.min.css\";i:542;s:20:\"term-count/style.css\";i:543;s:24:\"term-count/style.min.css\";i:544;s:30:\"term-description/style-rtl.css\";i:545;s:34:\"term-description/style-rtl.min.css\";i:546;s:26:\"term-description/style.css\";i:547;s:30:\"term-description/style.min.css\";i:548;s:23:\"term-name/style-rtl.css\";i:549;s:27:\"term-name/style-rtl.min.css\";i:550;s:19:\"term-name/style.css\";i:551;s:23:\"term-name/style.min.css\";i:552;s:28:\"term-template/editor-rtl.css\";i:553;s:32:\"term-template/editor-rtl.min.css\";i:554;s:24:\"term-template/editor.css\";i:555;s:28:\"term-template/editor.min.css\";i:556;s:27:\"term-template/style-rtl.css\";i:557;s:31:\"term-template/style-rtl.min.css\";i:558;s:23:\"term-template/style.css\";i:559;s:27:\"term-template/style.min.css\";i:560;s:27:\"text-columns/editor-rtl.css\";i:561;s:31:\"text-columns/editor-rtl.min.css\";i:562;s:23:\"text-columns/editor.css\";i:563;s:27:\"text-columns/editor.min.css\";i:564;s:26:\"text-columns/style-rtl.css\";i:565;s:30:\"text-columns/style-rtl.min.css\";i:566;s:22:\"text-columns/style.css\";i:567;s:26:\"text-columns/style.min.css\";i:568;s:19:\"verse/style-rtl.css\";i:569;s:23:\"verse/style-rtl.min.css\";i:570;s:15:\"verse/style.css\";i:571;s:19:\"verse/style.min.css\";i:572;s:20:\"video/editor-rtl.css\";i:573;s:24:\"video/editor-rtl.min.css\";i:574;s:16:\"video/editor.css\";i:575;s:20:\"video/editor.min.css\";i:576;s:19:\"video/style-rtl.css\";i:577;s:23:\"video/style-rtl.min.css\";i:578;s:15:\"video/style.css\";i:579;s:19:\"video/style.min.css\";i:580;s:19:\"video/theme-rtl.css\";i:581;s:23:\"video/theme-rtl.min.css\";i:582;s:15:\"video/theme.css\";i:583;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("160", "us_license_activated", "1", "auto");
INSERT INTO `wp_options` VALUES("163", "usof_options_WebAriyo", "a:392:{s:16:\"maintenance_mode\";i:0;s:22:\"maintenance_mode_alert\";s:0:\"\";s:16:\"maintenance_page\";i:2;s:15:\"maintenance_503\";i:0;s:9:\"site_icon\";s:4:\"1696\";s:10:\"dark_theme\";s:4:\"none\";s:9:\"preloader\";s:8:\"disabled\";s:15:\"preloader_image\";s:0:\"\";s:15:\"img_placeholder\";s:78:\"https://erictarot.com/wp-content/plugins/us-core/assets/images/placeholder.svg\";s:13:\"ripple_effect\";i:0;s:15:\"rounded_corners\";i:1;s:15:\"links_underline\";i:0;s:22:\"keyboard_accessibility\";i:0;s:11:\"back_to_top\";i:1;s:25:\"wrapper_back_to_top_start\";s:0:\"\";s:17:\"back_to_top_style\";s:0:\"\";s:15:\"back_to_top_pos\";s:5:\"right\";s:17:\"back_to_top_color\";s:15:\"rgba(0,0,0,0.3)\";s:19:\"back_to_top_display\";s:5:\"100vh\";s:23:\"wrapper_back_to_top_end\";s:0:\"\";s:13:\"cookie_notice\";i:0;s:20:\"wrapper_cookie_start\";s:0:\"\";s:14:\"cookie_message\";s:106:\"This website uses cookies to improve your experience. If you continue to use this site, you agree with it.\";s:14:\"cookie_privacy\";s:0:\"\";s:18:\"cookie_message_pos\";s:6:\"bottom\";s:16:\"cookie_btn_label\";s:2:\"Ok\";s:16:\"cookie_btn_style\";s:1:\"1\";s:18:\"wrapper_cookie_end\";s:0:\"\";s:22:\"smooth_scroll_duration\";s:6:\"1000ms\";s:13:\"canvas_layout\";s:4:\"wide\";s:13:\"color_body_bg\";s:15:\"_content_bg_alt\";s:13:\"body_bg_image\";s:0:\"\";s:21:\"wrapper_body_bg_start\";s:0:\"\";s:18:\"body_bg_image_size\";s:5:\"cover\";s:20:\"body_bg_image_repeat\";s:6:\"repeat\";s:22:\"body_bg_image_position\";s:8:\"top left\";s:24:\"body_bg_image_attachment\";i:1;s:19:\"wrapper_body_bg_end\";s:0:\"\";s:17:\"site_canvas_width\";s:6:\"1300px\";s:18:\"site_content_width\";s:6:\"1140px\";s:13:\"sidebar_width\";s:3:\"25%\";s:10:\"row_height\";s:6:\"medium\";s:17:\"row_height_custom\";s:5:\"5vmax\";s:18:\"text_bottom_indent\";s:4:\"0rem\";s:13:\"footer_reveal\";b:0;s:21:\"disable_effects_width\";s:5:\"900px\";s:22:\"columns_stacking_width\";s:5:\"768px\";s:18:\"laptops_breakpoint\";s:6:\"1280px\";s:18:\"tablets_breakpoint\";s:6:\"1024px\";s:18:\"mobiles_breakpoint\";s:5:\"600px\";s:11:\"search_page\";s:7:\"default\";s:28:\"exclude_post_types_in_search\";s:0:\"\";s:10:\"posts_page\";s:7:\"default\";s:8:\"page_404\";s:7:\"default\";s:10:\"h_defaults\";s:0:\"\";s:9:\"header_id\";s:4:\"1703\";s:11:\"titlebar_id\";s:0:\"\";s:10:\"content_id\";s:0:\"\";s:10:\"sidebar_id\";s:0:\"\";s:11:\"sidebar_pos\";s:5:\"right\";s:9:\"footer_id\";s:4:\"1726\";s:6:\"h_post\";s:0:\"\";s:14:\"header_post_id\";s:12:\"__defaults__\";s:16:\"titlebar_post_id\";s:12:\"__defaults__\";s:15:\"content_post_id\";s:4:\"1701\";s:15:\"sidebar_post_id\";s:12:\"__defaults__\";s:16:\"sidebar_post_pos\";s:5:\"right\";s:14:\"footer_post_id\";s:12:\"__defaults__\";s:18:\"h_archive_defaults\";s:0:\"\";s:17:\"header_archive_id\";s:12:\"__defaults__\";s:19:\"titlebar_archive_id\";s:12:\"__defaults__\";s:18:\"content_archive_id\";s:0:\"\";s:18:\"sidebar_archive_id\";s:12:\"__defaults__\";s:19:\"sidebar_archive_pos\";s:5:\"right\";s:17:\"footer_archive_id\";s:12:\"__defaults__\";s:14:\"h_tax_category\";s:0:\"\";s:22:\"header_tax_category_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_category_id\";s:12:\"__defaults__\";s:23:\"content_tax_category_id\";s:12:\"__defaults__\";s:23:\"sidebar_tax_category_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_category_pos\";s:5:\"right\";s:22:\"footer_tax_category_id\";s:12:\"__defaults__\";s:14:\"h_tax_post_tag\";s:0:\"\";s:22:\"header_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_post_tag_id\";s:12:\"__defaults__\";s:23:\"content_tax_post_tag_id\";s:12:\"__defaults__\";s:23:\"sidebar_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_post_tag_pos\";s:5:\"right\";s:22:\"footer_tax_post_tag_id\";s:12:\"__defaults__\";s:17:\"h_tax_post_format\";s:0:\"\";s:25:\"header_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"content_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_post_format_pos\";s:5:\"right\";s:25:\"footer_tax_post_format_id\";s:12:\"__defaults__\";s:19:\"h_tax_product_brand\";s:0:\"\";s:27:\"header_tax_product_brand_id\";s:12:\"__defaults__\";s:29:\"titlebar_tax_product_brand_id\";s:12:\"__defaults__\";s:28:\"content_tax_product_brand_id\";s:12:\"__defaults__\";s:28:\"sidebar_tax_product_brand_id\";s:12:\"__defaults__\";s:29:\"sidebar_tax_product_brand_pos\";s:5:\"right\";s:27:\"footer_tax_product_brand_id\";s:12:\"__defaults__\";s:28:\"h_tax_product_shipping_class\";s:0:\"\";s:36:\"header_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:38:\"titlebar_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:37:\"content_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:37:\"sidebar_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:38:\"sidebar_tax_product_shipping_class_pos\";s:5:\"right\";s:36:\"footer_tax_product_shipping_class_id\";s:12:\"__defaults__\";s:9:\"h_authors\";s:0:\"\";s:16:\"header_author_id\";s:12:\"__defaults__\";s:18:\"titlebar_author_id\";s:12:\"__defaults__\";s:17:\"content_author_id\";s:12:\"__defaults__\";s:17:\"sidebar_author_id\";s:12:\"__defaults__\";s:18:\"sidebar_author_pos\";s:5:\"right\";s:16:\"footer_author_id\";s:12:\"__defaults__\";s:19:\"color_header_top_bg\";s:7:\"#000000\";s:21:\"color_header_top_text\";s:7:\"#afb1bd\";s:27:\"color_header_top_text_hover\";s:7:\"#c99b55\";s:22:\"color_header_middle_bg\";s:7:\"#0f0e17\";s:24:\"color_header_middle_text\";s:7:\"#afb1bd\";s:30:\"color_header_middle_text_hover\";s:7:\"#c99b55\";s:29:\"color_header_transparent_text\";s:7:\"#fffffe\";s:35:\"color_header_transparent_text_hover\";s:7:\"#c99b55\";s:20:\"color_chrome_toolbar\";s:7:\"#000000\";s:16:\"color_content_bg\";s:7:\"#0A051C\";s:20:\"color_content_bg_alt\";s:7:\"#c99b55\";s:20:\"color_content_border\";s:7:\"#2e2f3e\";s:21:\"color_content_heading\";s:7:\"#fffffe\";s:18:\"color_content_text\";s:7:\"#f5f5f5\";s:18:\"color_content_link\";s:7:\"#c99b55\";s:24:\"color_content_link_hover\";s:7:\"#d6a55a\";s:21:\"color_content_primary\";s:7:\"#c99b55\";s:23:\"color_content_secondary\";s:7:\"#d6a55a\";s:19:\"color_content_faded\";s:7:\"#72757e\";s:21:\"color_content_overlay\";s:16:\"rgba(0,0,0,0.75)\";s:20:\"color_alt_content_bg\";s:0:\"\";s:24:\"color_alt_content_bg_alt\";s:0:\"\";s:24:\"color_alt_content_border\";s:0:\"\";s:25:\"color_alt_content_heading\";s:0:\"\";s:22:\"color_alt_content_text\";s:0:\"\";s:22:\"color_alt_content_link\";s:0:\"\";s:28:\"color_alt_content_link_hover\";s:0:\"\";s:25:\"color_alt_content_primary\";s:0:\"\";s:27:\"color_alt_content_secondary\";s:0:\"\";s:23:\"color_alt_content_faded\";s:0:\"\";s:25:\"color_alt_content_overlay\";s:0:\"\";s:15:\"color_footer_bg\";s:7:\"#0f0e17\";s:19:\"color_footer_bg_alt\";s:7:\"#000000\";s:19:\"color_footer_border\";s:7:\"#2e2f3e\";s:20:\"color_footer_heading\";s:7:\"#ff8906\";s:17:\"color_footer_text\";s:7:\"#72757e\";s:17:\"color_footer_link\";s:7:\"#afb1bd\";s:23:\"color_footer_link_hover\";s:7:\"#d6a55a\";s:18:\"color_subfooter_bg\";s:0:\"\";s:22:\"color_subfooter_bg_alt\";s:0:\"\";s:22:\"color_subfooter_border\";s:0:\"\";s:23:\"color_subfooter_heading\";s:0:\"\";s:20:\"color_subfooter_text\";s:0:\"\";s:20:\"color_subfooter_link\";s:0:\"\";s:26:\"color_subfooter_link_hover\";s:0:\"\";s:12:\"style_scheme\";i:23;s:26:\"change_header_colors_start\";s:0:\"\";s:10:\"h_colors_1\";s:0:\"\";s:27:\"color_header_transparent_bg\";s:11:\"transparent\";s:24:\"change_header_colors_end\";s:0:\"\";s:30:\"change_header_alt_colors_start\";s:0:\"\";s:10:\"h_colors_2\";s:0:\"\";s:31:\"color_header_top_transparent_bg\";s:15:\"rgba(0,0,0,0.2)\";s:33:\"color_header_top_transparent_text\";s:22:\"rgba(255,255,255,0.66)\";s:39:\"color_header_top_transparent_text_hover\";s:4:\"#fff\";s:28:\"change_header_alt_colors_end\";s:0:\"\";s:27:\"change_content_colors_start\";s:0:\"\";s:10:\"h_colors_3\";s:0:\"\";s:25:\"change_content_colors_end\";s:0:\"\";s:31:\"change_alt_content_colors_start\";s:0:\"\";s:10:\"h_colors_4\";s:0:\"\";s:29:\"change_alt_content_colors_end\";s:0:\"\";s:26:\"change_footer_colors_start\";s:0:\"\";s:10:\"h_colors_6\";s:0:\"\";s:24:\"change_footer_colors_end\";s:0:\"\";s:29:\"change_subfooter_colors_start\";s:0:\"\";s:10:\"h_colors_5\";s:0:\"\";s:27:\"change_subfooter_colors_end\";s:0:\"\";s:16:\"body_font_family\";s:14:\"Uploaded Font|\";s:13:\"body_fontsize\";s:4:\"18px\";s:20:\"body_fontsize_mobile\";s:4:\"16px\";s:15:\"body_lineheight\";s:4:\"28px\";s:22:\"body_lineheight_mobile\";s:4:\"28px\";s:14:\"h1_font_family\";s:5:\"none|\";s:11:\"h1_fontsize\";s:4:\"30px\";s:18:\"h1_fontsize_mobile\";s:0:\"\";s:13:\"h1_lineheight\";s:3:\"1.2\";s:16:\"h1_letterspacing\";s:1:\"0\";s:13:\"h1_fontweight\";s:3:\"400\";s:16:\"h1_bottom_indent\";s:5:\"0.6em\";s:8:\"h1_color\";s:0:\"\";s:12:\"h1_transform\";s:0:\"\";s:17:\"h1_color_override\";s:0:\"\";s:14:\"h2_font_family\";s:7:\"get_h1|\";s:11:\"h2_fontsize\";s:4:\"25px\";s:18:\"h2_fontsize_mobile\";s:0:\"\";s:13:\"h2_lineheight\";s:3:\"1.2\";s:16:\"h2_letterspacing\";s:1:\"0\";s:13:\"h2_fontweight\";s:3:\"400\";s:16:\"h2_bottom_indent\";s:5:\"0.6em\";s:8:\"h2_color\";s:0:\"\";s:12:\"h2_transform\";s:0:\"\";s:17:\"h2_color_override\";s:0:\"\";s:14:\"h3_font_family\";s:7:\"get_h1|\";s:11:\"h3_fontsize\";s:4:\"20px\";s:18:\"h3_fontsize_mobile\";s:0:\"\";s:13:\"h3_lineheight\";s:3:\"1.2\";s:16:\"h3_letterspacing\";s:1:\"0\";s:13:\"h3_fontweight\";s:3:\"400\";s:16:\"h3_bottom_indent\";s:5:\"0.6em\";s:8:\"h3_color\";s:0:\"\";s:12:\"h3_transform\";s:0:\"\";s:17:\"h3_color_override\";s:0:\"\";s:14:\"h4_font_family\";s:7:\"get_h1|\";s:11:\"h4_fontsize\";s:4:\"18px\";s:18:\"h4_fontsize_mobile\";s:0:\"\";s:13:\"h4_lineheight\";s:3:\"1.2\";s:16:\"h4_letterspacing\";s:1:\"0\";s:13:\"h4_fontweight\";s:3:\"400\";s:16:\"h4_bottom_indent\";s:5:\"0.6em\";s:8:\"h4_color\";s:0:\"\";s:12:\"h4_transform\";s:0:\"\";s:17:\"h4_color_override\";s:0:\"\";s:14:\"h5_font_family\";s:7:\"get_h1|\";s:11:\"h5_fontsize\";s:4:\"16px\";s:18:\"h5_fontsize_mobile\";s:0:\"\";s:13:\"h5_lineheight\";s:3:\"1.2\";s:16:\"h5_letterspacing\";s:1:\"0\";s:13:\"h5_fontweight\";s:3:\"400\";s:16:\"h5_bottom_indent\";s:5:\"0.6em\";s:8:\"h5_color\";s:0:\"\";s:12:\"h5_transform\";s:0:\"\";s:17:\"h5_color_override\";s:0:\"\";s:14:\"h6_font_family\";s:7:\"get_h1|\";s:11:\"h6_fontsize\";s:4:\"1rem\";s:18:\"h6_fontsize_mobile\";s:0:\"\";s:13:\"h6_lineheight\";s:3:\"1.2\";s:16:\"h6_letterspacing\";s:1:\"0\";s:13:\"h6_fontweight\";s:3:\"400\";s:16:\"h6_bottom_indent\";s:5:\"0.6em\";s:8:\"h6_color\";s:0:\"\";s:12:\"h6_transform\";s:0:\"\";s:17:\"h6_color_override\";s:0:\"\";s:14:\"h_typography_3\";s:0:\"\";s:11:\"custom_font\";a:0:{}s:14:\"h_typography_4\";s:0:\"\";s:14:\"uploaded_fonts\";a:1:{i:0;a:4:{s:4:\"name\";s:13:\"Uploaded Font\";s:6:\"weight\";s:3:\"400\";s:6:\"italic\";s:0:\"\";s:5:\"files\";s:3:\"6,7\";}}s:14:\"h_typography_5\";s:0:\"\";s:12:\"font_display\";s:4:\"swap\";s:7:\"buttons\";a:3:{i:0;a:23:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"Default Button\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:16:\"_content_primary\";s:14:\"color_bg_hover\";s:18:\"_content_secondary\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:15:\"rgba(0,0,0,0.2)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"0em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.8em\";s:9:\"font_size\";s:4:\"16px\";s:5:\"width\";s:5:\"1.8em\";s:11:\"line_height\";s:4:\"1.12\";s:13:\"border_radius\";s:5:\"0.3em\";s:11:\"font_weight\";s:3:\"700\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:1;a:23:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:8:\"Button 2\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:15:\"_content_border\";s:14:\"color_bg_hover\";s:13:\"_content_text\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:13:\"_content_text\";s:16:\"color_text_hover\";s:11:\"_content_bg\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:15:\"rgba(0,0,0,0.2)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"0em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.8em\";s:9:\"font_size\";s:4:\"16px\";s:5:\"width\";s:5:\"1.8em\";s:11:\"line_height\";s:3:\"1.2\";s:13:\"border_radius\";s:5:\"0.3em\";s:11:\"font_weight\";s:3:\"700\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}i:2;a:23:{s:2:\"id\";s:1:\"3\";s:4:\"name\";s:10:\"حالت 3\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:18:\"_content_secondary\";s:14:\"color_bg_hover\";s:0:\"\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:18:\"_content_secondary\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:18:\"_content_secondary\";s:12:\"color_shadow\";s:15:\"rgba(0,0,0,0.2)\";s:18:\"color_shadow_hover\";s:15:\"rgba(0,0,0,0.2)\";s:6:\"shadow\";s:3:\"0em\";s:12:\"shadow_hover\";s:3:\"0em\";s:4:\"font\";s:4:\"body\";s:6:\"height\";s:5:\"0.8em\";s:9:\"font_size\";s:4:\"1rem\";s:5:\"width\";s:5:\"1.8em\";s:11:\"line_height\";s:3:\"1.2\";s:13:\"border_radius\";s:5:\"0.3em\";s:11:\"font_weight\";s:3:\"400\";s:12:\"border_width\";s:3:\"2px\";s:14:\"letter_spacing\";s:3:\"0em\";s:10:\"text_style\";s:0:\"\";}}s:12:\"input_fields\";a:1:{i:0;a:26:{s:8:\"color_bg\";s:11:\"transparent\";s:14:\"color_bg_focus\";s:0:\"\";s:12:\"color_border\";s:7:\"#e8e8e8\";s:18:\"color_border_focus\";s:7:\"#f2ba66\";s:10:\"color_text\";s:7:\"inherit\";s:16:\"color_text_focus\";s:0:\"\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_focus\";s:7:\"#f2ba66\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"1px\";s:21:\"shadow_focus_offset_h\";s:3:\"0px\";s:21:\"shadow_focus_offset_v\";s:3:\"0px\";s:17:\"shadow_focus_blur\";s:3:\"0px\";s:19:\"shadow_focus_spread\";s:3:\"1px\";s:12:\"shadow_inset\";s:1:\"1\";s:18:\"shadow_focus_inset\";s:1:\"1\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:3:\"3em\";s:9:\"font_size\";s:4:\"1rem\";s:7:\"padding\";s:3:\"1em\";s:11:\"font_weight\";s:3:\"400\";s:13:\"border_radius\";s:5:\"0.2em\";s:14:\"letter_spacing\";s:3:\"0em\";s:12:\"border_width\";s:3:\"1px\";}}s:26:\"portfolio_breadcrumbs_page\";s:0:\"\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:23:\"portfolio_category_slug\";s:18:\"portfolio_category\";s:18:\"portfolio_tag_slug\";s:13:\"portfolio_tag\";s:16:\"portfolio_rename\";i:0;s:20:\"portfolio_label_name\";s:9:\"Portfolio\";s:29:\"portfolio_label_singular_name\";s:14:\"Portfolio Page\";s:23:\"portfolio_label_add_new\";s:18:\"Add Portfolio Page\";s:25:\"portfolio_label_edit_item\";s:19:\"Edit Portfolio Page\";s:24:\"portfolio_label_category\";s:20:\"Portfolio Categories\";s:19:\"portfolio_label_tag\";s:14:\"Portfolio Tags\";s:6:\"h_more\";s:0:\"\";s:12:\"shop_catalog\";s:0:\"\";s:22:\"shop_primary_btn_style\";s:1:\"1\";s:24:\"shop_secondary_btn_style\";s:1:\"2\";s:15:\"product_gallery\";s:6:\"slider\";s:29:\"wrapper_product_gallery_start\";s:0:\"\";s:26:\"product_gallery_thumbs_pos\";s:6:\"bottom\";s:27:\"product_gallery_thumbs_cols\";s:1:\"4\";s:28:\"product_gallery_thumbs_width\";s:4:\"6rem\";s:26:\"product_gallery_thumbs_gap\";s:3:\"4px\";s:23:\"product_gallery_options\";s:13:\"zoom,lightbox\";s:27:\"wrapper_product_gallery_end\";s:0:\"\";s:9:\"h_product\";s:0:\"\";s:17:\"header_product_id\";s:12:\"__defaults__\";s:19:\"titlebar_product_id\";s:12:\"__defaults__\";s:18:\"content_product_id\";s:4:\"1682\";s:18:\"sidebar_product_id\";s:12:\"__defaults__\";s:19:\"sidebar_product_pos\";s:5:\"right\";s:17:\"footer_product_id\";s:12:\"__defaults__\";s:6:\"h_shop\";s:0:\"\";s:14:\"header_shop_id\";s:12:\"__defaults__\";s:16:\"titlebar_shop_id\";s:12:\"__defaults__\";s:15:\"content_shop_id\";s:4:\"1693\";s:18:\"wrapper_shop_start\";s:0:\"\";s:12:\"shop_columns\";s:1:\"3\";s:16:\"wrapper_shop_end\";s:0:\"\";s:15:\"sidebar_shop_id\";s:12:\"__defaults__\";s:16:\"sidebar_shop_pos\";s:5:\"right\";s:14:\"footer_shop_id\";s:12:\"__defaults__\";s:17:\"h_tax_product_cat\";s:0:\"\";s:25:\"header_tax_product_cat_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_product_cat_id\";s:12:\"__defaults__\";s:26:\"content_tax_product_cat_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_product_cat_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_product_cat_pos\";s:5:\"right\";s:25:\"footer_tax_product_cat_id\";s:12:\"__defaults__\";s:17:\"h_tax_product_tag\";s:0:\"\";s:25:\"header_tax_product_tag_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_product_tag_id\";s:12:\"__defaults__\";s:26:\"content_tax_product_tag_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_product_tag_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_product_tag_pos\";s:5:\"right\";s:25:\"footer_tax_product_tag_id\";s:12:\"__defaults__\";s:6:\"h_cart\";s:0:\"\";s:9:\"shop_cart\";s:7:\"compact\";s:19:\"product_related_qty\";s:1:\"3\";s:15:\"used_icons_info\";s:0:\"\";s:9:\"h_icons_2\";s:0:\"\";s:9:\"icons_fas\";s:7:\"default\";s:21:\"icons_fas_custom_font\";s:0:\"\";s:9:\"icons_far\";s:7:\"default\";s:21:\"icons_far_custom_font\";s:0:\"\";s:9:\"icons_fab\";s:7:\"default\";s:21:\"icons_fab_custom_font\";s:0:\"\";s:14:\"icons_material\";s:7:\"default\";s:26:\"icons_material_custom_font\";s:0:\"\";s:18:\"fallback_icon_font\";i:1;s:13:\"img_size_info\";s:0:\"\";s:13:\"h_image_sizes\";s:0:\"\";s:8:\"img_size\";a:0:{}s:14:\"h_more_options\";s:0:\"\";s:24:\"big_image_size_threshold\";s:6:\"2560px\";s:20:\"delete_unused_images\";i:0;s:12:\"h_advanced_1\";s:0:\"\";s:12:\"live_builder\";s:0:\"\";s:19:\"grid_columns_layout\";i:1;s:12:\"block_editor\";i:0;s:23:\"enable_sidebar_titlebar\";i:0;s:31:\"enable_page_blocks_for_sidebars\";i:0;s:16:\"enable_portfolio\";s:0:\"\";s:19:\"enable_testimonials\";s:0:\"\";s:14:\"media_category\";s:0:\"\";s:10:\"og_enabled\";i:1;s:13:\"schema_markup\";i:1;s:12:\"h_advanced_2\";s:0:\"\";s:13:\"gmaps_api_key\";s:0:\"\";s:15:\"facebook_app_id\";s:0:\"\";s:22:\"grid_filter_url_prefix\";s:0:\"\";s:21:\"grid_order_url_prefix\";s:0:\"\";s:12:\"h_advanced_3\";s:0:\"\";s:17:\"keep_url_protocol\";b:1;s:22:\"disable_jquery_migrate\";b:1;s:13:\"jquery_footer\";b:1;s:12:\"ajax_load_js\";b:1;s:16:\"disable_extra_vc\";b:1;s:15:\"optimize_assets\";b:0;s:21:\"optimize_assets_alert\";s:0:\"\";s:21:\"optimize_assets_start\";s:0:\"\";s:6:\"assets\";a:55:{s:12:\"font-awesome\";i:1;s:9:\"actionbox\";i:1;s:9:\"animation\";i:1;s:7:\"buttons\";i:1;s:8:\"carousel\";i:1;s:6:\"charts\";i:1;s:7:\"columns\";i:1;s:8:\"comments\";i:1;s:8:\"contacts\";i:1;s:7:\"counter\";i:1;s:8:\"dropdown\";i:1;s:5:\"forms\";i:1;s:7:\"flipbox\";i:1;s:5:\"gmaps\";i:1;s:4:\"grid\";i:1;s:11:\"grid_filter\";i:1;s:10:\"grid_order\";i:1;s:14:\"grid_templates\";i:1;s:15:\"grid_pagination\";i:1;s:10:\"grid_popup\";i:1;s:6:\"header\";i:1;s:12:\"hor_parallax\";i:1;s:8:\"hwrapper\";i:1;s:7:\"iconbox\";i:1;s:5:\"image\";i:1;s:13:\"image_gallery\";i:1;s:12:\"image_slider\";i:1;s:7:\"ibanner\";i:1;s:5:\"itext\";i:1;s:5:\"login\";i:1;s:14:\"magnific_popup\";i:1;s:4:\"menu\";i:1;s:7:\"message\";i:1;s:5:\"lmaps\";i:1;s:8:\"scroller\";i:1;s:6:\"person\";i:1;s:9:\"preloader\";i:1;s:5:\"print\";i:1;s:5:\"popup\";i:1;s:13:\"post_elements\";i:1;s:15:\"post_navigation\";i:1;s:7:\"pricing\";i:1;s:7:\"progbar\";i:1;s:6:\"scroll\";i:1;s:6:\"search\";i:1;s:9:\"separator\";i:1;s:7:\"sharing\";i:1;s:11:\"simple_menu\";i:1;s:7:\"socials\";i:1;s:4:\"tabs\";i:1;s:4:\"text\";i:1;s:5:\"video\";i:1;s:12:\"ver_parallax\";i:1;s:8:\"vwrapper\";i:1;s:10:\"wp_widgets\";i:1;}s:19:\"optimize_assets_end\";s:0:\"\";s:18:\"include_gfonts_css\";b:0;s:10:\"custom_css\";s:151:\".owl-carousel.navstyle_circle .owl-nav div{\n	transform: rotate(180deg);\n}\n\n\n\n.nav-links .next  , .nav-links .previous {\n    transform:rotate(180deg);\n}\";s:16:\"custom_html_head\";s:0:\"\";s:11:\"custom_html\";s:0:\"\";s:8:\"of_reset\";s:0:\"\";s:9:\"of_backup\";s:0:\"\";s:11:\"of_transfer\";s:0:\"\";s:11:\"white_label\";i:0;s:22:\"white_label_theme_name\";s:0:\"\";s:28:\"white_label_theme_screenshot\";s:0:\"\";s:22:\"white_label_theme_icon\";s:0:\"\";s:22:\"white_label_login_icon\";s:0:\"\";s:11:\"h_portfolio\";s:0:\"\";s:19:\"header_portfolio_id\";s:12:\"__defaults__\";s:21:\"titlebar_portfolio_id\";s:12:\"__defaults__\";s:20:\"content_portfolio_id\";s:12:\"__defaults__\";s:20:\"sidebar_portfolio_id\";s:12:\"__defaults__\";s:21:\"sidebar_portfolio_pos\";s:5:\"right\";s:19:\"footer_portfolio_id\";s:12:\"__defaults__\";s:27:\"h_tax_us_portfolio_category\";s:0:\"\";s:35:\"header_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:37:\"titlebar_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:36:\"content_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:36:\"sidebar_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:37:\"sidebar_tax_us_portfolio_category_pos\";s:5:\"right\";s:35:\"footer_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:22:\"h_tax_us_portfolio_tag\";s:0:\"\";s:30:\"header_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:32:\"titlebar_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:31:\"content_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:31:\"sidebar_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:32:\"sidebar_tax_us_portfolio_tag_pos\";s:5:\"right\";s:30:\"footer_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";}", "on");
INSERT INTO `wp_options` VALUES("164", "us_theme_options_css", ":root{--color-header-middle-bg:#0f0e17;--color-header-middle-bg-grad:#0f0e17;--color-header-middle-text:#afb1bd;--color-header-middle-text-hover:#c99b55;--color-header-transparent-bg:transparent;--color-header-transparent-bg-grad:transparent;--color-header-transparent-text:#fffffe;--color-header-transparent-text-hover:#c99b55;--color-chrome-toolbar:#000000;--color-chrome-toolbar-grad:#000000;--color-header-top-bg:#000000;--color-header-top-bg-grad:#000000;--color-header-top-text:#afb1bd;--color-header-top-text-hover:#c99b55;--color-header-top-transparent-bg:rgba(0,0,0,0.2);--color-header-top-transparent-bg-grad:rgba(0,0,0,0.2);--color-header-top-transparent-text:rgba(255,255,255,0.66);--color-header-top-transparent-text-hover:#fff;--color-content-bg:#0A051C;--color-content-bg-grad:#0A051C;--color-content-bg-alt:#c99b55;--color-content-bg-alt-grad:#c99b55;--color-content-border:#2e2f3e;--color-content-heading:#fffffe;--color-content-heading-grad:#fffffe;--color-content-text:#f5f5f5;--color-content-link:#c99b55;--color-content-link-hover:#d6a55a;--color-content-primary:#c99b55;--color-content-primary-grad:#c99b55;--color-content-secondary:#d6a55a;--color-content-secondary-grad:#d6a55a;--color-content-faded:#72757e;--color-content-overlay:rgba(0,0,0,0.75);--color-content-overlay-grad:rgba(0,0,0,0.75);--color-footer-bg:#0f0e17;--color-footer-bg-grad:#0f0e17;--color-footer-bg-alt:#000000;--color-footer-bg-alt-grad:#000000;--color-footer-border:#2e2f3e;--color-footer-heading:#ff8906;--color-footer-heading-grad:#ff8906;--color-footer-text:#72757e;--color-footer-link:#afb1bd;--color-footer-link-hover:#d6a55a;--color-content-primary-faded:rgba(201,155,85,0.15);--box-shadow:0 5px 15px rgba(0,0,0,.15);--box-shadow-up:0 -5px 15px rgba(0,0,0,.15);--site-content-width:1140px;--inputs-font-size:1rem;--inputs-height:3em;--inputs-padding:1em;--inputs-border-width:1px;--inputs-text-color:inherit;--font-body:\"Uploaded Font\"}html,.l-header .widget,.menu-item-object-us_page_block{font-family:var(--font-body);font-weight:;font-size:18px;line-height:28px}@font-face{font-display:swap;font-style:normal;font-family:\"Uploaded Font\";font-weight:400;src:url(https://erictarot.com/wp-content/uploads/2025/02/IRANYekanX-Bold.woff2) format(\"woff2\"),url(https://erictarot.com/wp-content/uploads/2025/02/IRANYekanX-Regular.woff2) format(\"woff2\")}h1{font-family:var(--font-h1);font-weight:400;font-size:30px;line-height:1.2;letter-spacing:0;margin-bottom:0.6em}h2{font-family:var(--font-h2);font-weight:400;font-size:25px;line-height:1.2;letter-spacing:0;margin-bottom:0.6em}h3{font-family:var(--font-h3);font-weight:400;font-size:20px;line-height:1.2;letter-spacing:0;margin-bottom:0.6em}.woocommerce-Reviews-title,.widgettitle,h4{font-family:var(--font-h4);font-weight:400;font-size:18px;line-height:1.2;letter-spacing:0;margin-bottom:0.6em}h5{font-family:var(--font-h5);font-weight:400;font-size:16px;line-height:1.2;letter-spacing:0;margin-bottom:0.6em}h6{font-family:var(--font-h6);font-weight:400;font-size:1rem;line-height:1.2;letter-spacing:0;margin-bottom:0.6em}@media (max-width:600px){html{font-size:16px;line-height:28px}}body{background:var(--color-content-bg-alt)}.l-canvas.type_boxed,.l-canvas.type_boxed .l-subheader,.l-canvas.type_boxed~.l-footer{max-width:1300px}.l-subheader-h,.l-section-h,.l-main .aligncenter,.w-tabs-section-content-h{max-width:1140px}.post-password-form{max-width:calc(1140px + 5rem)}@media screen and (max-width:1230px){.l-main .aligncenter{max-width:calc(100vw - 5rem)}}@media (min-width:1281px){body.usb_preview .hide_on_default{opacity:0.25!important}body:not(.usb_preview) .hide_on_default{display:none!important}}@media (min-width:1025px) and (max-width:1280px){body.usb_preview .hide_on_laptops{opacity:0.25!important}body:not(.usb_preview) .hide_on_laptops{display:none!important}}@media (min-width:601px) and (max-width:1024px){body.usb_preview .hide_on_tablets{opacity:0.25!important}body:not(.usb_preview) .hide_on_tablets{display:none!important}}@media (max-width:600px){body.usb_preview .hide_on_mobiles{opacity:0.25!important}body:not(.usb_preview) .hide_on_mobiles{display:none!important}}@media (max-width:767px){.l-canvas{overflow:hidden}.g-cols.via_flex.reversed{flex-direction:column-reverse}.g-cols.via_grid.reversed>div:last-of-type{order:-1}.g-cols.via_flex>div:not([class*=\" vc_col-\"]){width:100%;margin:0 0 1.5rem}.g-cols.via_grid.tablets-cols_inherit.mobiles-cols_1{grid-template-columns:100%}.g-cols.via_flex.type_boxes>div,.g-cols.via_flex.reversed>div:first-child,.g-cols.via_flex:not(.reversed)>div:last-child,.g-cols.via_flex>div.has_bg_color{margin-bottom:0}.g-cols.via_flex.type_default>.wpb_column.stretched{margin-left:-1rem;margin-right:-1rem}.g-cols.via_grid>.wpb_column.stretched,.g-cols.via_flex.type_boxes>.wpb_column.stretched{margin-left:-2.5rem;margin-right:-2.5rem;width:auto}.vc_column-inner.type_sticky>.wpb_wrapper,.vc_column_container.type_sticky>.vc_column-inner{top:0!important}}@media (min-width:768px){body:not(.rtl) .l-section.for_sidebar.at_left>div>.l-sidebar,.rtl .l-section.for_sidebar.at_right>div>.l-sidebar{order:-1}.vc_column_container.type_sticky>.vc_column-inner,.vc_column-inner.type_sticky>.wpb_wrapper{position:-webkit-sticky;position:sticky}.l-section.type_sticky{position:-webkit-sticky;position:sticky;top:0;z-index:11;transform:translateZ(0); transition:top 0.3s cubic-bezier(.78,.13,.15,.86) 0.1s}.admin-bar .l-section.type_sticky{top:32px}.l-section.type_sticky>.l-section-h{transition:padding-top 0.3s}.header_hor .l-header.pos_fixed:not(.down)~.l-main .l-section.type_sticky:not(:first-of-type){top:var(--header-sticky-height)}.admin-bar.header_hor .l-header.pos_fixed:not(.down)~.l-main .l-section.type_sticky:not(:first-of-type){top:calc( var(--header-sticky-height) + 32px )}.header_hor .l-header.pos_fixed.sticky:not(.down)~.l-main .l-section.type_sticky:first-of-type>.l-section-h{padding-top:var(--header-sticky-height)}}@media screen and (min-width:1230px){.g-cols.via_flex.type_default>.wpb_column.stretched:first-of-type{margin-left:calc( var(--site-content-width) / 2 + 0px / 2 + 1.5rem - 50vw)}.g-cols.via_flex.type_default>.wpb_column.stretched:last-of-type{margin-right:calc( var(--site-content-width) / 2 + 0px / 2 + 1.5rem - 50vw)}.l-main .alignfull, .w-separator.width_screen,.g-cols.via_grid>.wpb_column.stretched:first-of-type,.g-cols.via_flex.type_boxes>.wpb_column.stretched:first-of-type{margin-left:calc( var(--site-content-width) / 2 + 0px / 2 - 50vw )}.l-main .alignfull, .w-separator.width_screen,.g-cols.via_grid>.wpb_column.stretched:last-of-type,.g-cols.via_flex.type_boxes>.wpb_column.stretched:last-of-type{margin-right:calc( var(--site-content-width) / 2 + 0px / 2 - 50vw )}}@media (max-width:600px){.w-form-row.for_submit .w-btn{font-size:var(--btn-size-mobiles)!important}}a,button,input[type=\"submit\"],.ui-slider-handle{outline:none!important}.w-toplink,.w-header-show{background:rgba(0,0,0,0.3)}.no-touch .w-toplink.active:hover,.no-touch .w-header-show:hover{background:var(--color-content-primary-grad)}button[type=\"submit\"]:not(.w-btn),input[type=\"submit\"]{font-family:var(--font-body);font-size:16px;line-height:1.12!important;font-weight:700;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:0.8em 1.8em;box-shadow:0 0em 0em rgba(0,0,0,0.2);background:var(--color-content-primary);border-color:transparent;color:#ffffff!important}button[type=\"submit\"]:not(.w-btn):before,input[type=\"submit\"]{border-width:0px}.no-touch button[type=\"submit\"]:not(.w-btn):hover,.no-touch input[type=\"submit\"]:hover{box-shadow:0 0em 0em rgba(0,0,0,0.2);background:var(--color-content-secondary);border-color:transparent;color:#ffffff!important}.woocommerce .button.alt,.woocommerce .button.checkout,.woocommerce .button.add_to_cart_button,.us-nav-style_1>*,.navstyle_1>.owl-nav div,.us-btn-style_1{font-family:var(--font-body);font-size:16px;line-height:1.12!important;font-weight:700;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:0.8em 1.8em;background:var(--color-content-primary);border-color:transparent;color:#ffffff!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.woocommerce .button.alt:before,.woocommerce .button.checkout:before,.woocommerce .button.add_to_cart_button:before,.us-nav-style_1>*:before,.navstyle_1>.owl-nav div:before,.us-btn-style_1:before{border-width:0px}.no-touch .woocommerce .button.alt:hover,.no-touch .woocommerce .button.checkout:hover,.no-touch .woocommerce .button.add_to_cart_button:hover,.us-nav-style_1>span.current,.no-touch .us-nav-style_1>a:hover,.no-touch .navstyle_1>.owl-nav div:hover,.no-touch .us-btn-style_1:hover{box-shadow:0 0em 0em rgba(0,0,0,0.2);background:var(--color-content-secondary);border-color:transparent;color:#ffffff!important}.us-nav-style_1>*{min-width:calc(1.12em + 2 * 0.8em)}.woocommerce .button,.woocommerce .actions .button,.us-nav-style_2>*,.navstyle_2>.owl-nav div,.us-btn-style_2{font-family:var(--font-body);font-size:16px;line-height:1.2!important;font-weight:700;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:0.8em 1.8em;background:var(--color-content-border);border-color:transparent;color:var(--color-content-text)!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.woocommerce .button:before,.woocommerce .actions .button:before,.us-nav-style_2>*:before,.navstyle_2>.owl-nav div:before,.us-btn-style_2:before{border-width:0px}.no-touch .woocommerce .button:hover,.no-touch .woocommerce .actions .button:hover,.us-nav-style_2>span.current,.no-touch .us-nav-style_2>a:hover,.no-touch .navstyle_2>.owl-nav div:hover,.no-touch .us-btn-style_2:hover{box-shadow:0 0em 0em rgba(0,0,0,0.2);background:var(--color-content-text);border-color:transparent;color:var(--color-content-bg)!important}.us-nav-style_2>*{min-width:calc(1.2em + 2 * 0.8em)}.us-nav-style_3>*,.navstyle_3>.owl-nav div,.us-btn-style_3{font-family:var(--font-body);font-size:1rem;line-height:1.2!important;font-weight:400;font-style:normal;text-transform:none;letter-spacing:0em;border-radius:0.3em;padding:0.8em 1.8em;background:var(--color-content-secondary);border-color:transparent;color:#ffffff!important;box-shadow:0 0em 0em rgba(0,0,0,0.2)}.us-nav-style_3>*:before,.navstyle_3>.owl-nav div:before,.us-btn-style_3:before{border-width:2px}.us-nav-style_3>span.current,.no-touch .us-nav-style_3>a:hover,.no-touch .navstyle_3>.owl-nav div:hover,.no-touch .us-btn-style_3:hover{box-shadow:0 0em 0em rgba(0,0,0,0.2);background:transparent;border-color:var(--color-content-secondary);color:var(--color-content-secondary)!important}.us-nav-style_3>*{min-width:calc(1.2em + 2 * 0.8em)}.w-filter.state_desktop.style_drop_default .w-filter-item-title,.select2-selection,select,textarea,input:not([type=\"submit\"]),.w-form-checkbox,.w-form-radio{font-weight:400;letter-spacing:0em;border-radius:0.2em;background:transparent;border-color:#e8e8e8;color:inherit}.w-filter.state_desktop.style_drop_default .w-filter-item-title:focus,.select2-container--open .select2-selection,select:focus,textarea:focus,input:not([type=\"submit\"]):focus,input:focus + .w-form-checkbox,input:focus + .w-form-radio{border-color:#f2ba66!important;box-shadow:0px 0px 0px 1px #f2ba66 inset}.w-form-row.move_label .w-form-row-label{font-size:1rem;top:calc(3em/2 + 1px - 0.7em);margin:0 1em;background:var(--color-content-bg-grad);color:inherit}.w-form-row.with_icon.move_label .w-form-row-label{margin-right:calc(1.6em + 1em)}.color_alternate .w-form-row.move_label .w-form-row-label{background:var(--color-alt-content-bg-grad)}.color_footer-top .w-form-row.move_label .w-form-row-label{background:var(--color-subfooter-bg-grad)}.color_footer-bottom .w-form-row.move_label .w-form-row-label{background:var(--color-footer-bg-grad)}.style_phone6-1>*{background-image:url(https://erictarot.com/wp-content/themes/webariyo2022/img/phone-6-black-real.png)}.style_phone6-2>*{background-image:url(https://erictarot.com/wp-content/themes/webariyo2022/img/phone-6-white-real.png)}.style_phone6-3>*{background-image:url(https://erictarot.com/wp-content/themes/webariyo2022/img/phone-6-black-flat.png)}.style_phone6-4>*{background-image:url(https://erictarot.com/wp-content/themes/webariyo2022/img/phone-6-white-flat.png)}.leaflet-default-icon-path{background-image:url(https://erictarot.com/wp-content/themes/webariyo2022/common/css/vendor/images/marker-icon.png)}.woocommerce-product-gallery--columns-4 li{width:25.000%}.woocommerce-product-gallery ol{margin:2px -2px 0}.woocommerce-product-gallery ol>li{padding:2px}", "on");
INSERT INTO `wp_options` VALUES("530", "woocommerce_maybe_regenerate_images_hash", "f295711100eef51cf7195e603d0739ad", "auto");
INSERT INTO `wp_options` VALUES("537", "woocommerce_ces_shown_for_actions", "a:5:{i:0;s:22:\"add_product_categories\";i:1;s:14:\"product_update\";i:2;s:19:\"product_add_publish\";i:3;s:15:\"settings_change\";i:4;s:15:\"import_products\";}", "auto");
INSERT INTO `wp_options` VALUES("250", "woocommerce_review_rating_verification_required", "no", "off");
INSERT INTO `wp_options` VALUES("251", "woocommerce_enable_review_rating", "yes", "on");
INSERT INTO `wp_options` VALUES("252", "woocommerce_review_rating_required", "yes", "off");
INSERT INTO `wp_options` VALUES("253", "woocommerce_manage_stock", "yes", "on");
INSERT INTO `wp_options` VALUES("254", "woocommerce_hold_stock_minutes", "60", "off");
INSERT INTO `wp_options` VALUES("255", "woocommerce_notify_low_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("256", "woocommerce_notify_no_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("257", "woocommerce_stock_email_recipient", "tabmehrnaz@gmail.com", "off");
INSERT INTO `wp_options` VALUES("258", "woocommerce_notify_low_stock_amount", "2", "off");
INSERT INTO `wp_options` VALUES("259", "woocommerce_notify_no_stock_amount", "0", "on");
INSERT INTO `wp_options` VALUES("260", "woocommerce_hide_out_of_stock_items", "no", "on");
INSERT INTO `wp_options` VALUES("261", "woocommerce_stock_format", "", "on");
INSERT INTO `wp_options` VALUES("262", "woocommerce_file_download_method", "force", "off");
INSERT INTO `wp_options` VALUES("263", "woocommerce_downloads_redirect_fallback_allowed", "no", "off");
INSERT INTO `wp_options` VALUES("264", "woocommerce_downloads_require_login", "no", "off");
INSERT INTO `wp_options` VALUES("265", "woocommerce_downloads_grant_access_after_payment", "yes", "off");
INSERT INTO `wp_options` VALUES("266", "woocommerce_downloads_deliver_inline", "", "off");
INSERT INTO `wp_options` VALUES("267", "woocommerce_downloads_add_hash_to_filename", "yes", "on");
INSERT INTO `wp_options` VALUES("268", "woocommerce_downloads_count_partial", "yes", "on");
INSERT INTO `wp_options` VALUES("270", "woocommerce_attribute_lookup_direct_updates", "no", "on");
INSERT INTO `wp_options` VALUES("271", "woocommerce_attribute_lookup_optimized_updates", "no", "on");
INSERT INTO `wp_options` VALUES("272", "woocommerce_product_match_featured_image_by_sku", "no", "on");
INSERT INTO `wp_options` VALUES("273", "woocommerce_prices_include_tax", "no", "on");
INSERT INTO `wp_options` VALUES("126", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1740415259;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("127", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"eb62b9f0d75a62682b05c48fe04b7d59\";s:6:\"blocks\";a:6:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:18:\"core/term-template\";s:120:\":where(.wp-block-term-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-term-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("121703", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1765602792;s:7:\"checked\";a:1:{s:12:\"webariyo2022\";s:5:\"0.0.2\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("121704", "duplicator_version_plugin", "1.5.14", "auto");
INSERT INTO `wp_options` VALUES("121706", "duplicator_install_info", "a:3:{s:7:\"version\";s:6:\"1.5.14\";s:4:\"time\";i:1765602792;s:10:\"updateTime\";i:1765602792;}", "off");
INSERT INTO `wp_options` VALUES("121659", "_transient_timeout_woocommerce_admin_pes_incentive_woopayments_store_has_orders", "1765624267", "off");
INSERT INTO `wp_options` VALUES("121660", "_transient_woocommerce_admin_pes_incentive_woopayments_store_has_orders", "no", "off");
INSERT INTO `wp_options` VALUES("121524", "aiowps_captcha_string_info_vja8mrp4ld", "MTc2NTU3MDc5ODVrcGdhZWZ1bHo2OWQ0eTQ3MnRrMjI=", "off");
INSERT INTO `wp_options` VALUES("121525", "aiowps_captcha_string_info_time_vja8mrp4ld", "1765570798", "off");
INSERT INTO `wp_options` VALUES("121531", "aiowps_captcha_string_info_luayntzi8l", "MTc2NTU3MTYxNzVrcGdhZWZ1bHo2OWQ0eTQ3MnRrMjE=", "off");
INSERT INTO `wp_options` VALUES("121532", "aiowps_captcha_string_info_time_luayntzi8l", "1765571617", "off");
INSERT INTO `wp_options` VALUES("121609", "aiowps_captcha_string_info_bwfh0vzxqr", "MTc2NTU4OTA0NTVrcGdhZWZ1bHo2OWQ0eTQ3MnRrMjA=", "off");
INSERT INTO `wp_options` VALUES("121610", "aiowps_captcha_string_info_time_bwfh0vzxqr", "1765589045", "off");
INSERT INTO `wp_options` VALUES("121614", "aiowps_captcha_string_info_8kxyuhmeuc", "MTc2NTU4OTUyODVrcGdhZWZ1bHo2OWQ0eTQ3MnRrMzU=", "off");
INSERT INTO `wp_options` VALUES("121615", "aiowps_captcha_string_info_time_8kxyuhmeuc", "1765589528", "off");
INSERT INTO `wp_options` VALUES("121621", "aiowps_captcha_string_info_etqeo0303s", "MTc2NTU5MTEzOTVrcGdhZWZ1bHo2OWQ0eTQ3MnRrOQ==", "off");
INSERT INTO `wp_options` VALUES("121622", "aiowps_captcha_string_info_time_etqeo0303s", "1765591139", "off");
INSERT INTO `wp_options` VALUES("121634", "aiowps_captcha_string_info_eyk0vcxhjc", "MTc2NTU5NzcwMDVrcGdhZWZ1bHo2OWQ0eTQ3MnRrMQ==", "off");
INSERT INTO `wp_options` VALUES("121635", "aiowps_captcha_string_info_time_eyk0vcxhjc", "1765597700", "off");
INSERT INTO `wp_options` VALUES("121655", "aiowps_captcha_string_info_1r6hy5klqq", "MTc2NTYwMjY1OTVrcGdhZWZ1bHo2OWQ0eTQ3MnRrMjU=", "off");
INSERT INTO `wp_options` VALUES("121656", "aiowps_captcha_string_info_time_1r6hy5klqq", "1765602659", "off");
INSERT INTO `wp_options` VALUES("121657", "_site_transient_timeout_available_translations", "1765613459", "off");
INSERT INTO `wp_options` VALUES("121658", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.11/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.7/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-07-10 08:09:09\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.7/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.28/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 10:38:20\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-07 14:52:58\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-05 09:40:40\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-11 21:36:34\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-26 15:18:01\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-18 15:47:02\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-23 12:01:47\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-11 23:07:58\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-11 23:06:57\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.9/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 08:11:27\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 08:08:17\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.9/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 20:02:46\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-05-22 11:56:25\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-25 13:30:15\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-13 00:57:20\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-07-29 13:22:09\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-25 15:42:18\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-08-19 08:40:47\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 13:13:48\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 11:10:15\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-10 15:28:40\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-12 22:21:48\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-10-01 22:54:47\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.12/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.18/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-16 01:19:35\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.23/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-11-05 21:53:17\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9-RC/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-06 02:07:08\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-02-14 17:29:08\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-29 11:04:04\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-03 04:54:28\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-10 11:15:06\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.7/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2025-10-21 16:35:04\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.8/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-18 15:51:09\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-09 11:14:55\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.34\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.34/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2025-02-06 05:17:11\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 02:14:36\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 02:11:55\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-23 03:46:40\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 17:48:46\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 11:59:02\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-25 08:25:07\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9-RC/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.23/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-12 18:19:46\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 12:23:06\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-08 08:55:07\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.9/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-23 15:08:15\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.9/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-09-27 20:51:17\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-07-15 19:11:43\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.0.11/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-12 09:59:53\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.7/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-05 11:38:40\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.17\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.17/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 19:55:58\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-11-07 08:26:32\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 09:40:20\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-11 13:52:50\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-18 15:26:13\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.9/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 09:45:52\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.35\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.35/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 18:21:27\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 10:17:43\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 00:03:57\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/6.9/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-09 09:48:35\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-08 13:01:10\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.18/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 04:57:17\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-04-24 16:58:02\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/6.9-RC/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-29 11:19:02\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-21 22:07:32\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 15:37:44\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-27 15:18:03\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-16 17:19:56\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.12/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-13 03:51:40\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-26 15:28:41\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-11 16:02:15\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"6.8\";s:7:\"updated\";s:19:\"2025-04-18 21:10:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.8/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.18/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-09-01 09:12:13\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 00:32:44\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 08:19:35\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "off");
INSERT INTO `wp_options` VALUES("128", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("231", "woocommerce_ship_to_countries", "", "on");
INSERT INTO `wp_options` VALUES("157", "current_theme", "WebAriyo", "auto");
INSERT INTO `wp_options` VALUES("158", "theme_mods_webariyo2022", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;}", "on");
INSERT INTO `wp_options` VALUES("159", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("209", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("233", "woocommerce_default_customer_address", "base", "on");
INSERT INTO `wp_options` VALUES("234", "woocommerce_calc_taxes", "no", "on");
INSERT INTO `wp_options` VALUES("235", "woocommerce_enable_coupons", "yes", "on");
INSERT INTO `wp_options` VALUES("236", "woocommerce_calc_discounts_sequentially", "no", "off");
INSERT INTO `wp_options` VALUES("237", "woocommerce_currency", "USD", "on");
INSERT INTO `wp_options` VALUES("238", "woocommerce_currency_pos", "left", "on");
INSERT INTO `wp_options` VALUES("239", "woocommerce_price_thousand_sep", ".", "on");
INSERT INTO `wp_options` VALUES("240", "woocommerce_price_decimal_sep", ",", "on");
INSERT INTO `wp_options` VALUES("241", "woocommerce_price_num_decimals", "0", "on");
INSERT INTO `wp_options` VALUES("242", "woocommerce_shop_page_id", "10", "on");
INSERT INTO `wp_options` VALUES("243", "woocommerce_cart_redirect_after_add", "no", "on");
INSERT INTO `wp_options` VALUES("244", "woocommerce_enable_ajax_add_to_cart", "yes", "on");
INSERT INTO `wp_options` VALUES("245", "woocommerce_placeholder_image", "9", "on");
INSERT INTO `wp_options` VALUES("246", "woocommerce_weight_unit", "kg", "on");
INSERT INTO `wp_options` VALUES("247", "woocommerce_dimension_unit", "cm", "on");
INSERT INTO `wp_options` VALUES("248", "woocommerce_enable_reviews", "yes", "on");
INSERT INTO `wp_options` VALUES("249", "woocommerce_review_rating_verification_label", "yes", "off");
INSERT INTO `wp_options` VALUES("156", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("232", "woocommerce_specific_ship_to_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("58528", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("208", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("202", "us_flush_rules", "1", "on");
INSERT INTO `wp_options` VALUES("221", "woocommerce_newly_installed", "no", "auto");
INSERT INTO `wp_options` VALUES("222", "woocommerce_schema_version", "920", "auto");
INSERT INTO `wp_options` VALUES("223", "woocommerce_store_address", "", "on");
INSERT INTO `wp_options` VALUES("224", "woocommerce_store_address_2", "", "on");
INSERT INTO `wp_options` VALUES("225", "woocommerce_store_city", "", "on");
INSERT INTO `wp_options` VALUES("226", "woocommerce_default_country", "US:CA", "on");
INSERT INTO `wp_options` VALUES("227", "woocommerce_store_postcode", "", "on");
INSERT INTO `wp_options` VALUES("228", "woocommerce_allowed_countries", "all", "on");
INSERT INTO `wp_options` VALUES("229", "woocommerce_all_except_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("230", "woocommerce_specific_allowed_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("165", "us_db_version", "8.6.1", "on");
INSERT INTO `wp_options` VALUES("166", "widget_us_contacts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("167", "widget_us_login", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("168", "widget_us_portfolio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("169", "widget_us_blog", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("170", "widget_us_socials", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("171", "usof_color_palette_WebAriyo", "a:8:{i:0;s:39:\"linear-gradient(135deg,#e95095,#7049ba)\";i:1;s:39:\"linear-gradient(135deg,#7049ba,#e95095)\";i:2;s:7:\"#1a1a1a\";i:3;s:4:\"#333\";i:4;s:4:\"#999\";i:5;s:7:\"#e8e8e8\";i:6;s:7:\"#f5f5f5\";i:7;s:4:\"#fff\";}", "auto");
INSERT INTO `wp_options` VALUES("175", "wpb_js_composer_license_activation_notified", "yes", "auto");
INSERT INTO `wp_options` VALUES("174", "vc_version", "6.7.0", "auto");
INSERT INTO `wp_options` VALUES("512", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("1360", "wt_iew_advanced_settings", "a:10:{s:29:\"wt_iew_maximum_execution_time\";i:180;s:24:\"wt_iew_enable_import_log\";i:1;s:28:\"wt_iew_default_import_method\";s:3:\"new\";s:27:\"wt_iew_default_import_batch\";i:50;s:28:\"wt_iew_default_export_method\";s:3:\"new\";s:18:\"wt_iew_include_bom\";s:1:\"1\";s:27:\"wt_iew_default_export_batch\";i:50;s:22:\"wt_iew_chatgpt_api_key\";s:0:\"\";s:33:\"wt_iew_enable_history_auto_delete\";i:1;s:32:\"wt_iew_auto_delete_history_count\";i:100;}", "auto");
INSERT INTO `wp_options` VALUES("1226", "woocommerce_gateway_order", "a:7:{s:19:\"_wc_pes_woopayments\";i:0;s:20:\"woocommerce_payments\";i:1;s:25:\"_wc_pes_paypal_full_stack\";i:2;s:33:\"_wc_offline_payment_methods_group\";i:3;s:4:\"bacs\";i:4;s:6:\"cheque\";i:5;s:3:\"cod\";i:6;}", "auto");
INSERT INTO `wp_options` VALUES("488", "jetpack_connection_active_plugins", "a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:11:\"WooCommerce\";}}", "auto");
INSERT INTO `wp_options` VALUES("489", "WordPress\\TumblrImporter\\Tumblr_Import", "a:5:{s:11:\"consumerkey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:5:\"dupes\";a:0:{}s:5:\"email\";N;s:8:\"password\";N;}", "auto");
INSERT INTO `wp_options` VALUES("674", "_transient_health-check-site-status-result", "{\"good\":17,\"recommended\":7,\"critical\":0}", "on");
INSERT INTO `wp_options` VALUES("216", "action_scheduler_hybrid_store_demarkation", "9", "auto");
INSERT INTO `wp_options` VALUES("217", "schema-ActionScheduler_StoreSchema", "7.0.1740422280", "auto");
INSERT INTO `wp_options` VALUES("218", "schema-ActionScheduler_LoggerSchema", "3.0.1740422280", "auto");
INSERT INTO `wp_options` VALUES("361", "woocommerce_admin_install_timestamp", "1740422281", "auto");
INSERT INTO `wp_options` VALUES("277", "woocommerce_tax_classes", "", "on");
INSERT INTO `wp_options` VALUES("278", "woocommerce_tax_display_shop", "excl", "on");
INSERT INTO `wp_options` VALUES("279", "woocommerce_tax_display_cart", "excl", "on");
INSERT INTO `wp_options` VALUES("274", "woocommerce_tax_based_on", "shipping", "on");
INSERT INTO `wp_options` VALUES("275", "woocommerce_shipping_tax_class", "inherit", "on");
INSERT INTO `wp_options` VALUES("276", "woocommerce_tax_round_at_subtotal", "no", "on");
INSERT INTO `wp_options` VALUES("280", "woocommerce_price_display_suffix", "", "on");
INSERT INTO `wp_options` VALUES("281", "woocommerce_tax_total_display", "itemized", "off");
INSERT INTO `wp_options` VALUES("282", "woocommerce_enable_shipping_calc", "yes", "off");
INSERT INTO `wp_options` VALUES("283", "woocommerce_shipping_cost_requires_address", "no", "on");
INSERT INTO `wp_options` VALUES("284", "woocommerce_ship_to_destination", "billing", "off");
INSERT INTO `wp_options` VALUES("285", "woocommerce_shipping_debug_mode", "no", "on");
INSERT INTO `wp_options` VALUES("286", "woocommerce_enable_guest_checkout", "yes", "off");
INSERT INTO `wp_options` VALUES("287", "woocommerce_enable_checkout_login_reminder", "no", "off");
INSERT INTO `wp_options` VALUES("288", "woocommerce_enable_signup_and_login_from_checkout", "no", "off");
INSERT INTO `wp_options` VALUES("289", "woocommerce_enable_myaccount_registration", "no", "off");
INSERT INTO `wp_options` VALUES("290", "woocommerce_registration_generate_password", "yes", "off");
INSERT INTO `wp_options` VALUES("291", "woocommerce_registration_generate_username", "yes", "off");
INSERT INTO `wp_options` VALUES("292", "woocommerce_erasure_request_removes_order_data", "no", "off");
INSERT INTO `wp_options` VALUES("293", "woocommerce_erasure_request_removes_download_data", "no", "off");
INSERT INTO `wp_options` VALUES("294", "woocommerce_allow_bulk_remove_personal_data", "no", "off");
INSERT INTO `wp_options` VALUES("295", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "on");
INSERT INTO `wp_options` VALUES("296", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما، پشتیبانی از تجربه شما در سراسر این وب سایت و برای اهدافی که در [privacy_policy] ذکر شده است استفاده می شود.", "on");
INSERT INTO `wp_options` VALUES("297", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("298", "woocommerce_trash_pending_orders", "", "off");
INSERT INTO `wp_options` VALUES("299", "woocommerce_trash_failed_orders", "", "off");
INSERT INTO `wp_options` VALUES("300", "woocommerce_trash_cancelled_orders", "", "off");
INSERT INTO `wp_options` VALUES("301", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("302", "woocommerce_email_from_name", "اریک تاروت &#8211; کارت تاروت &#8211; فال تاروت", "off");
INSERT INTO `wp_options` VALUES("303", "woocommerce_email_from_address", "tabmehrnaz@gmail.com", "off");
INSERT INTO `wp_options` VALUES("304", "woocommerce_email_header_image", "", "off");
INSERT INTO `wp_options` VALUES("305", "woocommerce_email_base_color", "#720eec", "off");
INSERT INTO `wp_options` VALUES("306", "woocommerce_email_background_color", "#f7f7f7", "off");
INSERT INTO `wp_options` VALUES("307", "woocommerce_email_body_background_color", "#ffffff", "off");
INSERT INTO `wp_options` VALUES("308", "woocommerce_email_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("309", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "off");
INSERT INTO `wp_options` VALUES("310", "woocommerce_email_footer_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("311", "woocommerce_merchant_email_notifications", "no", "off");
INSERT INTO `wp_options` VALUES("312", "woocommerce_cart_page_id", "11", "off");
INSERT INTO `wp_options` VALUES("313", "woocommerce_checkout_page_id", "12", "off");
INSERT INTO `wp_options` VALUES("314", "woocommerce_myaccount_page_id", "13", "off");
INSERT INTO `wp_options` VALUES("315", "woocommerce_terms_page_id", "", "off");
INSERT INTO `wp_options` VALUES("316", "woocommerce_checkout_pay_endpoint", "order-pay", "on");
INSERT INTO `wp_options` VALUES("317", "woocommerce_checkout_order_received_endpoint", "order-received", "on");
INSERT INTO `wp_options` VALUES("318", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "on");
INSERT INTO `wp_options` VALUES("319", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "on");
INSERT INTO `wp_options` VALUES("320", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "on");
INSERT INTO `wp_options` VALUES("321", "woocommerce_myaccount_orders_endpoint", "orders", "on");
INSERT INTO `wp_options` VALUES("322", "woocommerce_myaccount_view_order_endpoint", "view-order", "on");
INSERT INTO `wp_options` VALUES("323", "woocommerce_myaccount_downloads_endpoint", "downloads", "on");
INSERT INTO `wp_options` VALUES("324", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "on");
INSERT INTO `wp_options` VALUES("325", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "on");
INSERT INTO `wp_options` VALUES("326", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "on");
INSERT INTO `wp_options` VALUES("327", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "on");
INSERT INTO `wp_options` VALUES("328", "woocommerce_logout_endpoint", "customer-logout", "on");
INSERT INTO `wp_options` VALUES("329", "woocommerce_api_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("330", "woocommerce_allow_tracking", "yes", "on");
INSERT INTO `wp_options` VALUES("331", "woocommerce_show_marketplace_suggestions", "yes", "off");
INSERT INTO `wp_options` VALUES("332", "woocommerce_custom_orders_table_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("333", "woocommerce_analytics_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("334", "woocommerce_feature_rate_limit_checkout_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("335", "woocommerce_feature_order_attribution_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("336", "woocommerce_feature_site_visibility_badge_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("337", "woocommerce_feature_remote_logging_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("338", "woocommerce_feature_product_block_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("339", "woocommerce_hpos_fts_index_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("340", "woocommerce_feature_email_improvements_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("341", "woocommerce_feature_cost_of_goods_sold_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("342", "woocommerce_single_image_width", "600", "on");
INSERT INTO `wp_options` VALUES("343", "woocommerce_thumbnail_image_width", "300", "on");
INSERT INTO `wp_options` VALUES("344", "woocommerce_checkout_highlight_required_fields", "yes", "on");
INSERT INTO `wp_options` VALUES("345", "woocommerce_demo_store", "no", "off");
INSERT INTO `wp_options` VALUES("346", "wc_downloads_approved_directories_mode", "enabled", "auto");
INSERT INTO `wp_options` VALUES("347", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("348", "current_theme_supports_woocommerce", "yes", "auto");
INSERT INTO `wp_options` VALUES("349", "woocommerce_queue_flush_rewrite_rules", "no", "auto");
INSERT INTO `wp_options` VALUES("352", "default_product_cat", "15", "auto");
INSERT INTO `wp_options` VALUES("400", "woocommerce_custom_orders_table_created", "yes", "auto");
INSERT INTO `wp_options` VALUES("354", "woocommerce_refund_returns_page_id", "14", "auto");
INSERT INTO `wp_options` VALUES("357", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:20:\"tabmehrnaz@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:20:\"tabmehrnaz@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "on");
INSERT INTO `wp_options` VALUES("358", "woocommerce_version", "9.7.1", "auto");
INSERT INTO `wp_options` VALUES("359", "woocommerce_db_version", "9.7.1", "auto");
INSERT INTO `wp_options` VALUES("360", "woocommerce_store_id", "418478a0-360d-4270-aab2-3fdbaaa04a44", "auto");
INSERT INTO `wp_options` VALUES("362", "woocommerce_inbox_variant_assignment", "12", "auto");
INSERT INTO `wp_options` VALUES("363", "woocommerce_remote_variant_assignment", "73", "auto");
INSERT INTO `wp_options` VALUES("372", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"DwxmWLfV4gsYp7vNfVkhUP2naOzQFTrn\";}", "on");
INSERT INTO `wp_options` VALUES("368", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "on");
INSERT INTO `wp_options` VALUES("369", "action_scheduler_lock_async-request-runner", "693cf67c4a63e4.46209381|1765603000", "no");
INSERT INTO `wp_options` VALUES("370", "woocommerce_admin_notices", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("371", "wc_blocks_version", "11.8.0-dev", "auto");
INSERT INTO `wp_options` VALUES("373", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("374", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("375", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("376", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("377", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("378", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("379", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("380", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("381", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("382", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("383", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("384", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("385", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("386", "widget_wc_brands_brand_description", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("387", "widget_woocommerce_brand_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("388", "widget_wc_brands_brand_thumbnails", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120537", "_site_transient_timeout_woocommerce_blocks_patterns", "1767986254", "off");
INSERT INTO `wp_options` VALUES("120538", "_site_transient_woocommerce_blocks_patterns", "a:2:{s:7:\"version\";s:5:\"9.7.1\";s:8:\"patterns\";a:42:{i:0;a:11:{s:5:\"title\";s:6:\"Banner\";s:4:\"slug\";s:25:\"woocommerce-blocks/banner\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:76:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/banner.php\";}i:1;a:11:{s:5:\"title\";s:23:\"Coming Soon Entire Site\";s:4:\"slug\";s:35:\"woocommerce/coming-soon-entire-site\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:93:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/coming-soon-entire-site.php\";}i:2;a:11:{s:5:\"title\";s:22:\"Coming Soon Store Only\";s:4:\"slug\";s:34:\"woocommerce/coming-soon-store-only\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:92:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/coming-soon-store-only.php\";}i:3;a:11:{s:5:\"title\";s:11:\"Coming Soon\";s:4:\"slug\";s:23:\"woocommerce/coming-soon\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:81:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/coming-soon.php\";}i:4;a:11:{s:5:\"title\";s:29:\"Content right with image left\";s:4:\"slug\";s:48:\"woocommerce-blocks/content-right-with-image-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:94:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/content-right-image-left.php\";}i:5;a:11:{s:5:\"title\";s:29:\"Featured Category Cover Image\";s:4:\"slug\";s:48:\"woocommerce-blocks/featured-category-cover-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:99:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/featured-category-cover-image.php\";}i:6;a:11:{s:5:\"title\";s:24:\"Featured Category Triple\";s:4:\"slug\";s:43:\"woocommerce-blocks/featured-category-triple\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:94:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/featured-category-triple.php\";}i:7;a:11:{s:5:\"title\";s:15:\"Product Filters\";s:4:\"slug\";s:34:\"woocommerce-blocks/product-filters\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:108:\"woocommerce/active-filters, woocommerce/price-filter, woocommerce/attribute-filter, woocommerce/stock-filter\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:77:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/filters.php\";}i:8;a:11:{s:5:\"title\";s:12:\"Large Footer\";s:4:\"slug\";s:31:\"woocommerce-blocks/footer-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:82:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/footer-large.php\";}i:9;a:11:{s:5:\"title\";s:23:\"Footer with Simple Menu\";s:4:\"slug\";s:37:\"woocommerce-blocks/footer-simple-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:88:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/footer-simple-menu.php\";}i:10;a:11:{s:5:\"title\";s:17:\"Footer with menus\";s:4:\"slug\";s:38:\"woocommerce-blocks/footer-with-3-menus\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:89:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/footer-with-3-menus.php\";}i:11;a:11:{s:5:\"title\";s:28:\"Four Image Grid Content Left\";s:4:\"slug\";s:47:\"woocommerce-blocks/form-image-grid-content-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:98:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/four-image-grid-content-left.php\";}i:12;a:11:{s:5:\"title\";s:20:\"Centered Header Menu\";s:4:\"slug\";s:39:\"woocommerce-blocks/header-centered-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:93:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/header-centered-pattern.php\";}i:13;a:11:{s:5:\"title\";s:23:\"Distraction Free Header\";s:4:\"slug\";s:42:\"woocommerce-blocks/header-distraction-free\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:93:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/header-distraction-free.php\";}i:14;a:11:{s:5:\"title\";s:16:\"Essential Header\";s:4:\"slug\";s:35:\"woocommerce-blocks/header-essential\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:86:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/header-essential.php\";}i:15;a:11:{s:5:\"title\";s:12:\"Large Header\";s:4:\"slug\";s:31:\"woocommerce-blocks/header-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:82:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/header-large.php\";}i:16;a:11:{s:5:\"title\";s:14:\"Minimal Header\";s:4:\"slug\";s:33:\"woocommerce-blocks/header-minimal\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:84:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/header-minimal.php\";}i:17;a:11:{s:5:\"title\";s:47:\"Heading with three columns of content with link\";s:4:\"slug\";s:66:\"woocommerce-blocks/heading-with-three-columns-of-content-with-link\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:117:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/heading-with-three-columns-of-content-with-link.php\";}i:18;a:11:{s:5:\"title\";s:20:\"Hero Product 3 Split\";s:4:\"slug\";s:39:\"woocommerce-blocks/hero-product-3-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:90:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/hero-product-3-split.php\";}i:19;a:11:{s:5:\"title\";s:23:\"Hero Product Chessboard\";s:4:\"slug\";s:42:\"woocommerce-blocks/hero-product-chessboard\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:93:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/hero-product-chessboard.php\";}i:20;a:11:{s:5:\"title\";s:18:\"Hero Product Split\";s:4:\"slug\";s:37:\"woocommerce-blocks/hero-product-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:88:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/hero-product-split.php\";}i:21;a:11:{s:5:\"title\";s:33:\"Centered content with image below\";s:4:\"slug\";s:52:\"woocommerce-blocks/centered-content-with-image-below\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:109:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/intro-centered-content-with-image-below.php\";}i:22;a:11:{s:5:\"title\";s:22:\"Just Arrived Full Hero\";s:4:\"slug\";s:41:\"woocommerce-blocks/just-arrived-full-hero\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:92:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/just-arrived-full-hero.php\";}i:23;a:11:{s:5:\"title\";s:33:\"No Products Found - Clear Filters\";s:4:\"slug\";s:43:\"woocommerce/no-products-found-clear-filters\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:95:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/no-products-found-filters.php\";}i:24;a:11:{s:5:\"title\";s:17:\"No Products Found\";s:4:\"slug\";s:29:\"woocommerce/no-products-found\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:87:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/no-products-found.php\";}i:25;a:11:{s:5:\"title\";s:19:\"Default Coming Soon\";s:4:\"slug\";s:36:\"woocommerce/page-coming-soon-default\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:31:\"coming-soon-newsletter-template\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:94:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/page-coming-soon-default.php\";}i:26;a:11:{s:5:\"title\";s:25:\"Coming Soon Image Gallery\";s:4:\"slug\";s:42:\"woocommerce/page-coming-soon-image-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:31:\"coming-soon-newsletter-template\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:100:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/page-coming-soon-image-gallery.php\";}i:27;a:11:{s:5:\"title\";s:30:\"Coming Soon Minimal Left Image\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-minimal-left-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:31:\"coming-soon-newsletter-template\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:105:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/page-coming-soon-minimal-left-image.php\";}i:28;a:11:{s:5:\"title\";s:24:\"Coming Soon Modern Black\";s:4:\"slug\";s:41:\"woocommerce/page-coming-soon-modern-black\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:31:\"coming-soon-newsletter-template\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:99:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/page-coming-soon-modern-black.php\";}i:29;a:11:{s:5:\"title\";s:29:\"Coming Soon Split Right Image\";s:4:\"slug\";s:46:\"woocommerce/page-coming-soon-split-right-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:31:\"coming-soon-newsletter-template\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:104:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/page-coming-soon-split-right-image.php\";}i:30;a:11:{s:5:\"title\";s:34:\"Coming Soon With Header and Footer\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-with-header-footer\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:31:\"coming-soon-newsletter-template\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:105:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/page-coming-soon-with-header-footer.php\";}i:31;a:11:{s:5:\"title\";s:28:\"Product Collection 3 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:98:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/product-collection-3-columns.php\";}i:32;a:11:{s:5:\"title\";s:28:\"Product Collection 4 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-4-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:98:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/product-collection-4-columns.php\";}i:33;a:11:{s:5:\"title\";s:28:\"Product Collection 5 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:98:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/product-collection-5-columns.php\";}i:34;a:11:{s:5:\"title\";s:47:\"Product Collection: Featured Products 5 Columns\";s:4:\"slug\";s:65:\"woocommerce-blocks/product-collection-featured-products-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:116:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/product-collection-featured-products-5-columns.php\";}i:35;a:11:{s:5:\"title\";s:15:\"Product Gallery\";s:4:\"slug\";s:48:\"woocommerce-blocks/product-query-product-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:36:\"core/query/woocommerce/product-query\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:99:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/product-query-product-gallery.php\";}i:36;a:11:{s:5:\"title\";s:14:\"Product Search\";s:4:\"slug\";s:31:\"woocommerce/product-search-form\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:89:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/product-search-form.php\";}i:37;a:11:{s:5:\"title\";s:16:\"Related Products\";s:4:\"slug\";s:35:\"woocommerce-blocks/related-products\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:86:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/related-products.php\";}i:38;a:11:{s:5:\"title\";s:33:\"Social: Follow us on social media\";s:4:\"slug\";s:51:\"woocommerce-blocks/social-follow-us-in-social-media\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:25:\"WooCommerce, social-media\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:102:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/social-follow-us-in-social-media.php\";}i:39;a:11:{s:5:\"title\";s:22:\"Testimonials 3 Columns\";s:4:\"slug\";s:41:\"woocommerce-blocks/testimonials-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:92:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/testimonials-3-columns.php\";}i:40;a:11:{s:5:\"title\";s:19:\"Testimonials Single\";s:4:\"slug\";s:38:\"woocommerce-blocks/testimonials-single\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:89:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/testimonials-single.php\";}i:41;a:11:{s:5:\"title\";s:37:\"Three columns with images and content\";s:4:\"slug\";s:56:\"woocommerce-blocks/three-columns-with-images-and-content\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:107:\"/home/cp62750/public_html/wp-content/plugins/woocommerce/patterns/three-columns-with-images-and-content.php\";}}}", "off");
INSERT INTO `wp_options` VALUES("416", "wc_blocks_db_schema_version", "260", "auto");
INSERT INTO `wp_options` VALUES("397", "woocommerce_admin_pes_incentive_woopayments_store_had_woopayments", "no", "auto");
INSERT INTO `wp_options` VALUES("1572", "jetpack_sync_settings_disable", "0", "on");
INSERT INTO `wp_options` VALUES("401", "woocommerce_coming_soon", "no", "auto");
INSERT INTO `wp_options` VALUES("402", "woocommerce_store_pages_only", "no", "auto");
INSERT INTO `wp_options` VALUES("403", "woocommerce_initial_installed_version", "9.6.2", "off");
INSERT INTO `wp_options` VALUES("413", "jetpack_options", "a:5:{s:14:\"last_heartbeat\";i:1765564714;s:28:\"fallback_no_verify_ssl_certs\";i:0;s:9:\"time_diff\";i:0;s:2:\"id\";i:242119308;s:6:\"public\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("1997", "jetpack_sync_dedicated_spawn_lock", "1740680846.0397", "no");
INSERT INTO `wp_options` VALUES("11850", "product_cat_children", "a:1:{i:15;a:7:{i:0;i:20;i:1;i:34;i:2;i:198;i:3;i:199;i:4;i:200;i:5;i:201;i:6;i:202;}}", "auto");
INSERT INTO `wp_options` VALUES("110067", "_transient_timeout_wc_term_counts", "1766125206", "off");
INSERT INTO `wp_options` VALUES("110068", "_transient_wc_term_counts", "a:65:{i:86;s:0:\"\";i:87;s:0:\"\";i:54;s:0:\"\";i:55;s:0:\"\";i:39;s:0:\"\";i:41;s:0:\"\";i:56;s:0:\"\";i:57;s:0:\"\";i:58;s:0:\"\";i:168;s:0:\"\";i:60;s:0:\"\";i:61;s:0:\"\";i:42;s:0:\"\";i:2;s:0:\"\";i:43;s:0:\"\";i:62;s:0:\"\";i:71;s:0:\"\";i:72;s:0:\"\";i:73;s:0:\"\";i:74;s:0:\"\";i:92;s:0:\"\";i:29;s:0:\"\";i:75;s:0:\"\";i:76;s:0:\"\";i:77;s:0:\"\";i:30;s:0:\"\";i:45;s:0:\"\";i:78;s:0:\"\";i:46;s:0:\"\";i:93;s:0:\"\";i:31;s:0:\"\";i:94;s:0:\"\";i:32;s:0:\"\";i:63;s:0:\"\";i:64;s:0:\"\";i:33;s:0:\"\";i:48;s:0:\"\";i:49;s:0:\"\";i:66;s:0:\"\";i:50;s:0:\"\";i:80;s:0:\"\";i:88;s:0:\"\";i:81;s:0:\"\";i:82;s:0:\"\";i:169;s:0:\"\";i:20;s:0:\"\";i:26;s:0:\"\";i:83;s:0:\"\";i:84;s:0:\"\";i:67;s:0:\"\";i:35;s:0:\"\";i:85;s:0:\"\";i:68;s:0:\"\";i:69;s:0:\"\";i:170;s:0:\"\";i:99;s:0:\"\";i:34;s:0:\"\";i:90;s:0:\"\";i:100;s:0:\"\";i:101;s:0:\"\";i:36;s:0:\"\";i:4;s:0:\"\";i:195;s:0:\"\";i:194;s:0:\"\";i:192;s:0:\"\";}", "off");
INSERT INTO `wp_options` VALUES("78802", "aios_antibot_key_map_info", "a:3:{i:0;a:3:{i:0;a:2:{i:0;s:8:\"pnc6ab8v\";i:1;s:12:\"qymz9p1seth7\";}i:1;a:2:{i:0;s:8:\"3dy92xz8\";i:1;s:12:\"rbjbh2s2ry6w\";}i:2;a:2:{i:0;s:8:\"30f7u9eb\";i:1;s:12:\"2qhgu57f3ney\";}}i:1;a:2:{i:0;a:2:{i:0;s:8:\"p0sqzrqr\";i:1;s:12:\"0vkhtk17ctli\";}i:1;a:2:{i:0;s:8:\"013jridr\";i:1;s:12:\"n6t57btd1vbw\";}}i:2;i:1765929600;}", "off");
INSERT INTO `wp_options` VALUES("78803", "aiowpsec_db_version", "2.1.4", "auto");
INSERT INTO `wp_options` VALUES("78801", "aio_wp_security_configs", "a:115:{s:19:\"aiowps_enable_debug\";s:0:\"\";s:36:\"aiowps_enable_php_backtrace_in_email\";s:0:\"\";s:36:\"aiowps_remove_wp_generator_meta_info\";s:0:\"\";s:25:\"aiowps_prevent_hotlinking\";s:0:\"\";s:28:\"aiowps_enable_login_lockdown\";s:0:\"\";s:28:\"aiowps_allow_unlock_requests\";s:1:\"1\";s:25:\"aiowps_max_login_attempts\";s:1:\"3\";s:24:\"aiowps_retry_time_period\";s:1:\"5\";s:26:\"aiowps_lockout_time_length\";s:1:\"5\";s:30:\"aiowps_max_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_set_generic_login_msg\";s:0:\"\";s:26:\"aiowps_enable_email_notify\";s:0:\"\";s:20:\"aiowps_email_address\";s:20:\"tabmehrnaz@gmail.com\";s:27:\"aiowps_enable_forced_logout\";s:0:\"\";s:25:\"aiowps_logout_time_period\";s:2:\"60\";s:39:\"aiowps_enable_invalid_username_lockdown\";s:0:\"\";s:43:\"aiowps_instantly_lockout_specific_usernames\";a:0:{}s:32:\"aiowps_unlock_request_secret_key\";s:20:\"wpcjj1ykqpvu0znrdu2c\";s:35:\"aiowps_lockdown_enable_whitelisting\";s:0:\"\";s:36:\"aiowps_lockdown_allowed_ip_addresses\";s:0:\"\";s:32:\"aiowps_http_authentication_admin\";s:0:\"\";s:35:\"aiowps_http_authentication_frontend\";s:0:\"\";s:35:\"aiowps_http_authentication_username\";s:4:\"root\";s:35:\"aiowps_http_authentication_password\";s:8:\"password\";s:42:\"aiowps_http_authentication_failure_message\";s:21:\"<h1>Unauthorized</h1>\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:0:\"\";s:22:\"aiowps_default_captcha\";s:11:\"simple-math\";s:27:\"aiowps_enable_login_captcha\";s:1:\"1\";s:34:\"aiowps_enable_custom_login_captcha\";s:1:\"1\";s:40:\"aiowps_enable_password_protected_captcha\";s:1:\"1\";s:31:\"aiowps_enable_woo_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_register_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_checkout_captcha\";s:0:\"\";s:38:\"aiowps_enable_woo_lostpassword_captcha\";s:0:\"\";s:36:\"aiowps_enable_contact_form_7_captcha\";s:0:\"\";s:25:\"aiowps_captcha_secret_key\";s:20:\"5kpgaefulz69d4y472tk\";s:42:\"aiowps_enable_manual_registration_approval\";s:0:\"\";s:39:\"aiowps_enable_registration_page_captcha\";s:1:\"1\";s:35:\"aiowps_enable_registration_honeypot\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:27:\"aiowps_disable_file_editing\";s:0:\"\";s:37:\"aiowps_prevent_default_wp_file_access\";s:0:\"\";s:35:\"aiowps_auto_delete_default_wp_files\";s:0:\"\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:0:\"\";s:26:\"aiowps_banned_ip_addresses\";s:0:\"\";s:28:\"aiowps_enable_basic_firewall\";s:0:\"\";s:27:\"aiowps_max_file_upload_size\";i:100;s:38:\"aiowps_disable_xmlrpc_pingback_methods\";s:0:\"\";s:33:\"aiowps_disable_rss_and_atom_feeds\";s:0:\"\";s:34:\"aiowps_block_debug_log_file_access\";s:0:\"\";s:26:\"aiowps_disable_index_views\";s:0:\"\";s:30:\"aiowps_disable_trace_and_track\";s:0:\"\";s:25:\"aiowps_enable_5g_firewall\";s:0:\"\";s:25:\"aiowps_enable_6g_firewall\";s:0:\"\";s:26:\"aiowps_enable_custom_rules\";s:0:\"\";s:32:\"aiowps_place_custom_rules_at_top\";s:0:\"\";s:19:\"aiowps_custom_rules\";s:0:\"\";s:32:\"aiowps_upgrade_unsafe_http_calls\";s:0:\"\";s:47:\"aiowps_upgrade_unsafe_http_calls_url_exceptions\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:0:\"\";s:28:\"aiowps_enable_404_IP_lockout\";s:0:\"\";s:30:\"aiowps_404_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:1:\"1\";s:28:\"aiowps_enable_login_honeypot\";s:0:\"\";s:35:\"aiowps_disable_application_password\";s:0:\"\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:0:\"\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:0:\"\";s:30:\"aiowps_enable_spambot_blocking\";s:0:\"\";s:29:\"aiowps_enable_comment_captcha\";s:1:\"1\";s:33:\"aiowps_spam_ip_min_comments_block\";s:0:\"\";s:33:\"aiowps_enable_bp_register_captcha\";s:0:\"\";s:35:\"aiowps_enable_bbp_new_topic_captcha\";s:0:\"\";s:31:\"aiowps_enable_spambot_detecting\";s:0:\"\";s:32:\"aiowps_spambot_detect_usecookies\";s:0:\"\";s:27:\"aiowps_spam_comments_should\";s:0:\"\";s:33:\"aiowps_enable_trash_spam_comments\";s:0:\"\";s:37:\"aiowps_trash_spam_comments_after_days\";s:2:\"14\";s:32:\"aiowps_enable_automated_fcd_scan\";s:0:\"\";s:25:\"aiowps_fcd_scan_frequency\";s:1:\"4\";s:24:\"aiowps_fcd_scan_interval\";s:1:\"2\";s:28:\"aiowps_fcd_exclude_filetypes\";s:0:\"\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:0:\"\";s:29:\"aiowps_fcd_scan_email_address\";s:20:\"tabmehrnaz@gmail.com\";s:27:\"aiowps_fcds_change_detected\";b:0;s:22:\"aiowps_copy_protection\";s:0:\"\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:0:\"\";s:32:\"aiowps_prevent_users_enumeration\";s:0:\"\";s:42:\"aiowps_disallow_unauthorized_rest_requests\";s:0:\"\";s:35:\"aios_roles_disallowed_rest_requests\";a:0:{}s:28:\"aios_whitelisted_rest_routes\";a:0:{}s:25:\"aiowps_turnstile_site_key\";s:24:\"0x4AAAAAABvukkq2zd0QEx0d\";s:27:\"aiowps_turnstile_secret_key\";s:35:\"0x4AAAAAABvukkXjfBrMlT0U5YOo6cFxbfs\";s:25:\"aiowps_recaptcha_site_key\";s:0:\"\";s:27:\"aiowps_recaptcha_secret_key\";s:0:\"\";s:24:\"aiowps_default_recaptcha\";s:0:\"\";s:36:\"aiowps_on_uninstall_delete_db_tables\";s:1:\"1\";s:34:\"aiowps_on_uninstall_delete_configs\";s:1:\"1\";s:12:\"installed-at\";i:1756469929;s:31:\"aiowps_enable_pingback_firewall\";s:1:\"0\";s:28:\"aiowps_forbid_proxy_comments\";s:1:\"0\";s:29:\"aiowps_deny_bad_query_strings\";s:1:\"0\";s:34:\"aiowps_advanced_char_string_filter\";s:1:\"0\";s:22:\"aiowps_login_page_slug\";s:7:\"voroood\";s:35:\"aiowps_enable_lost_password_captcha\";s:1:\"1\";s:22:\"aiowps_turnstile_theme\";s:4:\"auto\";}", "auto");
INSERT INTO `wp_options` VALUES("924", "woocommerce_tracker_ua", "a:10:{i:0;s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36\";i:1;s:145:\"Mozilla/5.0 (iPhone; CPU iPhone OS 18_1_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/133.0.6943.120 Mobile/15E148 Safari/604.1\";i:2;s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36\";i:3;s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36\";i:4;s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36\";i:5;s:144:\"Mozilla/5.0 (iPhone; CPU iPhone OS 18_5_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137.0.7151.51 Mobile/15E148 Safari/604.1\";i:6;s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36\";i:7;s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36\";i:8;s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36\";i:9;s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";}", "off");
INSERT INTO `wp_options` VALUES("121118", "_site_transient_timeout_woocommerce_block_asset_resource_hints", "1766105959", "off");
INSERT INTO `wp_options` VALUES("121119", "_site_transient_woocommerce_block_asset_resource_hints", "a:2:{s:5:\"files\";a:2:{s:13:\"cart-frontend\";a:43:{i:0;a:2:{s:4:\"href\";s:115:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/cart-frontend.js?ver=27713dd06dd798d49233\";s:2:\"as\";s:6:\"script\";}i:1;a:2:{s:4:\"href\";s:132:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-cart-checkout-base-frontend.js?ver=c805309b07586da6f60a\";s:2:\"as\";s:6:\"script\";}i:2;a:2:{s:4:\"href\";s:78:\"https://erictarot.com/wp-includes/js/dist/vendor/wp-polyfill.min.js?ver=3.15.0\";s:2:\"as\";s:6:\"script\";}i:3;a:2:{s:4:\"href\";s:78:\"https://erictarot.com/wp-includes/js/dist/i18n.min.js?ver=c26c3dc7bed366793375\";s:2:\"as\";s:6:\"script\";}i:4;a:2:{s:4:\"href\";s:79:\"https://erictarot.com/wp-includes/js/dist/hooks.min.js?ver=dd5603f07f9220ed27f1\";s:2:\"as\";s:6:\"script\";}i:5;a:2:{s:4:\"href\";s:135:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-cart-checkout-vendors-frontend.js?ver=59277a6dafa851088bd0\";s:2:\"as\";s:6:\"script\";}i:9;a:2:{s:4:\"href\";s:74:\"https://erictarot.com/wp-includes/js/dist/vendor/react.min.js?ver=18.3.1.1\";s:2:\"as\";s:6:\"script\";}i:10;a:2:{s:4:\"href\";s:117:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/blocks-checkout.js?ver=8675f044a5a4e373bfec\";s:2:\"as\";s:6:\"script\";}i:20;a:2:{s:4:\"href\";s:78:\"https://erictarot.com/wp-includes/js/dist/vendor/react-dom.min.js?ver=18.3.1.1\";s:2:\"as\";s:6:\"script\";}i:22;a:2:{s:4:\"href\";s:119:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/blocks-components.js?ver=0c39bf995e247714a767\";s:2:\"as\";s:6:\"script\";}i:34;a:2:{s:4:\"href\";s:116:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-blocks-data.js?ver=38d3da1666bedcf43575\";s:2:\"as\";s:6:\"script\";}i:35;a:2:{s:4:\"href\";s:120:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-blocks-registry.js?ver=cbfeee947018662b965a\";s:2:\"as\";s:6:\"script\";}i:37;a:2:{s:4:\"href\";s:113:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-settings.js?ver=eb5ac71a827c4c81fed8\";s:2:\"as\";s:6:\"script\";}i:40;a:2:{s:4:\"href\";s:83:\"https://erictarot.com/wp-includes/js/dist/api-fetch.min.js?ver=3a4d9af2b423048b0dee\";s:2:\"as\";s:6:\"script\";}i:43;a:2:{s:4:\"href\";s:77:\"https://erictarot.com/wp-includes/js/dist/url.min.js?ver=9e178c9516d1222dc834\";s:2:\"as\";s:6:\"script\";}i:47;a:2:{s:4:\"href\";s:78:\"https://erictarot.com/wp-includes/js/dist/data.min.js?ver=f940198280891b0b6318\";s:2:\"as\";s:6:\"script\";}i:48;a:2:{s:4:\"href\";s:84:\"https://erictarot.com/wp-includes/js/dist/vendor/react-jsx-runtime.min.js?ver=18.3.1\";s:2:\"as\";s:6:\"script\";}i:50;a:2:{s:4:\"href\";s:81:\"https://erictarot.com/wp-includes/js/dist/compose.min.js?ver=7a9b375d8c19cf9d3d9b\";s:2:\"as\";s:6:\"script\";}i:54;a:2:{s:4:\"href\";s:84:\"https://erictarot.com/wp-includes/js/dist/deprecated.min.js?ver=e1f84915c5e8ae38964c\";s:2:\"as\";s:6:\"script\";}i:56;a:2:{s:4:\"href\";s:77:\"https://erictarot.com/wp-includes/js/dist/dom.min.js?ver=26edef3be6483da3de2e\";s:2:\"as\";s:6:\"script\";}i:59;a:2:{s:4:\"href\";s:81:\"https://erictarot.com/wp-includes/js/dist/element.min.js?ver=6a582b0c827fa25df3dd\";s:2:\"as\";s:6:\"script\";}i:63;a:2:{s:4:\"href\";s:85:\"https://erictarot.com/wp-includes/js/dist/escape-html.min.js?ver=6561a406d2d232a6fbd2\";s:2:\"as\";s:6:\"script\";}i:64;a:2:{s:4:\"href\";s:90:\"https://erictarot.com/wp-includes/js/dist/is-shallow-equal.min.js?ver=e0f9f1d78d83f5196979\";s:2:\"as\";s:6:\"script\";}i:65;a:2:{s:4:\"href\";s:82:\"https://erictarot.com/wp-includes/js/dist/keycodes.min.js?ver=34c8fb5e7a594a1c8037\";s:2:\"as\";s:6:\"script\";}i:68;a:2:{s:4:\"href\";s:88:\"https://erictarot.com/wp-includes/js/dist/priority-queue.min.js?ver=2d59d091223ee9a33838\";s:2:\"as\";s:6:\"script\";}i:78;a:2:{s:4:\"href\";s:86:\"https://erictarot.com/wp-includes/js/dist/private-apis.min.js?ver=4f465748bda624774139\";s:2:\"as\";s:6:\"script\";}i:79;a:2:{s:4:\"href\";s:87:\"https://erictarot.com/wp-includes/js/dist/redux-routine.min.js?ver=8bb92d45458b29590f53\";s:2:\"as\";s:6:\"script\";}i:99;a:2:{s:4:\"href\";s:110:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-types.js?ver=bda84b1be3361607d04a\";s:2:\"as\";s:6:\"script\";}i:139;a:2:{s:4:\"href\";s:87:\"https://erictarot.com/wp-includes/js/dist/data-controls.min.js?ver=49f5587e8b90f9e7cc7e\";s:2:\"as\";s:6:\"script\";}i:191;a:2:{s:4:\"href\";s:87:\"https://erictarot.com/wp-includes/js/dist/html-entities.min.js?ver=e8b78b18a162491d5e5f\";s:2:\"as\";s:6:\"script\";}i:195;a:2:{s:4:\"href\";s:81:\"https://erictarot.com/wp-includes/js/dist/notices.min.js?ver=f62fbf15dcc23301922f\";s:2:\"as\";s:6:\"script\";}i:231;a:2:{s:4:\"href\";s:122:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-blocks-middleware.js?ver=f3c3ad2e0f2ca96a11da\";s:2:\"as\";s:6:\"script\";}i:251;a:2:{s:4:\"href\";s:78:\"https://erictarot.com/wp-includes/js/dist/a11y.min.js?ver=cb460b4676c94bd228ed\";s:2:\"as\";s:6:\"script\";}i:252;a:2:{s:4:\"href\";s:83:\"https://erictarot.com/wp-includes/js/dist/dom-ready.min.js?ver=f77871ff7694fffea381\";s:2:\"as\";s:6:\"script\";}i:318;a:2:{s:4:\"href\";s:84:\"https://erictarot.com/wp-includes/js/dist/primitives.min.js?ver=0b5dcc337aa7cbf75570\";s:2:\"as\";s:6:\"script\";}i:673;a:2:{s:4:\"href\";s:81:\"https://erictarot.com/wp-includes/js/dist/warning.min.js?ver=d69bc18c456d01c11d5a\";s:2:\"as\";s:6:\"script\";}i:1237;a:2:{s:4:\"href\";s:126:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-blocks-shared-context.js?ver=c30879d642ea05d65f5a\";s:2:\"as\";s:6:\"script\";}i:1247;a:2:{s:4:\"href\";s:123:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-blocks-shared-hocs.js?ver=cba59eca47d9101980bf\";s:2:\"as\";s:6:\"script\";}i:1506;a:2:{s:4:\"href\";s:114:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/price-format.js?ver=a3e67bb0b09f566d5bdf\";s:2:\"as\";s:6:\"script\";}i:1540;a:2:{s:4:\"href\";s:79:\"https://erictarot.com/wp-includes/js/dist/autop.min.js?ver=9fb50649848277dd318d\";s:2:\"as\";s:6:\"script\";}i:1608;a:2:{s:4:\"href\";s:81:\"https://erictarot.com/wp-includes/js/dist/plugins.min.js?ver=039ed87b5b9f7036ceee\";s:2:\"as\";s:6:\"script\";}i:1656;a:2:{s:4:\"href\";s:86:\"https://erictarot.com/wp-includes/js/dist/style-engine.min.js?ver=7c6fcedc37dadafb8a81\";s:2:\"as\";s:6:\"script\";}i:1658;a:2:{s:4:\"href\";s:83:\"https://erictarot.com/wp-includes/js/dist/wordcount.min.js?ver=c5b97f11206928ea9130\";s:2:\"as\";s:6:\"script\";}}s:17:\"checkout-frontend\";a:42:{i:0;a:2:{s:4:\"href\";s:119:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/checkout-frontend.js?ver=5dd64761c5edaf06069b\";s:2:\"as\";s:6:\"script\";}i:1;a:2:{s:4:\"href\";s:132:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-cart-checkout-base-frontend.js?ver=c805309b07586da6f60a\";s:2:\"as\";s:6:\"script\";}i:2;a:2:{s:4:\"href\";s:78:\"https://erictarot.com/wp-includes/js/dist/vendor/wp-polyfill.min.js?ver=3.15.0\";s:2:\"as\";s:6:\"script\";}i:3;a:2:{s:4:\"href\";s:78:\"https://erictarot.com/wp-includes/js/dist/i18n.min.js?ver=c26c3dc7bed366793375\";s:2:\"as\";s:6:\"script\";}i:4;a:2:{s:4:\"href\";s:79:\"https://erictarot.com/wp-includes/js/dist/hooks.min.js?ver=dd5603f07f9220ed27f1\";s:2:\"as\";s:6:\"script\";}i:5;a:2:{s:4:\"href\";s:135:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-cart-checkout-vendors-frontend.js?ver=59277a6dafa851088bd0\";s:2:\"as\";s:6:\"script\";}i:9;a:2:{s:4:\"href\";s:74:\"https://erictarot.com/wp-includes/js/dist/vendor/react.min.js?ver=18.3.1.1\";s:2:\"as\";s:6:\"script\";}i:10;a:2:{s:4:\"href\";s:117:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/blocks-checkout.js?ver=8675f044a5a4e373bfec\";s:2:\"as\";s:6:\"script\";}i:20;a:2:{s:4:\"href\";s:78:\"https://erictarot.com/wp-includes/js/dist/vendor/react-dom.min.js?ver=18.3.1.1\";s:2:\"as\";s:6:\"script\";}i:22;a:2:{s:4:\"href\";s:119:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/blocks-components.js?ver=0c39bf995e247714a767\";s:2:\"as\";s:6:\"script\";}i:34;a:2:{s:4:\"href\";s:116:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-blocks-data.js?ver=38d3da1666bedcf43575\";s:2:\"as\";s:6:\"script\";}i:35;a:2:{s:4:\"href\";s:120:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-blocks-registry.js?ver=cbfeee947018662b965a\";s:2:\"as\";s:6:\"script\";}i:37;a:2:{s:4:\"href\";s:113:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-settings.js?ver=eb5ac71a827c4c81fed8\";s:2:\"as\";s:6:\"script\";}i:40;a:2:{s:4:\"href\";s:83:\"https://erictarot.com/wp-includes/js/dist/api-fetch.min.js?ver=3a4d9af2b423048b0dee\";s:2:\"as\";s:6:\"script\";}i:43;a:2:{s:4:\"href\";s:77:\"https://erictarot.com/wp-includes/js/dist/url.min.js?ver=9e178c9516d1222dc834\";s:2:\"as\";s:6:\"script\";}i:47;a:2:{s:4:\"href\";s:78:\"https://erictarot.com/wp-includes/js/dist/data.min.js?ver=f940198280891b0b6318\";s:2:\"as\";s:6:\"script\";}i:48;a:2:{s:4:\"href\";s:84:\"https://erictarot.com/wp-includes/js/dist/vendor/react-jsx-runtime.min.js?ver=18.3.1\";s:2:\"as\";s:6:\"script\";}i:50;a:2:{s:4:\"href\";s:81:\"https://erictarot.com/wp-includes/js/dist/compose.min.js?ver=7a9b375d8c19cf9d3d9b\";s:2:\"as\";s:6:\"script\";}i:54;a:2:{s:4:\"href\";s:84:\"https://erictarot.com/wp-includes/js/dist/deprecated.min.js?ver=e1f84915c5e8ae38964c\";s:2:\"as\";s:6:\"script\";}i:56;a:2:{s:4:\"href\";s:77:\"https://erictarot.com/wp-includes/js/dist/dom.min.js?ver=26edef3be6483da3de2e\";s:2:\"as\";s:6:\"script\";}i:59;a:2:{s:4:\"href\";s:81:\"https://erictarot.com/wp-includes/js/dist/element.min.js?ver=6a582b0c827fa25df3dd\";s:2:\"as\";s:6:\"script\";}i:63;a:2:{s:4:\"href\";s:85:\"https://erictarot.com/wp-includes/js/dist/escape-html.min.js?ver=6561a406d2d232a6fbd2\";s:2:\"as\";s:6:\"script\";}i:64;a:2:{s:4:\"href\";s:90:\"https://erictarot.com/wp-includes/js/dist/is-shallow-equal.min.js?ver=e0f9f1d78d83f5196979\";s:2:\"as\";s:6:\"script\";}i:65;a:2:{s:4:\"href\";s:82:\"https://erictarot.com/wp-includes/js/dist/keycodes.min.js?ver=34c8fb5e7a594a1c8037\";s:2:\"as\";s:6:\"script\";}i:68;a:2:{s:4:\"href\";s:88:\"https://erictarot.com/wp-includes/js/dist/priority-queue.min.js?ver=2d59d091223ee9a33838\";s:2:\"as\";s:6:\"script\";}i:78;a:2:{s:4:\"href\";s:86:\"https://erictarot.com/wp-includes/js/dist/private-apis.min.js?ver=4f465748bda624774139\";s:2:\"as\";s:6:\"script\";}i:79;a:2:{s:4:\"href\";s:87:\"https://erictarot.com/wp-includes/js/dist/redux-routine.min.js?ver=8bb92d45458b29590f53\";s:2:\"as\";s:6:\"script\";}i:99;a:2:{s:4:\"href\";s:110:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-types.js?ver=bda84b1be3361607d04a\";s:2:\"as\";s:6:\"script\";}i:139;a:2:{s:4:\"href\";s:87:\"https://erictarot.com/wp-includes/js/dist/data-controls.min.js?ver=49f5587e8b90f9e7cc7e\";s:2:\"as\";s:6:\"script\";}i:191;a:2:{s:4:\"href\";s:87:\"https://erictarot.com/wp-includes/js/dist/html-entities.min.js?ver=e8b78b18a162491d5e5f\";s:2:\"as\";s:6:\"script\";}i:195;a:2:{s:4:\"href\";s:81:\"https://erictarot.com/wp-includes/js/dist/notices.min.js?ver=f62fbf15dcc23301922f\";s:2:\"as\";s:6:\"script\";}i:231;a:2:{s:4:\"href\";s:122:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-blocks-middleware.js?ver=f3c3ad2e0f2ca96a11da\";s:2:\"as\";s:6:\"script\";}i:251;a:2:{s:4:\"href\";s:78:\"https://erictarot.com/wp-includes/js/dist/a11y.min.js?ver=cb460b4676c94bd228ed\";s:2:\"as\";s:6:\"script\";}i:252;a:2:{s:4:\"href\";s:83:\"https://erictarot.com/wp-includes/js/dist/dom-ready.min.js?ver=f77871ff7694fffea381\";s:2:\"as\";s:6:\"script\";}i:318;a:2:{s:4:\"href\";s:84:\"https://erictarot.com/wp-includes/js/dist/primitives.min.js?ver=0b5dcc337aa7cbf75570\";s:2:\"as\";s:6:\"script\";}i:673;a:2:{s:4:\"href\";s:81:\"https://erictarot.com/wp-includes/js/dist/warning.min.js?ver=d69bc18c456d01c11d5a\";s:2:\"as\";s:6:\"script\";}i:1237;a:2:{s:4:\"href\";s:123:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-blocks-shared-hocs.js?ver=cba59eca47d9101980bf\";s:2:\"as\";s:6:\"script\";}i:1444;a:2:{s:4:\"href\";s:126:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/wc-blocks-shared-context.js?ver=c30879d642ea05d65f5a\";s:2:\"as\";s:6:\"script\";}i:1496;a:2:{s:4:\"href\";s:114:\"https://erictarot.com/wp-content/plugins/woocommerce/assets/client/blocks/price-format.js?ver=a3e67bb0b09f566d5bdf\";s:2:\"as\";s:6:\"script\";}i:1530;a:2:{s:4:\"href\";s:79:\"https://erictarot.com/wp-includes/js/dist/autop.min.js?ver=9fb50649848277dd318d\";s:2:\"as\";s:6:\"script\";}i:1632;a:2:{s:4:\"href\";s:81:\"https://erictarot.com/wp-includes/js/dist/plugins.min.js?ver=039ed87b5b9f7036ceee\";s:2:\"as\";s:6:\"script\";}i:1681;a:2:{s:4:\"href\";s:83:\"https://erictarot.com/wp-includes/js/dist/wordcount.min.js?ver=c5b97f11206928ea9130\";s:2:\"as\";s:6:\"script\";}}}s:7:\"version\";a:2:{s:11:\"woocommerce\";s:5:\"9.7.1\";s:9:\"wordpress\";s:3:\"6.9\";}}", "off");
INSERT INTO `wp_options` VALUES("105951", "_transient_timeout_wc_blocks_query_5363a57d92ddac380bcea0733b79eaad", "1767153431", "off");
INSERT INTO `wp_options` VALUES("105952", "_transient_wc_blocks_query_5363a57d92ddac380bcea0733b79eaad", "a:2:{s:7:\"version\";s:10:\"1764327731\";s:5:\"value\";a:4:{i:0;i:1473;i:1;i:1472;i:2;i:1436;i:3;i:1435;}}", "off");
INSERT INTO `wp_options` VALUES("692", "woocommerce_tracker_last_send", "1765212871", "auto");
INSERT INTO `wp_options` VALUES("412", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("114581", "_transient_wc_count_comments", "O:8:\"stdClass\":7:{s:14:\"total_comments\";i:1;s:3:\"all\";i:0;s:4:\"spam\";s:1:\"1\";s:9:\"moderated\";i:0;s:8:\"approved\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "on");
INSERT INTO `wp_options` VALUES("421", "woocommerce_checkout_phone_field", "optional", "auto");
INSERT INTO `wp_options` VALUES("422", "woocommerce_checkout_company_field", "hidden", "auto");
INSERT INTO `wp_options` VALUES("423", "woocommerce_checkout_address_2_field", "optional", "auto");
INSERT INTO `wp_options` VALUES("424", "_transient_woocommerce_reports-transient-version", "1765501280", "on");
INSERT INTO `wp_options` VALUES("439", "wc_has_tracked_default_theme", "1", "auto");
INSERT INTO `wp_options` VALUES("431", "woocommerce_onboarding_profile_progress", "a:1:{s:29:\"core_profiler_completed_steps\";a:4:{s:12:\"intro-opt-in\";a:1:{s:12:\"completed_at\";s:20:\"2025-02-24T18:38:23Z\";}s:12:\"user-profile\";a:1:{s:12:\"completed_at\";s:20:\"2025-02-24T18:38:29Z\";}s:13:\"business-info\";a:1:{s:12:\"completed_at\";s:20:\"2025-02-24T18:39:07Z\";}s:7:\"plugins\";a:1:{s:12:\"completed_at\";s:20:\"2025-02-24T18:39:23Z\";}}}", "auto");
INSERT INTO `wp_options` VALUES("441", "woocommerce_onboarding_profile", "a:6:{s:15:\"business_choice\";s:18:\"im_already_selling\";s:8:\"industry\";a:1:{i:0;s:15:\"arts_and_crafts\";}s:18:\"is_agree_marketing\";b:0;s:11:\"store_email\";s:20:\"tabmehrnaz@gmail.com\";s:20:\"is_store_country_set\";b:1;s:9:\"completed\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("1123", "_transient_product-transient-version", "1758221955", "on");
INSERT INTO `wp_options` VALUES("446", "woocommerce_private_link", "no", "auto");
INSERT INTO `wp_options` VALUES("37500", "gtranslate_admin_notice", "a:2:{s:15:\"two_week_review\";a:2:{s:5:\"start\";s:8:\"6/7/2025\";s:3:\"int\";i:5;}s:12:\"upgrade_tips\";a:3:{s:5:\"start\";s:8:\"6/4/2025\";s:3:\"int\";i:2;s:9:\"dismissed\";i:1;}}", "auto");
INSERT INTO `wp_options` VALUES("39697", "_transient_ptk_patterns", "a:99:{i:0;a:18:{s:2:\"ID\";i:450;s:7:\"site_id\";i:231214916;s:5:\"title\";s:47:\"Intro: Heading with image and two columns above\";s:4:\"name\";s:51:\"intro-heading-with-image-and-two-columns-above-copy\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4005:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\",\"contentSize\":\"480px\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Stay dry in style</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\n<p>Designed for both fashion and function, our rain jackets offers sleek styles and waterproof protection to keep you dry in any downpour.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Discover collection</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":75,\"aspectRatio\":\"16/9\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/man-person-winter-photography-statue-coat.png\" alt=\"\" class=\"wp-image-75\" style=\"aspect-ratio:16/9;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:105:\"https://wooblockpatterns.wpcomstaging.com/2024/07/10/intro-heading-with-image-and-two-columns-above-copy/\";s:13:\"modified_date\";s:19:\"2025-05-06 14:29:32\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:1;a:18:{s:2:\"ID\";i:448;s:7:\"site_id\";i:231214916;s:5:\"title\";s:40:\"Intro: Two column with content and image\";s:4:\"name\";s:39:\"intro-two-column-with-content-and-image\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3509:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"className\":\"alignfull\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading has-xx-large-font-size\">Sounds like<br>no other</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Experience your music like never before with our latest generation of hi-fidelity headphones.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">اکنون خرید کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"id\":79,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/man-person-music-black-and-white-white-photography.jpg\" alt=\"\" class=\"wp-image-79\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:93:\"https://wooblockpatterns.wpcomstaging.com/2024/07/10/intro-two-column-with-content-and-image/\";s:13:\"modified_date\";s:19:\"2024-07-18 12:14:17\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:2;a:18:{s:2:\"ID\";i:410;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Review: Centered testimonial\";s:4:\"name\";s:27:\"review-centered-testimonial\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4632:\"<!-- wp:group {\"metadata\":{\"name\":\"Review\",\"categories\":[\"featured\",\"reviews\"],\"patternName\":\"review-centered-testimonial\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"20%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:20%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"center\",\"align\":\"wide\",\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-center has-large-font-size\">What people are saying</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">\"I recently attended a pottery workshop at this shop, and it was such a wonderful experience. The instructor was patient and encouraging, and I had a blast getting creative with clay.”</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":107,\"width\":\"64px\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100px\"}}} -->\n<figure class=\"wp-block-image size-full is-resized has-custom-border\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/portrait.png\" alt=\"\" class=\"wp-image-107\" style=\"border-radius:100px;aspect-ratio:1;object-fit:cover;width:64px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-text-align-center has-medium-font-size\">Liz S.</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-center has-small-font-size\">Painter</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:20%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:24:\"_dotcom_imported_reviews\";a:3:{s:4:\"slug\";s:24:\"_dotcom_imported_reviews\";s:5:\"title\";s:24:\"_dotcom_imported_reviews\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/07/04/review-centered-testimonial/\";s:13:\"modified_date\";s:19:\"2024-07-04 12:03:45\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:3;a:18:{s:2:\"ID\";i:404;s:7:\"site_id\";i:231214916;s:5:\"title\";s:37:\"Review: A quote with scattered images\";s:4:\"name\";s:36:\"review-a-quote-with-scattered-images\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4579:\"<!-- wp:group {\"metadata\":{\"categories\":[\"reviews\"],\"patternName\":\"review-a-quote-with-scattered-images\",\"name\":\"Review: A quote with scattered images\"},\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"padding-right:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:spacer {\"height\":\"var:preset|spacing|40\"} -->\n<div style=\"height:var(--wp--preset--spacing--40)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":405,\"width\":\"200px\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"left\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"}},\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image alignleft size-full is-resized has-custom-border is-style-default\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/table-food-dessert-cake-circle-painting-23295-pxhere-2.png\" alt=\"\" class=\"wp-image-405\" style=\"border-style:none;border-width:0px;aspect-ratio:1;object-fit:cover;width:200px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":408,\"width\":\"95px\",\"height\":\"auto\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"right\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"}},\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image alignright size-full is-resized has-custom-border is-style-default\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/formation-cave-food-autumn-darkness-still-life-790116-pxhere-2.png\" alt=\"\" class=\"wp-image-408\" style=\"border-style:none;border-width:0px;aspect-ratio:1;object-fit:cover;width:95px;height:auto\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"blockGap\":\"var:preset|spacing|20\",\"padding\":{\"right\":\"var:preset|spacing|20\",\"left\":\"var:preset|spacing|20\",\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}},\"dimensions\":{\"minHeight\":\"\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--20)\"><!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":107,\"width\":\"62px\",\"height\":\"62px\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"center\",\"className\":\"is-style-rounded\"} -->\n<figure class=\"wp-block-image aligncenter size-full is-resized is-style-rounded\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/portrait.png\" alt=\"\" class=\"wp-image-107\" style=\"object-fit:cover;width:62px;height:62px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"wp-block-heading has-text-align-center\">\"The only limit is the extent of your imagination.\"</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Jayla H.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:image {\"id\":406,\"width\":\"200px\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"right\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"}},\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image alignright size-full is-resized has-custom-border is-style-default\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/plant-fruit-dish-meal-food-cooking-88153-pxhere-2.png\" alt=\"\" class=\"wp-image-406\" style=\"border-style:none;border-width:0px;aspect-ratio:1;object-fit:cover;width:200px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":407,\"width\":\"112px\",\"height\":\"auto\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"left\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"}},\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image alignleft size-full is-resized has-custom-border is-style-default\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/tree-nature-branch-plant-fruit-flower-104610-pxhere.png\" alt=\"\" class=\"wp-image-407\" style=\"border-style:none;border-width:0px;aspect-ratio:1;object-fit:cover;width:112px;height:auto\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|40\"} -->\n<div style=\"height:var(--wp--preset--spacing--40)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:24:\"_dotcom_imported_reviews\";a:3:{s:4:\"slug\";s:24:\"_dotcom_imported_reviews\";s:5:\"title\";s:24:\"_dotcom_imported_reviews\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:90:\"https://wooblockpatterns.wpcomstaging.com/2024/07/04/review-a-quote-with-scattered-images/\";s:13:\"modified_date\";s:19:\"2024-07-04 12:00:48\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:4;a:18:{s:2:\"ID\";i:401;s:7:\"site_id\";i:231214916;s:5:\"title\";s:35:\"Review: Two column centered reviews\";s:4:\"name\";s:2:\"ff\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:7047:\"<!-- wp:group {\"metadata\":{\"name\":\"Reviews\",\"categories\":[\"featured\",\"reviews\"],\"patternName\":\"review-two-column-centered-reviews\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\",\"wideSize\":\"900px\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"align\":\"wide\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-center\">نقد و بررسی ها</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|10\",\"bottom\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\",\"right\":\"var:preset|spacing|10\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\"><!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"380px\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"12px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":107,\"width\":\"48px\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100px\"}}} -->\n<figure class=\"wp-block-image size-full is-resized has-custom-border\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/portrait.png\" alt=\"\" class=\"wp-image-107\" style=\"border-radius:100px;aspect-ratio:1;object-fit:cover;width:48px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"6px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"lineHeight\":\"1\"}},\"className\":\"is-testimonial-name\",\"fontSize\":\"small\"} -->\n<h3 class=\"wp-block-heading has-text-align-center is-testimonial-name has-small-font-size\" style=\"line-height:1\">Jayla H.</h3>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"0\"} -->\n<div style=\"height:0\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"is-testimonial-review\"} -->\n<p class=\"has-text-align-center is-testimonial-review\">\"I\'ve been a loyal customer for years, and for good reason. The customer service is top-notch, and the products are always reliable.\"</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|10\",\"bottom\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\",\"right\":\"var:preset|spacing|10\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\"><!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"380px\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"12px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":325,\"width\":\"48px\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100px\"}}} -->\n<figure class=\"wp-block-image size-full is-resized has-custom-border\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/cf19a5d21c3eeb7afa7c346b32af3ece-1.jpeg\" alt=\"\" class=\"wp-image-325\" style=\"border-radius:100px;aspect-ratio:1;object-fit:cover;width:48px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"6px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"style\":{\"typography\":{\"lineHeight\":\"1\"}},\"className\":\"is-testimonial-name\",\"fontSize\":\"small\"} -->\n<h4 class=\"wp-block-heading has-text-align-center is-testimonial-name has-small-font-size\" style=\"line-height:1\">Scott F.</h4>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"0\"} -->\n<div style=\"height:0\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"is-testimonial-review\"} -->\n<p class=\"has-text-align-center is-testimonial-review\">“I recently purchased a smart TV, and I couldn\'t be happier with my purchase. The staff was friendly and helpful, answering all of my questions.\"</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:24:\"_dotcom_imported_reviews\";a:3:{s:4:\"slug\";s:24:\"_dotcom_imported_reviews\";s:5:\"title\";s:24:\"_dotcom_imported_reviews\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:56:\"https://wooblockpatterns.wpcomstaging.com/2024/07/04/ff/\";s:13:\"modified_date\";s:19:\"2024-07-04 12:00:56\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:5;a:18:{s:2:\"ID\";i:397;s:7:\"site_id\";i:231214916;s:5:\"title\";s:26:\"Three column pricing table\";s:4:\"name\";s:28:\"three-column-pricing-table-2\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:15979:\"<!-- wp:group {\"metadata\":{\"name\":\"Pricing table\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"wp-block-heading has-text-align-center\">Elevate your learning</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\",\"width\":\"0px\"} -->\n<div style=\"height:var(--wp--preset--spacing--30);width:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"metadata\":{\"name\":\"Tiers\"},\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"metadata\":{\"name\":\"Tier Item\"},\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|50\"},\"blockGap\":\"var:preset|spacing|40\"},\"border\":{\"width\":\"1px\"}},\"borderColor\":\"primary\",\"backgroundColor\":\"base-2\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-column has-border-color has-primary-border-color has-base-2-background-color has-background\" style=\"border-width:1px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">رایگان (Free)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"className\":\"is-style-default\"} -->\n<h2 class=\"wp-block-heading is-style-default\">$0</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Video lectures</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Interactive quizzes</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Downloadable resources</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Certificates of completion</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"16px\"} -->\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-outline\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">مشترک شدن</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"metadata\":{\"name\":\"Tier Item (highlighted)\"},\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"},\"blockGap\":\"var:preset|spacing|40\"},\"border\":{\"width\":\"2px\"}},\"borderColor\":\"primary\",\"backgroundColor\":\"base-2\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-column has-border-color has-primary-border-color has-base-2-background-color has-background\" style=\"border-width:2px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">پایه</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"className\":\"is-style-default\"} -->\n<h2 class=\"wp-block-heading is-style-default\">$39</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Everything included in Free</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Personalized feedback</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Live Q&amp;A sessions</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Community forums</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"16px\"} -->\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-fill\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-fill\"><a class=\"wp-block-button__link wp-element-button\">مشترک شدن</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"metadata\":{\"name\":\"Tier Item\"},\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|50\"},\"blockGap\":\"var:preset|spacing|40\"},\"border\":{\"width\":\"1px\"}},\"borderColor\":\"primary\",\"backgroundColor\":\"base-2\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-column has-border-color has-primary-border-color has-base-2-background-color has-background\" style=\"border-width:1px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">ویژه (Premium)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"className\":\"is-style-default\"} -->\n<h2 class=\"wp-block-heading is-style-default\">$99</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\"><s><span></span></s>Everything included in Basic</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">پشتیبانی ویژه</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Coaching sessions</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Priority access to new content</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"16px\"} -->\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-outline\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">مشترک شدن</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:82:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/three-column-pricing-table-2/\";s:13:\"modified_date\";s:19:\"2024-07-05 10:59:28\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:6;a:18:{s:2:\"ID\";i:395;s:7:\"site_id\";i:231214916;s:5:\"title\";s:30:\"Two column boxed pricing table\";s:4:\"name\";s:30:\"two-column-boxed-pricing-table\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:7683:\"<!-- wp:group {\"metadata\":{\"name\":\"Pricing Table\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"textColor\":\"ast-global-color-2\",\"className\":\"is-pricing-title\"} -->\n<h2 class=\"wp-block-heading has-text-align-center is-pricing-title has-ast-global-color-2-color has-text-color\">قیمت گذاری</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"is-pricing-description\"} -->\n<p class=\"has-text-align-center is-pricing-description\">Whether you\'re a self-paced learner looking for flexibility or someone who thrives with additional support and guidance, we have a plan for you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\",\"contentSize\":\"800px\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"color\":{\"background\":\"#00000012\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#00000012;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading is-pricing-tier-name has-large-font-size\">رایگان (Free)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-price\",\"fontSize\":\"small\"} -->\n<p class=\"is-pricing-tier-price has-small-font-size\">$0.00/month</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-fill\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-fill\"><a class=\"wp-block-button__link wp-element-button\">شروع کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Video lectures</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Interactive quizzes</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Downloadable resources</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Downloadable resources</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"color\":{\"background\":\"#00000012\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#00000012;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:group {\"metadata\":{\"name\":\"Pricing Title\"},\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading is-pricing-tier-name has-large-font-size\">پایه</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-price\",\"fontSize\":\"small\"} -->\n<p class=\"is-pricing-tier-price has-small-font-size\">$69.00</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-fill\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-fill\"><a class=\"wp-block-button__link wp-element-button\">شروع کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Everything included in Free</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Personalized feedback</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Live Q&amp;A sessions</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Online community forums</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:84:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/two-column-boxed-pricing-table/\";s:13:\"modified_date\";s:19:\"2024-07-02 11:49:48\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:7;a:18:{s:2:\"ID\";i:392;s:7:\"site_id\";i:231214916;s:5:\"title\";s:24:\"Two column pricing table\";s:4:\"name\";s:24:\"two-column-pricing-table\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:7040:\"<!-- wp:group {\"metadata\":{\"name\":\"Pricing\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\",\"contentSize\":\"960px\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading {\"textAlign\":\"center\",\"align\":\"wide\",\"className\":\"is-pricing-title\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-center is-pricing-title\">قیمت گذاری</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|40\",\"left\":\"0\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|10\",\"bottom\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\",\"right\":\"var:preset|spacing|10\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\"><!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"380px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-text-align-center is-pricing-tier-name has-medium-font-size\">پایه</h3>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"className\":\"is-pricing-tier-price\",\"fontSize\":\"xx-large\"} -->\n<h4 class=\"wp-block-heading has-text-align-center is-pricing-tier-price has-xx-large-font-size\">$99</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"is-pricing-tier-service\"} -->\n<p class=\"has-text-align-center is-pricing-tier-service\">It offers comprehensive access to all course materials, including video lectures, interactive quizzes, and downloadable resources.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":50} --><div class=\"wp-block-button has-custom-width wp-block-button__width-50\"><a class=\"wp-block-button__link wp-element-button\">شروع کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|10\",\"bottom\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\",\"right\":\"var:preset|spacing|10\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\"><!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"380px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-text-align-center is-pricing-tier-name has-medium-font-size\">ویژه (Premium)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"className\":\"is-pricing-tier-price\",\"fontSize\":\"xx-large\"} -->\n<h4 class=\"wp-block-heading has-text-align-center is-pricing-tier-price has-xx-large-font-size\">$199</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"is-pricing-tier-service\"} -->\n<p class=\"has-text-align-center is-pricing-tier-service\">Everything in the Basic plan plus exclusive perks and additional support. Enjoy live Q&amp;A, coaching sessions, and priority access to new content.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":50} --><div class=\"wp-block-button has-custom-width wp-block-button__width-50\"><a class=\"wp-block-button__link wp-element-button\">شروع کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":\"0px\"} -->\n<div style=\"height:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:78:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/two-column-pricing-table/\";s:13:\"modified_date\";s:19:\"2024-07-02 11:48:37\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:8;a:18:{s:2:\"ID\";i:384;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Two column service offerings\";s:4:\"name\";s:28:\"two-column-service-offerings\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4345:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|60\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading has-text-align-center has-large-font-size\">پایه</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">$99/month</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":250,\"aspectRatio\":\"4/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/0ad9cb5f991125c89fc952521795a1e6-1.jpeg\" alt=\"\" class=\"wp-image-250\" style=\"aspect-ratio:4/3;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading has-text-align-center has-large-font-size\">ویژه (Premium)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">$199/month</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":237,\"aspectRatio\":\"4/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/8d8416beec2ca80653d3b811bf6b1f77.jpeg\" alt=\"\" class=\"wp-image-237\" style=\"aspect-ratio:4/3;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:82:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/two-column-service-offerings/\";s:13:\"modified_date\";s:19:\"2024-07-02 11:21:24\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:9;a:18:{s:2:\"ID\";i:382;s:7:\"site_id\";i:231214916;s:5:\"title\";s:43:\"Three columns of headings, images and links\";s:4:\"name\";s:42:\"three-columns-of-headings-images-and-links\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5801:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Furniture customization</h3>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4px\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"padding-bottom:4px\"><!-- wp:image {\"id\":63,\"aspectRatio\":\"3/2\",\"scale\":\"cover\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/table-wood-house-chair-floor-window-1-1024x683.jpg\" alt=\"\" class=\"wp-image-63\" style=\"aspect-ratio:3/2;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Create bespoke pieces that perfectly fit your space and style with our customization services. From fabric selection to dimensions, we\'ll bring your vision to life.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Get started</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Interior design</h3>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4px\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"padding-bottom:4px\"><!-- wp:image {\"id\":304,\"aspectRatio\":\"3/2\",\"scale\":\"cover\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/54f708281f82831c082a1cf9d7b7faa9-1-683x1024.jpeg\" alt=\"\" class=\"wp-image-304\" style=\"aspect-ratio:3/2;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Our expert designers will work with you to transform your space into a stylish and functional haven that reflects your personal taste and lifestyle.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Get started</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Delivery and assembly</h3>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4px\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"padding-bottom:4px\"><!-- wp:image {\"id\":354,\"aspectRatio\":\"3/2\",\"scale\":\"cover\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/ade23ce2024ccbbb42f7f7d6dfe5f2e0-1-684x1024.jpeg\" alt=\"\" class=\"wp-image-354\" style=\"aspect-ratio:3/2;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Enjoy hassle-free shopping with our delivery and assembly services. Let our team handle the heavy lifting and installation, so you can relax in your newly furnished home.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Get started</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:96:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/three-columns-of-headings-images-and-links/\";s:13:\"modified_date\";s:19:\"2024-07-04 13:40:28\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:10;a:18:{s:2:\"ID\";i:380;s:7:\"site_id\";i:231214916;s:5:\"title\";s:21:\"Grid of text features\";s:4:\"name\";s:21:\"grid-of-text-features\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5163:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Personal styling</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">Work one-on-one with our expert stylists to curate outfits that align with your unique taste, body type, and lifestyle.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Alterations and tailoring</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">Ensure the perfect fit. From hemming to resizing, our skilled tailors will tailor your garments<br>to perfection.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Wardrobe refresh</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">Revamp your wardrobe. Our stylists will help you declutter, organize, and update your closet with fresh new pieces.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Virtual Shopping</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">Can\'t make it to our store? Our virtual shopping assistance service allows you to shop from the comfort of your home.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:75:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/grid-of-text-features/\";s:13:\"modified_date\";s:19:\"2024-07-04 13:41:09\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:11;a:18:{s:2:\"ID\";i:378;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Headings left, content right\";s:4:\"name\";s:27:\"headings-left-content-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:6555:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Content\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|40\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">Installation</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Enjoy peace of mind with our professional installation and setup services. From home theater systems to smart home devices, we\'ll ensure everything is installed and configured correctly for optimal performance.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Discover more</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#4747471a\"}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"background-color:#4747471a;color:#4747471a\"/>\n<!-- /wp:separator -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">نگهداری</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Extend the lifespan of your electronics with our repair and maintenance services. Our skilled technicians will diagnose and fix any issues to keep your devices running smoothly.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Discover more</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#4747471a\"}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"background-color:#4747471a;color:#4747471a\"/>\n<!-- /wp:separator -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">Trade-in</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Upgrade to the latest technology while being environmentally conscious with our trade-in and recycling programs. Trade in your old devices for credit towards new purchases or recycle them responsibly with us.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Discover more</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#4747471a\"}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"background-color:#4747471a;color:#4747471a\"/>\n<!-- /wp:separator -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">پشتیبانی</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Get the most out of your electronics with our tech support and training services. Our experts will help troubleshoot any issues and provide guidance on using your devices effectively.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Discover more</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#4747471a\"}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"background-color:#4747471a;color:#4747471a\"/>\n<!-- /wp:separator --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/headings-left-content-right/\";s:13:\"modified_date\";s:19:\"2024-07-02 11:17:53\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:12;a:18:{s:2:\"ID\";i:376;s:7:\"site_id\";i:231214916;s:5:\"title\";s:30:\"Heading with six text sections\";s:4:\"name\";s:30:\"heading-with-six-text-sections\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:6959:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"className\":\"alignfull\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"100%\"}},\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">خدمات ما</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}}} -->\n<div style=\"margin-top:0;margin-bottom:0;height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"0\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Furniture customization</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Create bespoke pieces that perfectly fit your space and style with our customization services. We\'ll bring your vision to life.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"56px\"} -->\n<div style=\"height:56px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Home staging</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Planning to sell your home? Our home staging service will help maximize its appeal to potential buyers, showcasing its full potential.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"56px\"} -->\n<div style=\"height:56px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Interior design consultation</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Our expert designers will work with you to transform your space into a stylish and functional haven that reflects your personal taste and lifestyle.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"0\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Furniture restoration</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Restore the beauty of your beloved furniture pieces. From refinishing to repairs, we\'ll breathe new life into your cherished items.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"56px\"} -->\n<div style=\"height:56px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Delivery and assembly</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Enjoy hassle-free shopping with our delivery and assembly services. Let our team handle the heavy lifting and installation, so you can relax.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"56px\"} -->\n<div style=\"height:56px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Virtual design consultation</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Can\'t make it to our showroom? No problem! Our virtual design consultation service allows you to get expert advice from the comfort of your home.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:84:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/heading-with-six-text-sections/\";s:13:\"modified_date\";s:19:\"2024-07-24 14:34:50\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:13;a:18:{s:2:\"ID\";i:371;s:7:\"site_id\";i:231214916;s:5:\"title\";s:32:\"Three column boxed pricing table\";s:4:\"name\";s:26:\"three-column-pricing-table\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:9494:\"<!-- wp:group {\"metadata\":{\"name\":\"Pricing Table\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"is-pricing-title\"} -->\n<h2 class=\"wp-block-heading has-text-align-center is-pricing-title\">قیمت گذاری</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\"} -->\n<div style=\"height:var(--wp--preset--spacing--30)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"color\":{\"background\":\"#00000012\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#00000012;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading is-pricing-tier-name has-large-font-size\">رایگان (Free)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-price\",\"fontSize\":\"small\"} -->\n<p class=\"is-pricing-tier-price has-small-font-size\">$0.00/month</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-outline\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">شروع کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Video lectures</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Interactive quizzes</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Downloadable resources</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Certificate of completion</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"color\":{\"background\":\"#00000012\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#00000012;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:group {\"metadata\":{\"name\":\"Pricing Title\"},\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading is-pricing-tier-name has-large-font-size\">پایه</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-price\",\"fontSize\":\"small\"} -->\n<p class=\"is-pricing-tier-price has-small-font-size\">$39.00/month</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-fill\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-fill\"><a class=\"wp-block-button__link wp-element-button\">شروع کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Everything included in Free</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Personalized feedback</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Live Q&amp;A sessions</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Online community forums</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"color\":{\"background\":\"#00000012\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#00000012;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading is-pricing-tier-name has-large-font-size\">ویژه (Premium)</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-price\",\"fontSize\":\"small\"} -->\n<p class=\"is-pricing-tier-price has-small-font-size\">$99.00/month</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-outline\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">شروع کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Everything included in Basic</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Premium support</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Coaching sessions</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Priority access to new content</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:80:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/three-column-pricing-table/\";s:13:\"modified_date\";s:19:\"2024-07-02 11:47:39\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:14;a:18:{s:2:\"ID\";i:359;s:7:\"site_id\";i:231214916;s:5:\"title\";s:23:\"Two columns with images\";s:4:\"name\";s:23:\"two-columns-with-images\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5263:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|60\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":368,\"aspectRatio\":\"4/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/56b4ef6554bcb138de65c66f1ec092b9-2.jpeg\" alt=\"\" class=\"wp-image-368\" style=\"aspect-ratio:4/3;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">Trade-in and recycling</h3>\n<!-- /wp:heading --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Upgrade to the latest technology while being environmentally conscious with our trade-in and recycling programs. Trade in your old devices for credit towards new purchases or recycle them responsibly.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-buttons\" style=\"margin-top:0;margin-bottom:0\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">شروع کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":222,\"aspectRatio\":\"4/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/772d1d20f57861f0aa71dccda165b03e.jpeg\" alt=\"\" class=\"wp-image-222\" style=\"aspect-ratio:4/3;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">Extended warranty</h3>\n<!-- /wp:heading --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Protect your investment with our extended warranty and protection plans. Get peace of mind knowing your electronics are covered against unexpected damage and defects.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-buttons\" style=\"margin-top:0;margin-bottom:0\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">شروع کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:77:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/two-columns-with-images/\";s:13:\"modified_date\";s:19:\"2024-07-04 13:21:17\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:15;a:18:{s:2:\"ID\";i:357;s:7:\"site_id\";i:231214916;s:5:\"title\";s:31:\"Heading with four text sections\";s:4:\"name\";s:31:\"heading-with-four-text-sections\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5532:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"className\":\"alignfull\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"100%\"}},\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">خدمات</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}}} -->\n<div style=\"margin-top:0;margin-bottom:0;height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"0\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Personal styling</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Work one-on-one with our expert stylists to curate outfits that align with your unique taste, body type, and lifestyle.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"56px\"} -->\n<div style=\"height:56px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Wardrobe refresh</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Revamp your wardrobe. Our stylists will help you declutter, organize, and update your closet with fresh new pieces.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"0\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Alterations and tailoring</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ensure the perfect fit. From hemming to resizing, our skilled tailors will tailor your garments to perfection.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"56px\"} -->\n<div style=\"height:56px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Virtual Shopping</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Can\'t make it to our store? Our virtual shopping assistance service allows you to shop from the comfort of your home.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:85:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/heading-with-four-text-sections/\";s:13:\"modified_date\";s:19:\"2024-07-24 14:35:12\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:16;a:18:{s:2:\"ID\";i:348;s:7:\"site_id\";i:231214916;s:5:\"title\";s:34:\"Personal bio with a contact button\";s:4:\"name\";s:34:\"personal-bio-with-a-contact-button\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3755:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":107,\"width\":\"175px\",\"height\":\"auto\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"center\",\"style\":{\"border\":{\"radius\":\"100em\"}}} -->\n<figure class=\"wp-block-image aligncenter size-full is-resized has-custom-border\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/portrait.png\" alt=\"\" class=\"wp-image-107\" style=\"border-radius:100em;aspect-ratio:1;object-fit:cover;width:175px;height:auto\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\",\"wideSize\":\"460px\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading {\"textAlign\":\"center\",\"textColor\":\"ast-global-color-2\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-ast-global-color-2-color has-text-color\">Marianne R.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">“My journey into fashion began with a passion for sustainability and a love for artisanal crafts. Since childhood, I’ve been captivated by the intricate handiwork of global artisans and the stories behind their creations.” </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"orientation\":\"horizontal\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">درباره من</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:88:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/personal-bio-with-a-contact-button/\";s:13:\"modified_date\";s:19:\"2024-07-01 18:33:10\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:17;a:18:{s:2:\"ID\";i:345;s:7:\"site_id\";i:231214916;s:5:\"title\";s:66:\"Circular avatar on left header on right with sub-header and button\";s:4:\"name\";s:66:\"circular-avatar-on-left-header-on-right-with-sub-header-and-button\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3632:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|50\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"id\":346,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100em\"}}} -->\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/8d605dc291be9f49e7e9afe9b8d0f5c7-1.png\" alt=\"\" class=\"wp-image-346\" style=\"border-radius:100em;aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"align\":\"wide\"} -->\n<h2 class=\"wp-block-heading alignwide\">Sustainable fashion</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We believe that fashion should be as kind to the planet as it is to your wardrobe. With a commitment to sustainability and environmental responsibility, we curate a collection of chic and eco-friendly clothing.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">در تماس باشید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:120:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/circular-avatar-on-left-header-on-right-with-sub-header-and-button/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:53:07\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:18;a:18:{s:2:\"ID\";i:343;s:7:\"site_id\";i:231214916;s:5:\"title\";s:57:\"Circular image on right with large border header on right\";s:4:\"name\";s:57:\"circular-image-on-right-with-large-border-header-on-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3574:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|50\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"fontSize\":\"small\"} -->\n<h2 class=\"wp-block-heading has-small-font-size\">درباره ما</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"align\":\"wide\"} -->\n<h2 class=\"wp-block-heading alignwide\">Sustainable fashion</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We believe that fashion should be as kind to the planet as it is to your wardrobe. With a commitment to sustainability and environmental responsibility, we curate a collection of chic and eco-friendly clothing.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"id\":262,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100em\",\"width\":\"0px\",\"style\":\"none\"}}} -->\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/96bbcf9839d875a42e9aaaada8132a33.jpeg\" alt=\"\" class=\"wp-image-262\" style=\"border-style:none;border-width:0px;border-radius:100em;aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:111:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/circular-image-on-right-with-large-border-header-on-right/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:46:29\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:19;a:18:{s:2:\"ID\";i:341;s:7:\"site_id\";i:231214916;s:5:\"title\";s:33:\"Header with a paragraph and stats\";s:4:\"name\";s:33:\"header-with-a-paragraph-and-stats\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4325:\"<!-- wp:group {\"metadata\":{\"name\":\"Numbers\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"left\",\"align\":\"wide\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-left has-xx-large-font-size\">ایجادکردن هر چیزی</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\" style=\"padding-right:0;padding-left:0\"><!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"75%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:75%\"><!-- wp:paragraph {\"fontSize\":\"medium\"} -->\n<p class=\"has-medium-font-size\">Welcome to a world of limitless possibilities, where the journey is as exhilarating as the destination, and where every moment is an opportunity to make your mark on the canvas of existence.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\"} -->\n<div style=\"height:var(--wp--preset--spacing--30)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"fontSize\":\"x-large\"} -->\n<h3 class=\"wp-block-heading has-x-large-font-size\">14M</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Satisfied clients</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"fontSize\":\"x-large\"} -->\n<h3 class=\"wp-block-heading has-x-large-font-size\">Eco</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We are thinking about the planet</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"fontSize\":\"x-large\"} -->\n<h3 class=\"wp-block-heading has-x-large-font-size\">120</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>گزینه‌ها</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:87:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/header-with-a-paragraph-and-stats/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:49:56\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:20;a:18:{s:2:\"ID\";i:338;s:7:\"site_id\";i:231214916;s:5:\"title\";s:12:\"Team members\";s:4:\"name\";s:12:\"team-members\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:11352:\"<!-- wp:group {\"metadata\":{\"name\":\"Team\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"wp-block-heading has-text-align-center\">Our Team</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"metadata\":{\"name\":\"Team members\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":336,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/fab46ce87d847342cbe7410cdaa90732.jpeg\" alt=\"\" class=\"wp-image-336\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Emily Hayes</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Interior designer</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Emily brings over a decade of experience in interior design, specializing in creating unique and personalized spaces that reflect each client\'s personality and lifestyle.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":335,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/f53d7341f90e86c42ed293bb386b5db4.jpeg\" alt=\"\" class=\"wp-image-335\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Mark Johnson</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Furniture designer</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>With a keen eye for detail and craftsmanship, Mark designs furniture pieces that blend style with functionality, ensuring every piece enhances the beauty of any space.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":331,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/885b26a44a4ca21844c169eca79dcf8c.jpeg\" alt=\"\" class=\"wp-image-331\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Alex Parker</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Customer support specialist</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Alex is committed to ensuring our customers have a seamless experience, providing attentive support and assistance with any inquiries or concerns they may have.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"metadata\":{\"name\":\"Team members\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":330,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/44df767ec48f3788eb836df942c12ca5.jpeg\" alt=\"\" class=\"wp-image-330\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">David Carter</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Project manager</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>David oversees every project with precision and efficiency, ensuring that timelines are met and that every detail is executed flawlessly from concept to completion.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":332,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/b804be09af895837548af933fdea519f.jpeg\" alt=\"\" class=\"wp-image-332\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Sophia Lee</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Sales manager</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Sophia is dedicated to providing exceptional service to our customers, offering guidance to help them find the perfect furniture and décor pieces for their homes.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":339,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/05414bb38f179cc7c6969cbaf1b152e1-1.jpeg\" alt=\"\" class=\"wp-image-339\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Emma Reynolds</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Marketing coordinator</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Emma\'s creative flair and passion for design shine through in her work, as she curates captivating content and engaging campaigns to showcase our products and services.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:66:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/team-members/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:42:27\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:21;a:18:{s:2:\"ID\";i:334;s:7:\"site_id\";i:231214916;s:5:\"title\";s:8:\"Our team\";s:4:\"name\";s:8:\"our-team\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:10105:\"<!-- wp:group {\"metadata\":{\"name\":\"Team\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"textAlign\":\"left\"} -->\n<h2 class=\"wp-block-heading has-text-align-left\">Our Team</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":336,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/fab46ce87d847342cbe7410cdaa90732.jpeg\" alt=\"\" class=\"wp-image-336\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Emily Hayes</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Interior designer</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Emily brings over a decade of experience in interior design, specializing in creating unique and personalized spaces that reflect each client\'s personality and lifestyle. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:social-links {\"iconColor\":\"theme-4\",\"iconColorValue\":\"#242b2d\",\"size\":\"has-small-icon-size\",\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"x\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"linkedin\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":335,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/f53d7341f90e86c42ed293bb386b5db4.jpeg\" alt=\"\" class=\"wp-image-335\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Mark Johnson</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Furniture designer</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>With a keen eye for detail and craftsmanship, Mark designs furniture pieces that blend style with functionality, ensuring every piece enhances the beauty of any space.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:social-links {\"iconColor\":\"theme-4\",\"iconColorValue\":\"#242b2d\",\"size\":\"has-small-icon-size\",\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"x\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"linkedin\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":331,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/885b26a44a4ca21844c169eca79dcf8c.jpeg\" alt=\"\" class=\"wp-image-331\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Alex Parker</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Customer support specialist</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Alex is committed to ensuring our customers have a seamless experience, providing attentive support and assistance with any inquiries or concerns they may have.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:social-links {\"iconColor\":\"theme-4\",\"iconColorValue\":\"#242b2d\",\"size\":\"has-small-icon-size\",\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"x\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"linkedin\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":332,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/b804be09af895837548af933fdea519f.jpeg\" alt=\"\" class=\"wp-image-332\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Sophia Lee</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Sales manager</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Sophia is dedicated to providing exceptional service to our customers, offering guidance to help them find the perfect furniture and décor pieces for their homes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:social-links {\"iconColor\":\"theme-4\",\"iconColorValue\":\"#242b2d\",\"size\":\"has-small-icon-size\",\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"x\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"linkedin\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:62:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/our-team/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:43:04\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:22;a:18:{s:2:\"ID\";i:329;s:7:\"site_id\";i:231214916;s:5:\"title\";s:6:\"تیم\";s:4:\"name\";s:4:\"team\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4779:\"<!-- wp:group {\"metadata\":{\"name\":\"Team\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|20\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"textAlign\":\"left\"} -->\n<h2 class=\"wp-block-heading has-text-align-left\">Meet the passionate team behind our brand</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":332,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]},\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/b804be09af895837548af933fdea519f.jpeg\" alt=\"\" class=\"wp-image-332\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":331,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/885b26a44a4ca21844c169eca79dcf8c.jpeg\" alt=\"\" class=\"wp-image-331\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|20\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":330,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/44df767ec48f3788eb836df942c12ca5.jpeg\" alt=\"\" class=\"wp-image-330\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":325,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/cf19a5d21c3eeb7afa7c346b32af3ece-1.jpeg\" alt=\"\" class=\"wp-image-325\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:58:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/team/\";s:13:\"modified_date\";s:19:\"2024-07-01 16:45:42\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:23;a:18:{s:2:\"ID\";i:327;s:7:\"site_id\";i:231214916;s:5:\"title\";s:12:\"درباره\";s:4:\"name\";s:5:\"about\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:6587:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|50\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:image {\"id\":462,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/girls-in-the-hills-3.jpg\" alt=\"\" class=\"wp-image-462\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Embrace<br>sustainable fashion</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We believe that fashion should be as kind to the planet as it is to your wardrobe. With a commitment to sustainability and environmental responsibility, we curate a collection of chic and eco-friendly clothing.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"stretch\"} -->\n<div class=\"wp-block-column is-vertically-aligned-stretch\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"24px\"} -->\n<div style=\"height:24px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"isStackedOnMobile\":false,\"fontSize\":\"medium\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile has-medium-font-size\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"var:preset|spacing|20\",\"right\":\"var:preset|spacing|20\"},\"blockGap\":\"4px\"},\"border\":{\"left\":{\"color\":\"#1e1e1e40\",\"width\":\"1px\"},\"top\":[],\"right\":[],\"bottom\":[]}}} -->\n<div class=\"wp-block-column\" style=\"border-left-color:#1e1e1e40;border-left-width:1px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20)\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">100%</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Eco-friendly packaging</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"var:preset|spacing|20\",\"right\":\"var:preset|spacing|20\"},\"blockGap\":\"4px\"},\"border\":{\"left\":{\"color\":\"#1e1e1e40\",\"width\":\"1px\"},\"top\":[],\"right\":[],\"bottom\":[]}}} -->\n<div class=\"wp-block-column\" style=\"border-left-color:#1e1e1e40;border-left-width:1px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20)\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">75%</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Recycled materials</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"isStackedOnMobile\":false,\"fontSize\":\"medium\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile has-medium-font-size\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"var:preset|spacing|20\",\"right\":\"var:preset|spacing|20\"},\"blockGap\":\"4px\"},\"border\":{\"left\":{\"color\":\"#1e1e1e40\",\"width\":\"1px\"},\"top\":[],\"right\":[],\"bottom\":[]}}} -->\n<div class=\"wp-block-column\" style=\"border-left-color:#1e1e1e40;border-left-width:1px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20)\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">80%</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Less water usage</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"var:preset|spacing|20\",\"right\":\"var:preset|spacing|20\"},\"blockGap\":\"4px\"},\"border\":{\"left\":{\"color\":\"#1e1e1e40\",\"width\":\"1px\"},\"top\":[],\"right\":[],\"bottom\":[]}}} -->\n<div class=\"wp-block-column\" style=\"border-left-color:#1e1e1e40;border-left-width:1px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20)\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">100%</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Organic cotton</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"9px\"} -->\n<div style=\"height:9px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:59:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/about/\";s:13:\"modified_date\";s:19:\"2024-07-18 12:31:42\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:24;a:18:{s:2:\"ID\";i:322;s:7:\"site_id\";i:231214916;s:5:\"title\";s:29:\"About with heading and images\";s:4:\"name\";s:29:\"about-with-heading-and-images\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4808:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"align\":\"wide\"} -->\n<h2 class=\"wp-block-heading alignwide\">Chic and eco-friendly fashion, thoughtfully crafted with organic fabrics and recycled materials.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\"} -->\n<div style=\"height:var(--wp--preset--spacing--30)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|20\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\",\"verticalAlignment\":\"top\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:image {\"id\":323,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/f3b0161d47e4ada886ef5f69d0637ddd.jpeg\" alt=\"\" class=\"wp-image-323\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"0px\",\"style\":{\"layout\":{\"flexSize\":\"5vw\",\"selfStretch\":\"fixed\"}}} -->\n<div style=\"height:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":75,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/man-person-winter-photography-statue-coat.png\" alt=\"\" class=\"wp-image-75\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:image {\"id\":325,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/cf19a5d21c3eeb7afa7c346b32af3ece-1.jpeg\" alt=\"\" class=\"wp-image-325\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"0px\",\"style\":{\"layout\":{\"flexSize\":\"5vw\",\"selfStretch\":\"fixed\"}}} -->\n<div style=\"height:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":324,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/f554dfb297c4824916eb82ee70a3d942.jpeg\" alt=\"\" class=\"wp-image-324\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:83:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/about-with-heading-and-images/\";s:13:\"modified_date\";s:19:\"2024-07-01 16:38:19\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:25;a:18:{s:2:\"ID\";i:319;s:7:\"site_id\";i:231214916;s:5:\"title\";s:22:\"List with descriptions\";s:4:\"name\";s:4:\"data\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:10266:\"<!-- wp:group {\"metadata\":{\"name\":\"Data list\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Data entry\"},\"align\":\"wide\",\"style\":{\"border\":{\"top\":{\"color\":\"var:preset|color|theme-4\",\"width\":\"1px\"},\"right\":[],\"bottom\":[],\"left\":[]},\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\" style=\"border-top-color:var(--wp--preset--color--theme-4);border-top-width:1px;padding-right:0;padding-left:0\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-4\"}}}},\"textColor\":\"theme-4\"} -->\n<h2 class=\"wp-block-heading has-theme-4-color has-text-color has-link-color\">18 years</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">We have been in the market for 18 years and proved our customers our experience matters.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Data entry\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|20\",\"left\":\"var:preset|spacing|20\"}},\"border\":{\"top\":{\"width\":\"1px\"}}}} -->\n<div class=\"wp-block-group alignwide\" style=\"border-top-width:1px\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-4\"}}}},\"textColor\":\"theme-4\"} -->\n<h2 class=\"wp-block-heading has-theme-4-color has-text-color has-link-color\">54 countries</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">We are worldwide with market participation in more than 54 countries in 5 continents.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Data entry\"},\"align\":\"wide\",\"style\":{\"border\":{\"top\":{\"width\":\"1px\"}},\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\" style=\"border-top-width:1px;padding-right:0;padding-left:0\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-4\"}}}},\"textColor\":\"theme-4\"} -->\n<h2 class=\"wp-block-heading has-theme-4-color has-text-color has-link-color\">98K users</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">We have almost 100k active users with a high level of engagement and adoption.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Data entry\"},\"align\":\"wide\",\"style\":{\"border\":{\"top\":{\"width\":\"1px\"}}}} -->\n<div class=\"wp-block-group alignwide\" style=\"border-top-width:1px\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"color\":[],\"border\":{\"radius\":\"0px\"}}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"border-radius:0px\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"top\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-4\"}}}},\"textColor\":\"theme-4\"} -->\n<h2 class=\"wp-block-heading has-theme-4-color has-text-color has-link-color\">$12M revenue</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">We closed 2023 over $12M dollars in revenue which position us as leader in our industry</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:58:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/data/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:33:26\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:26;a:18:{s:2:\"ID\";i:317;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Tall content with image left\";s:4:\"name\";s:28:\"tall-content-with-image-left\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4051:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":273,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/44024b9b9c88dd50f5cf11f5c31311c5-1.jpeg\" alt=\"\" class=\"wp-image-273\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"},\"blockGap\":\"var:preset|spacing|30\"},\"dimensions\":{\"minHeight\":\"100%\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"verticalAlignment\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"min-height:100%;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-x-large-font-size\">Committed to a greener lifestyle</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"400px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph -->\n<p>Our passion is crafting mindful moments with locally sourced, organic, and sustainable products. We\'re more than a store; we\'re your path to a community-driven, eco-friendly lifestyle that embraces premium quality.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Meet us</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:82:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/tall-content-with-image-left/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:06:24\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:27;a:18:{s:2:\"ID\";i:315;s:7:\"site_id\";i:231214916;s:5:\"title\";s:24:\"Two column text sections\";s:4:\"name\";s:24:\"two-column-text-sections\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3953:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|50\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Commitment to sustainability</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">Ethical sourcing is at the forefront of everything we do. We\'re proud to champion sustainable fashion by prioritizing the use of organic and recycled materials in our clothing and accessories. By supporting fair trade initiatives and maintaining transparent supply chains, we ensure that every piece upholds our commitment to ethical practices.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Quality and Craftsmanship</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">We are dedicated to crafting timeless pieces that stand the test of time. Each garment and accessory in our collection is a testament to our unwavering commitment to quality and craftsmanship. We take pride in using only the finest materials and employing meticulous attention to detail in every step of the creation process.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:78:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/two-column-text-sections/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:16:22\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:28;a:18:{s:2:\"ID\";i:313;s:7:\"site_id\";i:231214916;s:5:\"title\";s:36:\"Content with grid of images on right\";s:4:\"name\";s:36:\"content-with-grid-of-images-on-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5365:\"<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"25%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:25%\"><!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">Crafting beauty</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We are dedicated to the art of craftsmanship, where each vase is meticulously crafted to perfection. Our passion for detail and commitment to quality shines through in every piece, resulting in vases that are not just functional, but true works of art.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">More about us</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"16px\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"18px\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:image {\"lightbox\":{\"enabled\":true},\"id\":266,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-large is-style-default\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/a0c4b80dc701de6a1143de003da3ef95-1-768x1024.jpeg\" alt=\"\" class=\"wp-image-266\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"lightbox\":{\"enabled\":true},\"id\":88,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/white-vase-decoration-pattern-ceramic-lamp.jpg\" alt=\"\" class=\"wp-image-88\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"18px\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:image {\"lightbox\":{\"enabled\":true},\"id\":62,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/plant-white-leaf-flower-vase-green.jpg\" alt=\"\" class=\"wp-image-62\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"lightbox\":{\"enabled\":true},\"id\":69,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/tree-branch-plant-wood-leaf-flower.jpg\" alt=\"\" class=\"wp-image-69\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:90:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/content-with-grid-of-images-on-right/\";s:13:\"modified_date\";s:19:\"2024-07-18 12:15:00\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:29;a:18:{s:2:\"ID\";i:311;s:7:\"site_id\";i:231214916;s:5:\"title\";s:26:\"Pull left, fullwidth image\";s:4:\"name\";s:25:\"pull-left-fullwidth-image\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3473:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\n<p>We believe that your home should be a reflection of your unique style and personality. Our curated collection of home essentials and decor pieces is designed to help you create a space that feels truly like you. From cozy furnishings to stylish accents, we offer everything you need to turn your house into a home.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":63,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"full\"} -->\n<figure class=\"wp-block-image alignfull size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/table-wood-house-chair-floor-window-1.jpg\" alt=\"\" class=\"wp-image-63\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:79:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/pull-left-fullwidth-image/\";s:13:\"modified_date\";s:19:\"2024-07-01 16:24:14\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:30;a:18:{s:2:\"ID\";i:309;s:7:\"site_id\";i:231214916;s:5:\"title\";s:21:\"Right-aligned content\";s:4:\"name\";s:21:\"right-aligned-content\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3470:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"\"} -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>We are dedicated to crafting timeless pieces that stand the test of time. Each garment and accessory in our collection is a testament to our unwavering commitment to quality and craftsmanship. We take pride in using only the finest materials and employing meticulous attention to detail in every step of the creation process. From the stitching to the finishing touches, our products are thoughtfully designed to exude durability, longevity, and timeless elegance. When you shop with us, you can trust that you\'re investing in items that are not only stylish but also built to last, ensuring years of enjoyment and wear. We believe in fashion that not only looks good but also does good for the planet and its people. That\'s why we\'re dedicated to reducing the environmental and social impact of the clothing and accessories industry. When you shop with us, you can feel confident knowing that your purchase supports a more sustainable and ethical approach to fashion, making a positive difference in the world.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:75:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/right-aligned-content/\";s:13:\"modified_date\";s:19:\"2024-07-01 16:23:24\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:31;a:18:{s:2:\"ID\";i:306;s:7:\"site_id\";i:231214916;s:5:\"title\";s:35:\"Large heading with content on right\";s:4:\"name\";s:39:\"large-heading-with-content-on-the-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3463:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"50%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:50%\"><!-- wp:heading {\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading has-xx-large-font-size\">ایجادکردن هر چیزی</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"50%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:50%\"><!-- wp:paragraph -->\n<p>Welcome to a world of limitless possibilities, where the journey is as exhilarating as the destination, and where every moment is an opportunity to make your mark on the canvas of existence. The only limit is the extent of your imagination.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">شروع کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:93:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/large-heading-with-content-on-the-right/\";s:13:\"modified_date\";s:19:\"2024-07-01 16:22:38\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:32;a:18:{s:2:\"ID\";i:303;s:7:\"site_id\";i:231214916;s:5:\"title\";s:29:\"Tall content with image right\";s:4:\"name\";s:29:\"tall-content-with-image-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3981:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"},\"blockGap\":\"var:preset|spacing|30\"},\"dimensions\":{\"minHeight\":\"100%\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"verticalAlignment\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"min-height:100%;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:heading {\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-x-large-font-size\">Discover a world of possibilities</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"400px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph -->\n<p>We believe that your home should be a reflection of your unique style and personality. Our curated collection of home essentials and decor pieces is designed to help you create a space that feels truly like you. From cozy furnishings to stylish accents, we offer everything you need to turn your house into a home.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Meet us</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":304,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/54f708281f82831c082a1cf9d7b7faa9-1.jpeg\" alt=\"\" class=\"wp-image-304\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:83:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/tall-content-with-image-right/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:58:41\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:33;a:18:{s:2:\"ID\";i:301;s:7:\"site_id\";i:231214916;s:5:\"title\";s:24:\"Spread right, heavy text\";s:4:\"name\";s:23:\"spread-right-heavy-text\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3959:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:image {\"id\":69,\"aspectRatio\":\"2/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/tree-branch-plant-wood-leaf-flower.jpg\" alt=\"\" class=\"wp-image-69\" style=\"aspect-ratio:2/3;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:50%\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">درباره ما</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Step into a world of botanical beauty</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph -->\n<p>With a passion for all things leafy, we offer a diverse collection of plants, from lush foliage to exotic blooms, to bring the beauty of nature into your home. Whether you\'re a seasoned plant parent or just beginning your green journey, our friendly team is here to help you find the perfect plant companion.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">More about us</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:77:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/spread-right-heavy-text/\";s:13:\"modified_date\";s:19:\"2024-07-18 12:07:51\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:34;a:18:{s:2:\"ID\";i:299;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Heading with button and text\";s:4:\"name\";s:28:\"heading-with-button-and-text\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3808:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"textAlign\":\"left\",\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-left has-x-large-font-size\">Discover a world of possibilities</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">شروع کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:paragraph {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p>We believe that your home should be a reflection of your unique style and personality. Our curated collection of home essentials and decor pieces is designed to help you create a space that feels truly like you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p>Our expert designers will work closely with you to bring your vision to life. From furniture selection to color schemes, we\'ll provide professional advice and guidance every step of the way to help you achieve the perfect balance of comfort, functionality, and aesthetic appeal.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:82:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/heading-with-button-and-text/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:56:19\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:35;a:18:{s:2:\"ID\";i:297;s:7:\"site_id\";i:231214916;s:5:\"title\";s:20:\"Left-aligned content\";s:4:\"name\";s:22:\"left-aligned-content-2\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2881:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"\"} -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>As we navigate the intricate tapestry of existence, we are constantly presented with choices, each a potential pathway to something extraordinary. This is a world where creativity knows no bounds, where the curious mind finds solace, and where the fearless heart discovers uncharted territories. It is a place where the pursuit of knowledge, the embrace of change, and the willingness to take risks are not mere options but essential ingredients for a life well-lived.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Welcome to a world of limitless possibilities, where the journey is as exhilarating as the destination, and where every moment is an opportunity to make your mark on the canvas of existence. The only limit is the extent of your imagination.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:76:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/left-aligned-content-2/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:54:34\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:36;a:18:{s:2:\"ID\";i:294;s:7:\"site_id\";i:231214916;s:5:\"title\";s:35:\"Fullwidth image, content pull right\";s:4:\"name\";s:34:\"fullwidth-image-content-pull-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3046:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:image {\"id\":295,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"full\"} -->\n<figure class=\"wp-block-image alignfull size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/90731e071ce29177b55e394f139c6400.jpeg\" alt=\"\" class=\"wp-image-295\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|10\",\"bottom\":\"var:preset|spacing|10\"}}}} -->\n<div class=\"wp-block-columns alignwide\" style=\"padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\n<p>Welcome to your premier destination for premium headphones and audio accessories. Dive into our curated collection, where cutting-edge technology meets sleek design to deliver an unparalleled listening experience. From wireless wonders to noise-canceling marvels, we have the perfect pair to suit every lifestyle and preference.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:88:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/fullwidth-image-content-pull-right/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:53:49\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:37;a:18:{s:2:\"ID\";i:291;s:7:\"site_id\";i:231214916;s:5:\"title\";s:25:\"Content left, image right\";s:4:\"name\";s:24:\"content-left-image-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3398:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:50%\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\n<h4 class=\"wp-block-heading has-small-font-size\">درباره ما</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Elevate your space</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We specialize in curating exquisite home decor pieces that add an element of elegance to every space. With a keen eye for detail and a commitment to quality, we strive to bring sophistication and charm into your home.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">More about us</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:image {\"id\":292,\"width\":\"521px\",\"height\":\"auto\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/b7754a09d649f4fe4ae390a60df7b556.jpeg\" alt=\"\" class=\"wp-image-292\" style=\"object-fit:cover;width:521px;height:auto\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:78:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/content-left-image-right/\";s:13:\"modified_date\";s:19:\"2024-07-18 12:15:40\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:38;a:18:{s:2:\"ID\";i:289;s:7:\"site_id\";i:231214916;s:5:\"title\";s:27:\"Centered heading and button\";s:4:\"name\";s:27:\"centered-heading-and-button\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2676:\"<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-x-large-font-size\">Discover a world of possibilities</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">شروع کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/centered-heading-and-button/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:49:09\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:39;a:18:{s:2:\"ID\";i:287;s:7:\"site_id\";i:231214916;s:5:\"title\";s:42:\"Heading with content and large image below\";s:4:\"name\";s:42:\"heading-with-content-and-large-image-below\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4054:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|60\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"textAlign\":\"left\",\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-left has-x-large-font-size\">Embrace<br>sustainable fashion</h2>\n<!-- /wp:heading -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Discover more</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:paragraph {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p>We believe that fashion should be as kind to the planet as it is to your wardrobe. With a commitment to sustainability and environmental responsibility, we curate a collection of chic and eco-friendly clothing.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p>From organic fabrics to recycled materials, every piece in our collection is thoughtfully crafted with the planet in mind.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\"} -->\n<div style=\"height:var(--wp--preset--spacing--30)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":75,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"wide\"} -->\n<figure class=\"wp-block-image alignwide size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/man-person-winter-photography-statue-coat.png\" alt=\"\" class=\"wp-image-75\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:96:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/heading-with-content-and-large-image-below/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:48:30\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:40;a:18:{s:2:\"ID\";i:284;s:7:\"site_id\";i:231214916;s:5:\"title\";s:30:\"Heading with two media columns\";s:4:\"name\";s:30:\"heading-with-two-media-columns\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4356:\"<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"10px\"}}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\" style=\"margin-bottom:10px\"><!-- wp:image {\"id\":285,\"aspectRatio\":\"4/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/e7e21c3e64f977311b55a59d66aec660.jpeg\" alt=\"\" class=\"wp-image-285\" style=\"aspect-ratio:4/3;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading has-large-font-size\">Commitment to sustainability</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>At the heart of our mission is a commitment to sustainability. We prioritize environmentally friendly practices by sourcing locally grown produce, minimizing packaging waste, and championing sustainable farming methods.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"10px\"}}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\" style=\"margin-bottom:10px\"><!-- wp:image {\"id\":273,\"aspectRatio\":\"4/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/44024b9b9c88dd50f5cf11f5c31311c5-1.jpeg\" alt=\"\" class=\"wp-image-273\" style=\"aspect-ratio:4/3;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading has-large-font-size\">Quality and freshness</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Every step of our process, from meticulous ingredient selection to adhering to stringent standards, reflects our dedication to quality. From the initial harvest to the finished product, we uphold uncompromising standards of freshness and flavor.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:84:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/heading-with-two-media-columns/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:47:28\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:41;a:18:{s:2:\"ID\";i:282;s:7:\"site_id\";i:231214916;s:5:\"title\";s:27:\"Three columns with features\";s:4:\"name\";s:27:\"three-columns-with-features\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4409:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|50\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Commitment to sustainability</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">At the heart of our mission is a commitment to sustainability. We prioritize environmentally friendly practices by sourcing locally grown produce, minimizing packaging waste, and championing sustainable farming methods.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Quality and freshness</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">At our core, we\'re dedicated to delivering excellence. We take great care in selecting only the finest organic fruits and vegetables, adhering to stringent standards to guarantee optimal freshness and flavor.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Community engagement</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">From fostering partnerships with local farmers to active participation in community events, we\'re deeply committed to supporting initiatives focused on food security, nutrition, and overall well-being.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/three-columns-with-features/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:17:24\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:42;a:18:{s:2:\"ID\";i:279;s:7:\"site_id\";i:231214916;s:5:\"title\";s:36:\"Four image grid, content on the left\";s:4:\"name\";s:35:\"four-image-grid-content-on-the-left\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5194:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"className\":\"alignfull\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"8px\",\"left\":\"8px\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":266,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/a0c4b80dc701de6a1143de003da3ef95-1.jpeg\" alt=\"\" class=\"wp-image-266\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":88,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/white-vase-decoration-pattern-ceramic-lamp.jpg\" alt=\"\" class=\"wp-image-88\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":62,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/plant-white-leaf-flower-vase-green.jpg\" alt=\"\" class=\"wp-image-62\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":69,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/tree-branch-plant-wood-leaf-flower.jpg\" alt=\"\" class=\"wp-image-69\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\",\"contentSize\":\"400px\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Crafting beauty</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We are dedicated to the art of craftsmanship, where each vase is meticulously crafted to perfection. Our passion for detail and commitment to quality shines through in every piece, resulting in vases that are not just functional, but true works of art.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">More about us</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:89:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/four-image-grid-content-on-the-left/\";s:13:\"modified_date\";s:19:\"2024-07-18 12:07:14\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:43;a:18:{s:2:\"ID\";i:277;s:7:\"site_id\";i:231214916;s:5:\"title\";s:30:\"Heading left and content right\";s:4:\"name\";s:30:\"heading-left-and-content-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3543:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"45%\",\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|20\"}}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:heading {\"fontSize\":\"small\"} -->\n<h2 class=\"wp-block-heading has-small-font-size\">ایجادکردن هر چیزی</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Discover a world of possibilities</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"55%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:55%\"><!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p>We believe that your home should be a reflection of your unique style and personality. Our curated collection of home essentials and decor pieces is designed to help you create a space that feels truly like you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Our expert designers will work closely with you to bring your vision to life. From furniture selection to color schemes, we\'ll provide professional advice and guidance every step of the way to help you achieve the perfect balance of comfort, functionality, and aesthetic appeal.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:84:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/heading-left-and-content-right/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:41:54\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:44;a:18:{s:2:\"ID\";i:275;s:7:\"site_id\";i:231214916;s:5:\"title\";s:29:\"Content left with image right\";s:4:\"name\";s:29:\"content-left-with-image-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3420:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Where cycling dreams take flight</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Founded by avid cyclists with a passion for pedal-powered adventures, we\'re dedicated to providing top-quality bikes, accessories, and expert advice to riders of all levels.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Discover more</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-column is-vertically-aligned-bottom\"><!-- wp:image {\"lightbox\":{\"enabled\":false},\"id\":70,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/road-sport-vintage-wheel-retro-old.jpg\" alt=\"\" class=\"wp-image-70\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:83:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/content-left-with-image-right/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:40:59\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:45;a:18:{s:2:\"ID\";i:269;s:7:\"site_id\";i:231214916;s:5:\"title\";s:40:\"Heading with image and two columns below\";s:4:\"name\";s:40:\"heading-with-image-and-two-columns-below\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4877:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-columns\" style=\"margin-top:0;margin-bottom:0\"><!-- wp:column {\"width\":\"45%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:heading {\"align\":\"wide\"} -->\n<h2 class=\"wp-block-heading alignwide\">ایجادکردن هر چیزی</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":270,\"aspectRatio\":\"16/9\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/bc60cf21a37262b760535f0448a60acf-1.jpeg\" alt=\"\" class=\"wp-image-270\" style=\"aspect-ratio:16/9;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\",\"contentSize\":\"420px\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">Unleash your creativity at our pottery workshop</h3>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\n<p>Join us for an immersive pottery workshop where you can explore the art of shaping clay. Learn techniques from experienced artisans, unleash your creativity, and create your own unique pieces to take home. Perfect for all skill levels!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">رزور اتاق</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:94:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/heading-with-image-and-two-columns-below/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:35:10\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:46;a:18:{s:2:\"ID\";i:264;s:7:\"site_id\";i:231214916;s:5:\"title\";s:31:\"Heading with three images below\";s:4:\"name\";s:31:\"heading-with-three-images-below\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4705:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|60\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"align\":\"wide\"} -->\n<h2 class=\"wp-block-heading alignwide\">Beyond function: vases as works of art</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:33.33%\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p class=\"has-text-align-left\">We are dedicated to the art of craftsmanship, where each vase is meticulously crafted to perfection. Our passion for detail and commitment to quality shines through in every piece, resulting in vases that are not just functional, but true works of art.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|30\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"top\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:image {\"id\":266,\"aspectRatio\":\"2/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/a0c4b80dc701de6a1143de003da3ef95-1.jpeg\" alt=\"\" class=\"wp-image-266\" style=\"aspect-ratio:2/3;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":62,\"aspectRatio\":\"2/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/plant-white-leaf-flower-vase-green.jpg\" alt=\"\" class=\"wp-image-62\" style=\"aspect-ratio:2/3;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":69,\"aspectRatio\":\"2/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/tree-branch-plant-wood-leaf-flower.jpg\" alt=\"\" class=\"wp-image-69\" style=\"aspect-ratio:2/3;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:85:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/heading-with-three-images-below/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:26:33\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:47;a:18:{s:2:\"ID\";i:261;s:7:\"site_id\";i:231214916;s:5:\"title\";s:52:\"Full-width cover with heading, paragraph, and button\";s:4:\"name\";s:50:\"full-width-cover-with-heading-paragraph-and-button\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4060:\"<!-- wp:cover {\"url\":\"https://s0.wp.com/i/woo-block-patterns/2024/07/96bbcf9839d875a42e9aaaada8132a33.jpeg\",\"id\":262,\"dimRatio\":50,\"overlayColor\":\"theme-5\",\"isUserOverlayColor\":true,\"minHeight\":558,\"minHeightUnit\":\"px\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|40\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover alignfull\" style=\"padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);min-height:558px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-theme-5-background-color has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-262\" alt=\"\" src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/96bbcf9839d875a42e9aaaada8132a33.jpeg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"metadata\":{\"name\":\"Content\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\" style=\"margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"stretch\",\"width\":\"66.67%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-stretch\" style=\"flex-basis:66.67%\"><!-- wp:heading {\"textAlign\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"className\":\"text-balance\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-center text-balance has-xx-large-font-size\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Find your shade</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"300px\"} -->\n<div style=\"height:300px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Explore our exclusive collection of sunglasses, crafted to elevate your look and safeguard your eyes. Find your perfect pair and see the world through a new lens.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"left\",\"orientation\":\"horizontal\"},\"style\":{\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"theme-1\",\"textColor\":\"theme-5\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-5\"}}}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-theme-5-color has-theme-1-background-color has-text-color has-background has-link-color wp-element-button\">اکنون خرید کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-columns are-vertically-aligned-bottom\"><!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-column is-vertically-aligned-bottom\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-column is-vertically-aligned-bottom\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-column is-vertically-aligned-bottom\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:104:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/full-width-cover-with-heading-paragraph-and-button/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:23:05\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:48;a:18:{s:2:\"ID\";i:259;s:7:\"site_id\";i:231214916;s:5:\"title\";s:30:\"Left-aligned header and button\";s:4:\"name\";s:30:\"left-aligned-header-and-button\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2634:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Welcome to a world of limitless possibilities, where the journey is as exhilarating as the destination.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">بیشتر بدانید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:84:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/left-aligned-header-and-button/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:20:39\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:49;a:18:{s:2:\"ID\";i:254;s:7:\"site_id\";i:231214916;s:5:\"title\";s:20:\"Left-aligned content\";s:4:\"name\";s:20:\"left-aligned-content\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3813:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"className\":\"alignfull\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|30\"}}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"textAlign\":\"left\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-left has-xx-large-font-size\">A world of possibilities</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\",\"left\":\"0\"}}}} -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\",\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|30\"}}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p class=\"has-text-align-left\">Welcome to a world of limitless possibilities, where the journey is as exhilarating as the destination, and where every moment is an opportunity to make your mark on the canvas of existence.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">شروع کنید</a></div><!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} --><div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">اطلاعات بیشتر</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:74:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/left-aligned-content/\";s:13:\"modified_date\";s:19:\"2024-07-23 14:32:19\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:50;a:18:{s:2:\"ID\";i:252;s:7:\"site_id\";i:231214916;s:5:\"title\";s:32:\"Pull right with wide image below\";s:4:\"name\";s:32:\"pull-right-with-wide-image-below\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3905:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-x-large-font-size\">Ride into adventure</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Zoom through the streets on this premium 3-speed bike. Manufactured and assembled in Germany in the 80s.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">اکنون خرید کنید</a></div><!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} --><div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Discover collection</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":70,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"wide\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image alignwide size-full is-style-default\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/road-sport-vintage-wheel-retro-old.jpg\" alt=\"\" class=\"wp-image-70\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:86:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/pull-right-with-wide-image-below/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:17:04\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:51;a:18:{s:2:\"ID\";i:249;s:7:\"site_id\";i:231214916;s:5:\"title\";s:39:\"Fullwidth image with content and button\";s:4:\"name\";s:39:\"fullwidth-image-with-content-and-button\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3735:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\",\"categories\":[\"intro\"],\"patternName\":\"a8c/intro-fullwidth-image-with-content-and-button-2\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:0;padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:cover {\"url\":\"https://s1.wp.com/i/woo-block-patterns/2024/07/0ad9cb5f991125c89fc952521795a1e6-1.jpeg\",\"id\":250,\"dimRatio\":0,\"customOverlayColor\":\"#FFF\",\"isUserOverlayColor\":true,\"minHeight\":550,\"minHeightUnit\":\"px\",\"isDark\":false,\"align\":\"full\"} -->\n<div class=\"wp-block-cover alignfull is-light\" style=\"min-height:550px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\" style=\"background-color:#FFF\"></span><img class=\"wp-block-cover__image-background wp-image-250\" alt=\"\" src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/0ad9cb5f991125c89fc952521795a1e6-1.jpeg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading {\"textAlign\":\"center\",\"textColor\":\"ast-global-color-2\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-ast-global-color-2-color has-text-color\">Vintage vinyl treasures</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Step back in time and groove to the melodies of vinyl records. Dive into our eclectic collection, where each record spins tales of nostalgia and magic.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"orientation\":\"horizontal\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Shop vinyl records</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:93:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/fullwidth-image-with-content-and-button/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:15:23\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:52;a:18:{s:2:\"ID\";i:247;s:7:\"site_id\";i:231214916;s:5:\"title\";s:26:\"Large left-aligned heading\";s:4:\"name\";s:26:\"large-left-aligned-heading\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2447:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\",\"categories\":[\"intro\"],\"patternName\":\"a8c/intro-left-aligned-header-and-button\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">A world filled with boundless opportunities and endless potential</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:80:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/large-left-aligned-heading/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:11:33\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:53;a:18:{s:2:\"ID\";i:244;s:7:\"site_id\";i:231214916;s:5:\"title\";s:37:\"Centered heading with two column text\";s:4:\"name\";s:37:\"centered-heading-with-two-column-text\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4455:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\",\"categories\":[\"intro\"],\"patternName\":\"a8c/centered-heading-with-two-column-text\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"15%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:15%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:heading {\"textAlign\":\"center\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-xx-large-font-size\">Welcome home</h2>\n<!-- /wp:heading -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textAlign\":\"center\"} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\">شروع کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"15%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:15%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>We believe that your home should be a reflection of your unique style and personality. Our curated collection of home essentials and decor pieces is designed to help you create a space that feels truly like you. From cozy furnishings to stylish accents, we offer everything you need to turn your house into a home.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Our expert designers will work closely with you to bring your vision to life. From furniture selection to color schemes, we\'ll provide professional advice and guidance every step of the way to help you achieve the perfect balance of comfort, functionality, and aesthetic appeal.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:91:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/centered-heading-with-two-column-text/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:08:38\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:54;a:18:{s:2:\"ID\";i:243;s:7:\"site_id\";i:231214916;s:5:\"title\";s:33:\"Two column with image and content\";s:4:\"name\";s:35:\"two-column-with-image-and-content-2\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3518:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"id\":69,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/tree-branch-plant-wood-leaf-flower.jpg\" alt=\"\" class=\"wp-image-69\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading has-xx-large-font-size\">Elevate your greenery</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Spruce up your plants with our delightful ceramic pots, lovingly crafted to bring joy to your indoor and outdoor spaces.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">اکنون خرید کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:89:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/two-column-with-image-and-content-2/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:02:00\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:55;a:18:{s:2:\"ID\";i:242;s:7:\"site_id\";i:231214916;s:5:\"title\";s:16:\"Centered content\";s:4:\"name\";s:18:\"centered-content-2\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3583:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"20%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:20%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"textAlign\":\"center\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-xx-large-font-size\">Ride into adventure</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p class=\"has-text-align-center\">Welcome to your ultimate destination for high-quality bikes that fuel your passion for adventure. Whether you\'re a casual rider, a mountain biking enthusiast, or a road cycling pro, our diverse range of bikes promises to elevate your riding experience. Each bike is crafted with precision, combining cutting-edge technology and superior craftsmanship.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Explore our collection</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:20%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:72:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/centered-content-2/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:06:53\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:56;a:18:{s:2:\"ID\";i:241;s:7:\"site_id\";i:231214916;s:5:\"title\";s:39:\"Content with button and fullwidth image\";s:4:\"name\";s:41:\"content-with-button-and-fullwidth-image-3\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3560:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"0\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:0;padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading {\"textAlign\":\"center\",\"textColor\":\"ast-global-color-2\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-ast-global-color-2-color has-text-color\">Sit back and relax</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">With a wide range of designer chairs to elevate your living space.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"orientation\":\"horizontal\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">اکنون خرید کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:cover {\"url\":\"https://s1.wp.com/i/woo-block-patterns/2024/06/fa0e410e907dc5ba65806d0a9e45c89c.jpeg\",\"id\":231,\"dimRatio\":0,\"customOverlayColor\":\"#FFF\",\"isUserOverlayColor\":true,\"minHeight\":550,\"minHeightUnit\":\"px\",\"isDark\":false,\"align\":\"full\"} -->\n<div class=\"wp-block-cover alignfull is-light\" style=\"min-height:550px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\" style=\"background-color:#FFF\"></span><img class=\"wp-block-cover__image-background wp-image-231\" alt=\"\" src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/fa0e410e907dc5ba65806d0a9e45c89c.jpeg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:95:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/content-with-button-and-fullwidth-image-3/\";s:13:\"modified_date\";s:19:\"2024-07-05 09:58:45\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:57;a:18:{s:2:\"ID\";i:239;s:7:\"site_id\";i:231214916;s:5:\"title\";s:41:\"Left-aligned content overlaid on an image\";s:4:\"name\";s:43:\"left-aligned-content-overlaid-on-an-image-2\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3506:\"<!-- wp:cover {\"url\":\"https://s1.wp.com/i/woo-block-patterns/2024/06/man-person-music-black-and-white-white-photography.jpg\",\"id\":79,\"dimRatio\":30,\"customOverlayColor\":\"#010101\",\"isUserOverlayColor\":true,\"focalPoint\":{\"x\":0.45,\"y\":0.19},\"contentPosition\":\"bottom left\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover has-custom-content-position is-position-bottom-left alignfull\" style=\"padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-30 has-background-dim\" style=\"background-color:#010101\"></span><img class=\"wp-block-cover__image-background wp-image-79\" alt=\"\" src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/man-person-music-black-and-white-white-photography.jpg\" style=\"object-position:45% 19%\" data-object-fit=\"cover\" data-object-position=\"45% 19%\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"metadata\":{\"name\":\"Content\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\" style=\"margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:spacer {\"height\":\"var:preset|spacing|80\"} -->\n<div style=\"height:var(--wp--preset--spacing--80)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|20\"}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"700px\",\"wideSize\":\"960px\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"left\",\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"#fefefe\"}}},\"color\":{\"text\":\"#fefefe\"}},\"className\":\"text-balance\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-left text-balance has-text-color has-link-color has-xx-large-font-size\" style=\"color:#fefefe;margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Sounds like no other</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"#fefefe\"}}},\"color\":{\"text\":\"#fefefe\"},\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|30\"}}}} -->\n<p class=\"has-text-align-left has-text-color has-link-color\" style=\"color:#fefefe;margin-bottom:var(--wp--preset--spacing--30)\">Experience your music like never before with our latest generation of hi-fidelity headphones.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"wide\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-buttons alignwide\"><!-- wp:button {\"backgroundColor\":\"theme-1\",\"textColor\":\"theme-5\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-5\"}}}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-theme-5-color has-theme-1-background-color has-text-color has-background has-link-color wp-element-button\">اکنون خرید کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:97:\"https://wooblockpatterns.wpcomstaging.com/2024/06/28/left-aligned-content-overlaid-on-an-image-2/\";s:13:\"modified_date\";s:19:\"2024-07-05 10:42:03\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:58;a:18:{s:2:\"ID\";i:235;s:7:\"site_id\";i:231214916;s:5:\"title\";s:43:\"Center-aligned content overlaid on an image\";s:4:\"name\";s:44:\"fullwidth-image-with-call-to-action-overlaid\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3467:\"<!-- wp:cover {\"url\":\"https://s0.wp.com/i/woo-block-patterns/2024/06/8d8416beec2ca80653d3b811bf6b1f77.jpeg\",\"id\":237,\"dimRatio\":20,\"customOverlayColor\":\"#010101\",\"isUserOverlayColor\":true,\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"#ffffff\"}}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover alignfull has-text-color has-link-color\" style=\"color:#ffffff;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-20 has-background-dim\" style=\"background-color:#010101\"></span><img class=\"wp-block-cover__image-background wp-image-237\" alt=\"\" src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/8d8416beec2ca80653d3b811bf6b1f77.jpeg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"metadata\":{\"name\":\"Content\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\" style=\"margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:spacer {\"height\":\"var:preset|spacing|70\"} -->\n<div style=\"height:var(--wp--preset--spacing--70)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"\",\"wideSize\":\"580px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"#fefefe\"}}},\"color\":{\"text\":\"#fefefe\"}},\"className\":\"text-balance\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-center text-balance has-text-color has-link-color has-xx-large-font-size\" style=\"color:#fefefe;margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Find your groove</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"#fefefe\"}}},\"color\":{\"text\":\"#fefefe\"}}} -->\n<p class=\"has-text-align-center has-text-color has-link-color\" style=\"color:#fefefe\">Embark on a musical adventure, where every chord is a step towards harmony. Discover guitars of all shapes, sizes, and melodies.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"},\"style\":{\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"theme-1\",\"textColor\":\"theme-5\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-5\"}}}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-theme-5-color has-theme-1-background-color has-text-color has-background has-link-color wp-element-button\">Discover collection</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|70\"} -->\n<div style=\"height:var(--wp--preset--spacing--70)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:98:\"https://wooblockpatterns.wpcomstaging.com/2024/06/28/fullwidth-image-with-call-to-action-overlaid/\";s:13:\"modified_date\";s:19:\"2024-07-05 09:24:31\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:59;a:18:{s:2:\"ID\";i:224;s:7:\"site_id\";i:231214916;s:5:\"title\";s:39:\"Fullwidth content with background image\";s:4:\"name\";s:39:\"fullwidth-content-with-background-image\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2606:\"<!-- wp:cover {\"url\":\"https://s0.wp.com/i/woo-block-patterns/2024/06/772d1d20f57861f0aa71dccda165b03e.jpeg\",\"id\":222,\"dimRatio\":0,\"overlayColor\":\"theme-5\",\"isUserOverlayColor\":true,\"minHeightUnit\":\"vh\",\"isDark\":false,\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"className\":\"alignfull\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|20\",\"left\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover alignfull is-light\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--40)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-theme-5-background-color has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-222\" alt=\"\" src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/772d1d20f57861f0aa71dccda165b03e.jpeg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer {\"height\":\"var:preset|spacing|50\"} -->\n<div style=\"height:var(--wp--preset--spacing--50)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Content\"},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"xx-large\"} -->\n<p class=\"has-text-align-center has-xx-large-font-size\">Craft your Story</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Welcome to the place where the journey of a thousand stories begins. Embrace the transformative power of writing, and let your voice echo through the pages of time. Join us, and turn your imagination into reality.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\",\"style\":{\"layout\":[]}} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Discover more</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|50\"} -->\n<div style=\"height:var(--wp--preset--spacing--50)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:cover -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:93:\"https://wooblockpatterns.wpcomstaging.com/2024/06/28/fullwidth-content-with-background-image/\";s:13:\"modified_date\";s:19:\"2024-07-24 11:18:13\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:60;a:18:{s:2:\"ID\";i:208;s:7:\"site_id\";i:231214916;s:5:\"title\";s:32:\"Small Discount Banner with Image\";s:4:\"name\";s:32:\"small-discount-banner-with-image\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2269:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/small-discount-banner-with-image\",\"name\":\"Small Discount Banner with Image\"},\"style\":{\"color\":{\"background\":\"#fcf8e1\"},\"spacing\":{\"padding\":{\"top\":\"20px\",\"right\":\"20px\",\"bottom\":\"20px\",\"left\":\"20px\"}}}} -->\n<div class=\"wp-block-columns has-background\" style=\"background-color:#fcf8e1;padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px\"><!-- wp:column {\"width\":\"45%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:group {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\"},\"padding\":{\"left\":\"25px\",\"top\":\"25px\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:0;padding-top:25px;padding-left:25px\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"lineHeight\":\"1\",\"fontSize\":\"30px\"}}} -->\n<p style=\"font-size:30px;font-style:normal;font-weight:300;line-height:1\"><em>Chairs</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"lineHeight\":\"0\",\"fontSize\":\"30px\"},\"color\":{\"text\":\"#74227b\"},\"elements\":{\"link\":{\"color\":{\"text\":\"#74227b\"}}}}} -->\n<p class=\"has-text-color has-link-color\" style=\"color:#74227b;font-size:30px;font-style:normal;font-weight:300;line-height:0\"><em>from</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#74227b\"},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"900\",\"fontSize\":\"52px\",\"lineHeight\":\"1.2\"},\"elements\":{\"link\":{\"color\":{\"text\":\"#74227b\"}}}}} -->\n<p class=\"has-text-color has-link-color\" style=\"color:#74227b;font-size:52px;font-style:normal;font-weight:900;line-height:1.2\"><a href=\"https://wooblockpatterns.wpcomstaging.com/shop/\">$149</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":117,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/table-floor-interior-atmosphere-living-room-furniture-square-lg.png\" alt=\"\" class=\"wp-image-117\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:86:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/small-discount-banner-with-image/\";s:13:\"modified_date\";s:19:\"2024-11-06 17:35:31\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:61;a:18:{s:2:\"ID\";i:206;s:7:\"site_id\";i:231214916;s:5:\"title\";s:13:\"Shop by Price\";s:4:\"name\";s:13:\"shop-by-price\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:11109:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/shop-by-price\",\"name\":\"Shop by Price\"},\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"25%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"10px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;flex-basis:25%\"><!-- wp:cover {\"customOverlayColor\":\"#e09300\",\"isUserOverlayColor\":true,\"minHeight\":130,\"minHeightUnit\":\"px\",\"contentPosition\":\"top left\",\"isDark\":false,\"style\":{\"spacing\":{\"blockGap\":\"0em\",\"padding\":{\"top\":\"0.8em\"}}},\"className\":\"is-light has-background-color has-text-color\"} -->\n<div class=\"wp-block-cover is-light has-custom-content-position is-position-top-left has-background-color has-text-color\" style=\"padding-top:0.8em;min-height:130px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#e09300\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"left\",\"placeholder\":\"نوشتن عنوان…\",\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}}} -->\n<p class=\"has-text-align-left has-text-color has-link-color\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><a style=\"text-decoration:none\" href=\"/shop/?rating_filter=5\">Highest</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}},\"fontSize\":\"large\"} -->\n<p class=\"has-text-color has-link-color has-large-font-size\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><strong><a style=\"text-decoration:none\" href=\"/shop/?rating_filter=5\">rated</a></strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"contrast\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"},\"spacing\":{\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"is-style-outline\",\"fontSize\":\"small\"} --><div class=\"wp-block-button has-custom-font-size is-style-outline has-small-font-size\"><a class=\"wp-block-button__link has-contrast-color has-text-color wp-element-button\" href=\"/shop/?rating_filter=5\" style=\"border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><strong>Outdoor Furniture &amp; Accessories</strong></a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"25%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"10px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;flex-basis:25%\"><!-- wp:cover {\"customOverlayColor\":\"#6f64f1\",\"isUserOverlayColor\":true,\"minHeight\":130,\"minHeightUnit\":\"px\",\"contentPosition\":\"top left\",\"style\":{\"spacing\":{\"blockGap\":\"0.8em\",\"padding\":{\"top\":\"0.8em\"}}},\"className\":\"has-background-color has-text-color\"} -->\n<div class=\"wp-block-cover has-custom-content-position is-position-top-left has-background-color has-text-color\" style=\"padding-top:0.8em;min-height:130px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#6f64f1\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"left\",\"placeholder\":\"نوشتن عنوان…\",\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}}} -->\n<p class=\"has-text-align-left has-text-color has-link-color\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><a style=\"text-decoration:none\" href=\"/shop/?max_price=15\">Under</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}},\"fontSize\":\"large\"} -->\n<p class=\"has-text-color has-link-color has-large-font-size\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><strong><a style=\"text-decoration:none\" href=\"/shop/?max_price=15\">$15</a></strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"contrast\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"},\"spacing\":{\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"is-style-outline\",\"fontSize\":\"small\"} --><div class=\"wp-block-button has-custom-font-size is-style-outline has-small-font-size\"><a class=\"wp-block-button__link has-contrast-color has-text-color wp-element-button\" href=\"/shop/?max_price=15\" style=\"border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\">\n					<strong>Summer Dinning</strong>\n				</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"25%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"10px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;flex-basis:25%\"><!-- wp:cover {\"customOverlayColor\":\"#c1d21c\",\"isUserOverlayColor\":true,\"minHeight\":130,\"minHeightUnit\":\"px\",\"contentPosition\":\"top left\",\"style\":{\"spacing\":{\"blockGap\":\"0.8em\",\"padding\":{\"top\":\"0.8em\"}}},\"className\":\"has-background-color has-text-color\"} -->\n<div class=\"wp-block-cover has-custom-content-position is-position-top-left has-background-color has-text-color\" style=\"padding-top:0.8em;min-height:130px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#c1d21c\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"left\",\"placeholder\":\"نوشتن عنوان…\",\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}}} -->\n<p class=\"has-text-align-left has-text-color has-link-color\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><a style=\"text-decoration:none\" href=\"/shop/?max_price=25\">Under</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}},\"fontSize\":\"large\"} -->\n<p class=\"has-text-color has-link-color has-large-font-size\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><strong><a style=\"text-decoration:none\" href=\"/shop/?max_price=25\">$25</a></strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"contrast\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"},\"spacing\":{\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"is-style-outline\",\"fontSize\":\"small\"} --><div class=\"wp-block-button has-custom-font-size is-style-outline has-small-font-size\"><a class=\"wp-block-button__link has-contrast-color has-text-color wp-element-button\" href=\"/shop/?max_price=25\" style=\"border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\">\n					<strong>Women\'s Styles</strong>\n				</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"25%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"10px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;flex-basis:25%\"><!-- wp:cover {\"customOverlayColor\":\"#10ca99\",\"isUserOverlayColor\":true,\"minHeight\":130,\"minHeightUnit\":\"px\",\"contentPosition\":\"top left\",\"style\":{\"spacing\":{\"blockGap\":\"0.8em\",\"padding\":{\"top\":\"0.8em\"}}},\"className\":\"has-background-color has-text-color\"} -->\n<div class=\"wp-block-cover has-custom-content-position is-position-top-left has-background-color has-text-color\" style=\"padding-top:0.8em;min-height:130px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#10ca99\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"left\",\"placeholder\":\"نوشتن عنوان…\",\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}}} -->\n<p class=\"has-text-align-left has-text-color has-link-color\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><a style=\"text-decoration:none\" href=\"/shop/?max_price=20\">Under</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}},\"fontSize\":\"large\"} -->\n<p class=\"has-text-color has-link-color has-large-font-size\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><strong><a style=\"text-decoration:none\" href=\"/shop/?max_price=20\">$20</a></strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"contrast\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"},\"spacing\":{\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"is-style-outline\",\"fontSize\":\"small\"} --><div class=\"wp-block-button has-custom-font-size is-style-outline has-small-font-size\"><a class=\"wp-block-button__link has-contrast-color has-text-color wp-element-button\" href=\"/shop/?max_price=20\" style=\"border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\">\n					<strong>Kids\' Styles</strong>\n				</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:67:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/shop-by-price/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:41:33\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:62;a:18:{s:2:\"ID\";i:204;s:7:\"site_id\";i:231214916;s:5:\"title\";s:42:\"Product List with Full Product Description\";s:4:\"name\";s:42:\"product-list-with-full-product-description\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3393:\"<!-- wp:query {\"queryId\":18,\"query\":{\"perPage\":\"5\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\",\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-query-product-list-with-full-product-description\",\"name\":\"Product List with Full Product Description\"}} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"default\",\"columnCount\":2},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:columns {\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:woocommerce/product-image {\"saleBadgeAlign\":\"left\",\"isDescendentOfQueryLoop\":true} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"66.66%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:woocommerce/product-rating {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /-->\n\n<!-- wp:post-terms {\"term\":\"product_cat\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}}} /-->\n\n<!-- wp:post-title {\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"large\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n\n<!-- wp:post-excerpt {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"small\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-summary\"} /-->\n\n<!-- wp:woocommerce/product-sku {\"isDescendentOfQueryLoop\":true} /-->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:woocommerce/product-button {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n<!-- /wp:post-template -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"متن یا بلوک‌هایی را اضافه نمایید تا هنگامی که کوئری نتیجه‌ای نداشت نمایش داده شوند.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:96:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-list-with-full-product-description/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:35:59\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:63;a:18:{s:2:\"ID\";i:202;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Product List with 1:1 Images\";s:4:\"name\";s:27:\"product-list-with-11-images\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2518:\"<!-- wp:query {\"queryId\":16,\"query\":{\"perPage\":\"5\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\",\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-query-product-list-with-1-1-images\",\"name\":\"Product List with 1:1 Images\"}} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"default\",\"columnCount\":2},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:columns {\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:woocommerce/product-image {\"saleBadgeAlign\":\"left\",\"isDescendentOfQueryLoop\":true} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"66.66%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:woocommerce/product-rating {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /-->\n\n<!-- wp:post-title {\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"large\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n\n<!-- wp:post-excerpt {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"small\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-summary\"} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}}} /-->\n\n<!-- wp:woocommerce/product-button {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}}} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n<!-- /wp:post-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"متن یا بلوک‌هایی را اضافه نمایید تا هنگامی که کوئری نتیجه‌ای نداشت نمایش داده شوند.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-list-with-11-images/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:35:29\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:64;a:18:{s:2:\"ID\";i:200;s:7:\"site_id\";i:231214916;s:5:\"title\";s:20:\"Minimal Product List\";s:4:\"name\";s:20:\"minimal-product-list\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2144:\"<!-- wp:query {\"queryId\":14,\"query\":{\"perPage\":\"5\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\",\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-query-minimal-product-list\",\"name\":\"Minimal Product List\"}} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"default\",\"columnCount\":2},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:columns {\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"66.66%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:woocommerce/product-rating {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /-->\n\n<!-- wp:post-title {\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"large\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}}} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n<!-- /wp:post-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"متن یا بلوک‌هایی را اضافه نمایید تا هنگامی که کوئری نتیجه‌ای نداشت نمایش داده شوند.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:74:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/minimal-product-list/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:34:48\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:65;a:18:{s:2:\"ID\";i:198;s:7:\"site_id\";i:231214916;s:5:\"title\";s:20:\"4-Column Product Row\";s:4:\"name\";s:20:\"4-column-product-row\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2101:\"<!-- wp:query {\"queryId\":10,\"query\":{\"perPage\":\"4\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\",\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-query-4-column-product-row\",\"name\":\"4-Column Product Row\"},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"grid\",\"columnCount\":4},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true} /-->\n\n<!-- wp:post-title {\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"medium\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"verticalAlignment\":\"top\",\"justifyContent\":\"space-between\",\"orientation\":\"horizontal\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /-->\n\n<!-- wp:woocommerce/product-rating {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:woocommerce/product-button {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"متن یا بلوک‌هایی را اضافه نمایید تا هنگامی که کوئری نتیجه‌ای نداشت نمایش داده شوند.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:74:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/4-column-product-row/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:34:06\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:66;a:18:{s:2:\"ID\";i:192;s:7:\"site_id\";i:231214916;s:5:\"title\";s:44:\"Product Listing with Gallery and Description\";s:4:\"name\";s:44:\"product-listing-with-gallery-and-description\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:7252:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-listing-with-gallery-and-description\",\"name\":\"Product Listing with Gallery and Description\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":{\"top\":\"60px\",\"left\":\"60px\"}}}} -->\n<div class=\"wp-block-columns alignwide\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"blockGap\":{\"top\":\"1.5rem\",\"left\":\"1.5rem\"}}}} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile\" style=\"margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column {\"width\":\"15%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"var:preset|spacing|20\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\",\"wideSize\":\"80px\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:0;flex-basis:15%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"1rem\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"verticalAlignment\":\"center\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":193,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"color\":\"#dddddd\",\"width\":\"1px\",\"radius\":\"5px\"}},\"className\":\"is-resized\"} -->\n<figure class=\"wp-block-image size-full has-custom-border is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/desk-table-wood-chair-floor-home-square.png\" alt=\"\" class=\"has-border-color wp-image-193\" style=\"border-color:#dddddd;border-width:1px;border-radius:5px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":194,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"color\":\"#dddddd\",\"width\":\"1px\",\"radius\":\"5px\"}},\"className\":\"is-resized\"} -->\n<figure class=\"wp-block-image size-full has-custom-border is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/table-floor-interior-atmosphere-living-room-furniture-square-1.png\" alt=\"\" class=\"has-border-color wp-image-194\" style=\"border-color:#dddddd;border-width:1px;border-radius:5px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":195,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"color\":\"#dddddd\",\"width\":\"1px\",\"radius\":\"5px\"}},\"className\":\"is-resized\"} -->\n<figure class=\"wp-block-image size-full has-custom-border is-resized\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/table-floor-home-living-room-furniture-room-square.png\" alt=\"\" class=\"has-border-color wp-image-195\" style=\"border-color:#dddddd;border-width:1px;border-radius:5px\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"85%\",\"style\":{\"spacing\":{\"blockGap\":\"0\"}}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:85%\"><!-- wp:image {\"id\":196,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/table-wood-chair-floor-living-room-furniture-vertical.png\" alt=\"\" class=\"wp-image-196\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"style\":{\"typography\":{\"fontSize\":\"48px\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"textColor\":\"foreground\"} -->\n<h2 class=\"wp-block-heading has-foreground-color has-text-color\" style=\"font-size:48px;font-style:normal;font-weight:700\">Patterned Upright, Orange and White, Wood Legs</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"0px\",\"margin\":{\"top\":\"10px\",\"bottom\":\"0px\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:10px;margin-bottom:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:paragraph {\"textColor\":\"luminous-vivid-amber\"} -->\n<p class=\"has-luminous-vivid-amber-color has-text-color\">★★★★</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#ffe8a4\"},\"spacing\":{\"margin\":{\"right\":\"5px\"}}}} -->\n<p class=\"has-text-color\" style=\"color:#ffe8a4;margin-right:5px\">★</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\"}},\"textColor\":\"foreground\"} -->\n<p class=\"has-foreground-color has-text-color\" style=\"font-size:0.7em\">\n				<strong>4.2</strong>(1,079 reviews)\n			</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\",\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"margin\":{\"top\":\"2px\",\"bottom\":\"0px\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:2px;margin-bottom:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"1.2em\"}},\"textColor\":\"foreground\"} -->\n<p class=\"has-foreground-color has-text-color\" style=\"font-size:1.2em\">\n				<strong><sup><sub>$</sub></sup>37.49</strong>\n			</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\"},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null},\"color\":{\"text\":\"#7c0a99\"}}} -->\n<p class=\"has-text-color\" style=\"color:#7c0a99;font-size:0.7em\">Save $10 <s>was $47.49</s></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"18px\"}},\"textColor\":\"foreground\"} -->\n<p class=\"has-foreground-color has-text-color\" style=\"font-size:18px\">Designed with your well-being in mind, this chair features a contoured backrest that provides exceptional lumbar support, helping to reduce strain on your back during long hours of sitting. The adjustable height and tilt mechanisms allow you to customize the chair to your preferred sitting position, ensuring a comfortable and productive workday. Upholstered in premium fabric and available in a variety of colors, the Harmony Ergonomic Chair adds a touch of elegance to any room.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"spacing\":{\"padding\":{\"left\":\"80px\",\"right\":\"80px\"}},\"color\":{\"text\":\"#ffffff\",\"background\":\"#000000\"}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" style=\"color:#ffffff;background-color:#000000;padding-right:80px;padding-left:80px\">افزودن به سبد خرید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"16px\"}}} -->\n<p style=\"font-size:16px\">SKU 6355793</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:98:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-listing-with-gallery-and-description/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:33:29\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:67;a:18:{s:2:\"ID\";i:188;s:7:\"site_id\";i:231214916;s:5:\"title\";s:12:\"Product Hero\";s:4:\"name\";s:12:\"product-hero\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1616:\"\n<!-- wp:woocommerce/single-product {\"isPreview\":true,\"align\":\"wide\"} -->\n<div class=\"wp-block-woocommerce-single-product alignwide\">\n	<!-- wp:columns -->\n	<div class=\"wp-block-columns\">\n		<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n		<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;flex-basis:40%\">\n			<!-- wp:woocommerce/product-image {\"showSaleBadge\":false,\"isDescendentOfSingleProductBlock\":true,\"height\":\"300px\"} /-->\n		</div>\n		<!-- /wp:column -->\n\n		<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"60%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\",\"contentSize\":\"650px\"}} -->\n		<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:60%\">\n			<!-- wp:post-title {\"textAlign\":\"\",\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}},\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n\n			<!-- wp:woocommerce/product-price {\"isDescendentOfSingleProductBlock\":true} /-->\n\n			<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n			<div class=\"wp-block-group\">\n				<!-- wp:woocommerce/product-button {\"isDescendentOfSingleProductBlock\":true} /-->\n			</div>\n			<!-- /wp:group -->\n\n			<!-- wp:post-excerpt {\"__woocommerceNamespace\":\"woocommerce/product-query/product-summary\"} /-->\n		</div>\n		<!-- /wp:column -->\n	</div>\n	<!-- /wp:columns -->\n</div>\n<!-- /wp:woocommerce/single-product -->\n\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:66:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-hero/\";s:13:\"modified_date\";s:19:\"2025-02-14 15:20:35\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:68;a:18:{s:2:\"ID\";i:186;s:7:\"site_id\";i:231214916;s:5:\"title\";s:27:\"Featured Products 2 Columns\";s:4:\"name\";s:27:\"featured-products-2-columns\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2632:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/featured-products-2-cols\",\"name\":\"Featured Products 2 Columns\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:query {\"queryId\":8,\"query\":{\"perPage\":\"4\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"asc\",\"orderBy\":\"title\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceAttributes\":[],\"__woocommerceStockStatus\":[\"instock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\"} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"grid\",\"columnCount\":2},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"24px\",\"top\":\"0\"}}}} /-->\n\n<!-- wp:columns {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-columns are-vertically-aligned-bottom\"><!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-column is-vertically-aligned-bottom\"><!-- wp:post-title {\"textAlign\":\"left\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0rem\",\"top\":\"0\"}}},\"fontSize\":\"medium\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-column is-vertically-aligned-bottom\"><!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"textAlign\":\"right\",\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0rem\",\"top\":\"0\"}}}} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n<!-- /wp:post-template --></div>\n<!-- /wp:query --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\"><strong>Fan favorites</strong></h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Get ready to start the season right. All the fan favorites in one place at the best price.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":50} --><div class=\"wp-block-button has-custom-width wp-block-button__width-50\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\">خرید همه</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/featured-products-2-columns/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:30:24\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:69;a:18:{s:2:\"ID\";i:182;s:7:\"site_id\";i:231214916;s:5:\"title\";s:23:\"Product Details Pattern\";s:4:\"name\";s:23:\"product-details-pattern\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:8615:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-details-pattern\",\"name\":\"Product Details Pattern\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\",\"left\":\"0\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"40px\",\"bottom\":\"0\",\"left\":\"0px\"},\"blockGap\":\"0px\"}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:40px;padding-bottom:0;padding-left:0px\"><!-- wp:image {\"id\":183,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/table-floor-home-living-room-furniture-room.png\" alt=\"\" class=\"wp-image-183\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\",\"left\":\"0\"},\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"margin\":{\"top\":\"0.2em\",\"bottom\":\"0.2em\"}}}} -->\n<div class=\"wp-block-columns\" style=\"margin-top:0.2em;margin-bottom:0.2em;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"5px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"0\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0px;padding-right:5px;padding-bottom:0px;padding-left:0px\"><!-- wp:image {\"id\":184,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/table-white-chair-floor-shelf-lamp-square-lg.png\" alt=\"\" class=\"wp-image-184\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:image {\"id\":117,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/table-floor-interior-atmosphere-living-room-furniture-square-lg.png\" alt=\"\" class=\"wp-image-117\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"style\":{\"color\":{\"text\":\"#000000\"}},\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-color has-x-large-font-size\" style=\"color:#000000\">Luxurious Charcoal Grey Upholstered Sofa</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"0px\",\"margin\":{\"top\":\"10px\",\"bottom\":\"0px\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:10px;margin-bottom:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#fcb900\"}}} -->\n<p class=\"has-text-color\" style=\"color:#fcb900\">★★★★</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#ffe8a4\"},\"spacing\":{\"margin\":{\"right\":\"5px\"}}}} -->\n<p class=\"has-text-color\" style=\"color:#ffe8a4;margin-right:5px\">★</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\"},\"color\":{\"text\":\"#000000\"}}} -->\n<p class=\"has-text-color\" style=\"color:#000000;font-size:0.7em\">  <strong>4.2</strong>(1,079 reviews)</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\",\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"margin\":{\"top\":\"2px\",\"bottom\":\"0px\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:2px;margin-bottom:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"1.2em\"},\"color\":{\"text\":\"#000000\"}}} -->\n<p class=\"has-text-color\" style=\"color:#000000;font-size:1.2em\"><strong><sup><sub>$</sub></sup>158.99</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\"},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null},\"color\":{\"text\":\"#000000\"}}} -->\n<p class=\"has-text-color\" style=\"color:#000000;font-size:0.7em\"><s>was $173.99</s></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\"},\"color\":{\"text\":\"#C51313\"}}} -->\n<p class=\"has-text-color\" style=\"color:#C51313;font-size:0.7em\"><strong>9% off</strong></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\",\"margin\":{\"top\":\"5px\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:5px\"><!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#00A510\"},\"typography\":{\"fontSize\":\"0.7em\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"}}}} -->\n<p class=\"has-text-color\" style=\"color:#00A510;margin-top:0px;margin-right:0px;margin-bottom:0px;margin-left:0px;font-size:0.7em\"><strong>Free 2-Day Shipping</strong></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.8em\"},\"color\":{\"text\":\"#000000\"}}} -->\n<p class=\"has-text-color\" style=\"color:#000000;font-size:0.8em\">The \"Modern Elegance: Luxurious Charcoal Grey Upholstered Sofa\" harmonizes style and comfort to redefine your living space. This stunning piece is crafted with plush, high-density foam cushions, enveloped in a rich, charcoal grey fabric that is invitingly soft to the touch. Its clean lines and contemporary silhouette are complemented by the sturdy wooden frame, making it a durable yet stylish addition to any home decor. Whether you\'re lounging or entertaining, this sofa promises unrivaled comfort and a look that\'s seamlessly chic.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"color\":{\"text\":\"#ffffff\",\"background\":\"#000000\"}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" style=\"color:#ffffff;background-color:#000000\">افزودن به سبد خرید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.8em\"},\"color\":{\"text\":\"#000000\"}}} -->\n<p class=\"has-text-color\" style=\"color:#000000;font-size:0.8em\"><strong>Features</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"style\":{\"spacing\":{\"margin\":{\"top\":\"10px\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}},\"color\":{\"text\":\"#000000\"}},\"className\":\"has-foreground-color\"} -->\n<ul style=\"color:#000000;margin-top:10px;margin-right:0;margin-bottom:0;margin-left:0\" class=\"wp-block-list has-foreground-color has-text-color\"><!-- wp:list-item {\"style\":{\"typography\":{\"fontSize\":\"0.8em\"}}} -->\n<li style=\"font-size:0.8em\">Top shelf weight capacity of 100 lbs</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item {\"style\":{\"typography\":{\"fontSize\":\"0.8em\"}}} -->\n<li style=\"font-size:0.8em\">Drawer weight capacity of 50 lbs</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.8em\"},\"color\":{\"text\":\"#000000\"}}} -->\n<p class=\"has-text-color\" style=\"color:#000000;font-size:0.8em\"><strong>Weight and Dimensions</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:table {\"hasFixedLayout\":false,\"style\":{\"typography\":{\"fontSize\":\"0.7em\"},\"color\":{\"text\":\"#000000\"}},\"backgroundColor\":\"background\",\"className\":\"is-style-stripes\"} -->\n<figure class=\"wp-block-table is-style-stripes\" style=\"font-size:0.7em\"><table class=\"has-background-background-color has-text-color has-background\" style=\"color:#000000\"><tbody><tr><td>روی‌هم‌رفته</td><td>36.5\'\' H X 40\'\' W X 20\'\' D</td></tr><tr><td>Drawer Interior</td><td>2\'\' H X 29.25\'\' W X 12.5\'\' D</td></tr><tr><td>Countertop</td><td>40\'\' W X 20\'\' D</td></tr><tr><td>Countertop Thickness</td><td>0.7\'\' H</td></tr><tr><td>روی‌هم‌رفته Product Weight</td><td>39.6 lb.</td></tr></tbody></table></figure>\n<!-- /wp:table --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:77:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-details-pattern/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:29:31\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:70;a:18:{s:2:\"ID\";i:180;s:7:\"site_id\";i:231214916;s:5:\"title\";s:31:\"Product Details Product Listing\";s:4:\"name\";s:31:\"product-details-product-listing\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1582:\"\n<!-- wp:woocommerce/single-product {\"isPreview\":true} -->\n<div class=\"wp-block-woocommerce-single-product\">\n	<!-- wp:columns -->\n	<div class=\"wp-block-columns\">\n		<!-- wp:column -->\n		<div class=\"wp-block-column\">\n			<!-- wp:post-featured-image {\"height\":\"490px\"} /-->\n\n			<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n			<div class=\"wp-block-group\">\n				<!-- wp:woocommerce/product-rating-stars {\"isDescendentOfSingleProductBlock\":true,\"textColor\":\"luminous-vivid-amber\",\"style\":{\"spacing\":{\"margin\":{\"right\":\"5px\"}}}} /-->\n				<!-- wp:woocommerce/product-average-rating {\"style\":{\"typography\":{\"fontWeight\":\"600\",\"fontSize\":\"14px\"}}} /-->\n				<!-- wp:woocommerce/product-rating-counter {\"isDescendentOfSingleProductBlock\":true,\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"typography\":{\"fontSize\":\"14px\"}}} /-->\n			</div>\n			<!-- /wp:group -->\n\n			<!-- wp:post-title {\"textAlign\":\"center\",\"isLink\":true,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"x-large\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n			<!-- wp:woocommerce/product-price {\"textAlign\":\"center\",\"isDescendentOfSingleProductBlock\":true,\"style\":{\"typography\":{\"fontSize\":\"28px\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}}} /-->\n			<!-- wp:woocommerce/product-button {\"textAlign\":\"center\",\"isDescendentOfSingleProductBlock\":true} /-->\n		</div>\n		<!-- /wp:column -->\n	</div>\n	<!-- /wp:columns -->\n</div>\n<!-- /wp:woocommerce/single-product -->\n\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:85:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-details-product-listing/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:28:16\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:71;a:18:{s:2:\"ID\";i:178;s:7:\"site_id\";i:231214916;s:5:\"title\";s:35:\"Product Collections Newest Arrivals\";s:4:\"name\";s:35:\"product-collections-newest-arrivals\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2030:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collections-newest-arrivals\",\"name\":\"Product Collections Newest Arrivals\"},\"align\":\"wide\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">جدیدترین ورودی های ما</h3>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\">محصولات جدید بیشتر</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:query {\"queryId\":6,\"query\":{\"perPage\":\"4\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceAttributes\":[],\"__woocommerceStockStatus\":[\"instock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\"} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"className\":\"products-block-post-template\",\"layout\":{\"type\":\"grid\",\"columnCount\":4},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true} /-->\n\n<!-- wp:post-title {\"textAlign\":\"center\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"medium\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n<!-- /wp:post-template --></div>\n<!-- /wp:query --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:89:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collections-newest-arrivals/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:26:37\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:72;a:18:{s:2:\"ID\";i:172;s:7:\"site_id\";i:231214916;s:5:\"title\";s:40:\"Product Collections Featured Collections\";s:4:\"name\";s:40:\"product-collections-featured-collections\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4771:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collections-featured-collections\",\"name\":\"Product Collections Featured Collections\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":{\"top\":\"0\",\"left\":\"0\"}}}} -->\n<div class=\"wp-block-columns alignwide\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column {\"width\":\"50%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"30px\",\"right\":\"30px\",\"bottom\":\"30px\",\"left\":\"30px\"}},\"color\":{\"background\":\"#f3edd8\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#f3edd8;padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px;flex-basis:50%\"><!-- wp:heading {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"color\":{\"text\":\"#000000\"}},\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-color has-x-large-font-size\" style=\"color:#000000;font-style:normal;font-weight:700\">Tech gifts under $100</h2>\n<!-- /wp:heading -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"spacing\":{\"padding\":{\"left\":\"18px\",\"right\":\"18px\",\"top\":\"9px\",\"bottom\":\"9px\"}},\"typography\":{\"fontSize\":\"16px\"},\"color\":{\"background\":\"#000000\",\"text\":\"#ffffff\"}}} --><div class=\"wp-block-button has-custom-font-size\" style=\"font-size:16px\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\" style=\"color:#ffffff;background-color:#000000;padding-top:9px;padding-right:18px;padding-bottom:9px;padding-left:18px\">Shop tech</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":173,\"width\":\"140px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/technology-white-camera-photography-vintage-photographer.png\" alt=\"\" class=\"wp-image-173\" style=\"width:140px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":174,\"width\":\"140px\",\"height\":\"100px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/leather-guitar-typewriter-red-gadget-sofa.png\" alt=\"\" class=\"wp-image-174\" style=\"width:140px;height:100px\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"30px\",\"right\":\"30px\",\"bottom\":\"30px\",\"left\":\"30px\"}},\"color\":{\"background\":\"#d8f2f3\"}}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#d8f2f3;padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px;flex-basis:50%\"><!-- wp:heading {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"color\":{\"text\":\"#000000\"}},\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-color has-x-large-font-size\" style=\"color:#000000;font-style:normal;font-weight:700\">For the gamers</h2>\n<!-- /wp:heading -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"spacing\":{\"padding\":{\"left\":\"18px\",\"right\":\"18px\",\"top\":\"9px\",\"bottom\":\"9px\"}},\"typography\":{\"fontSize\":\"16px\"},\"color\":{\"background\":\"#000000\",\"text\":\"#ffffff\"}}} --><div class=\"wp-block-button has-custom-font-size\" style=\"font-size:16px\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\" style=\"color:#ffffff;background-color:#000000;padding-top:9px;padding-right:18px;padding-bottom:9px;padding-left:18px\">Shop games</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":175,\"width\":\"140px\",\"height\":\"100px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/music-technology-play-equipment-studio-gadget.png\" alt=\"\" class=\"wp-image-175\" style=\"width:140px;height:100px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":176,\"width\":\"140px\",\"height\":\"100px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/technology-joystick-gadget-console-games-playstation.png\" alt=\"\" class=\"wp-image-176\" style=\"width:140px;height:100px\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:94:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collections-featured-collections/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:25:38\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:73;a:18:{s:2:\"ID\";i:169;s:7:\"site_id\";i:231214916;s:5:\"title\";s:39:\"Product Collections Featured Collection\";s:4:\"name\";s:39:\"product-collections-featured-collection\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4254:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collections-featured-collection\",\"name\":\"Product Collections Featured Collection\"},\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#333333\"},\"spacing\":{\"padding\":{\"top\":\"1.3rem\",\"right\":\"1.3rem\",\"bottom\":\"1.3rem\",\"left\":\"1.3rem\"}}},\"textColor\":\"white\"} -->\n<div class=\"wp-block-columns alignwide has-white-color has-text-color has-background\" style=\"background-color:#333333;padding-top:1.3rem;padding-right:1.3rem;padding-bottom:1.3rem;padding-left:1.3rem\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"33.33%\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-right:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);flex-basis:33.33%\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"color\":{\"text\":\"#ffffff\"}},\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-text-color has-x-large-font-size\" style=\"color:#ffffff;font-style:normal;font-weight:700\">\n			This week\'s popular products		</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:query {\"queryId\":3,\"query\":{\"perPage\":\"3\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceAttributes\":[],\"__woocommerceStockStatus\":[\"instock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\"} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"grid\",\"columnCount\":3},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"0\"},\"color\":{\"background\":\"#484848\"},\"border\":{\"radius\":{\"topLeft\":\"0px\",\"topRight\":\"0px\",\"bottomLeft\":\"4px\",\"bottomRight\":\"4px\"}}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group has-background\" style=\"border-top-left-radius:0px;border-top-right-radius:0px;border-bottom-left-radius:4px;border-bottom-right-radius:4px;background-color:#484848;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:group {\"style\":{\"border\":{\"radius\":{\"topLeft\":\"4px\",\"topRight\":\"4px\"},\"color\":\"#ffffff\",\"style\":\"solid\",\"width\":\"3px\"},\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group has-border-color\" style=\"border-color:#ffffff;border-style:solid;border-width:3px;border-top-left-radius:4px;border-top-right-radius:4px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true,\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\",\"padding\":{\"top\":\"20px\",\"right\":\"20px\",\"left\":\"20px\",\"bottom\":\"10px\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"left\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-group has-link-color\" style=\"padding-top:20px;padding-right:20px;padding-bottom:10px;padding-left:20px\"><!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"fontFamily\":\"system-font\",\"style\":{\"typography\":{\"fontSize\":\"16px\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"color\":{\"text\":\"#ffffff\"}}} /-->\n\n<!-- wp:post-title {\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"fontSize\":\"16px\",\"textDecoration\":\"none\"},\"color\":{\"text\":\"#ffffff\"}},\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n<!-- /wp:post-template --></div>\n<!-- /wp:query --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:93:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collections-featured-collection/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:23:59\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:74;a:18:{s:2:\"ID\";i:167;s:7:\"site_id\";i:231214916;s:5:\"title\";s:30:\"Product Collection Simple Grid\";s:4:\"name\";s:30:\"product-collection-simple-grid\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1791:\"<!-- wp:woocommerce/product-collection {\"queryId\":22,\"query\":{\"perPage\":5,\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"asc\",\"orderBy\":\"title\",\"search\":\"\",\"exclude\":[],\"inherit\":false,\"taxQuery\":[],\"isProductCollectionBlock\":true,\"woocommerceOnSale\":false,\"woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"],\"woocommerceAttributes\":[],\"woocommerceHandPickedProducts\":[]},\"tagName\":\"div\",\"displayLayout\":{\"type\":\"flex\",\"columns\":5,\"shrinkColumns\":true},\"queryContextIncludes\":[\"collection\"],\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collection-simple-grid\",\"name\":\"Product Collection Simple Grid\"}} -->\n<div class=\"wp-block-woocommerce-product-collection\"><!-- wp:woocommerce/product-template -->\n<!-- wp:woocommerce/product-image {\"saleBadgeAlign\":\"left\",\"imageSizing\":\"thumbnail\",\"isDescendentOfQueryLoop\":true,\"style\":{\"typography\":{\"fontSize\":\"0.8rem\"}}} /-->\n\n<!-- wp:post-title {\"textAlign\":\"center\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}},\"typography\":{\"fontSize\":\"1rem\"}},\"__woocommerceNamespace\":\"woocommerce/product-collection/product-title\"} /-->\n<!-- /wp:woocommerce/product-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"orientation\":\"horizontal\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"متن یا بلوک‌هایی را اضافه نمایید تا هنگامی که کوئری نتیجه‌ای نداشت نمایش داده شوند.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:woocommerce/product-collection -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:84:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collection-simple-grid/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:23:15\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:75;a:18:{s:2:\"ID\";i:165;s:7:\"site_id\";i:231214916;s:5:\"title\";s:23:\"Product Collection Rows\";s:4:\"name\";s:23:\"product-collection-rows\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2590:\"<!-- wp:woocommerce/product-collection {\"queryId\":21,\"query\":{\"perPage\":9,\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"asc\",\"orderBy\":\"title\",\"search\":\"\",\"exclude\":[],\"inherit\":false,\"taxQuery\":[],\"isProductCollectionBlock\":true,\"woocommerceOnSale\":false,\"woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"],\"woocommerceAttributes\":[],\"woocommerceHandPickedProducts\":[]},\"tagName\":\"div\",\"displayLayout\":{\"type\":\"list\",\"columns\":3,\"shrinkColumns\":true},\"queryContextIncludes\":[\"collection\"],\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collection-rows\",\"name\":\"Product Collection Rows\"}} -->\n<div class=\"wp-block-woocommerce-product-collection\"><!-- wp:woocommerce/product-template -->\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:post-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"},\"padding\":{\"right\":\"0\",\"left\":\"0\",\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"large\",\"__woocommerceNamespace\":\"woocommerce/product-collection/product-title\"} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"medium\",\"style\":{\"typography\":{\"lineHeight\":\"1\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}}} /-->\n\n<!-- wp:woocommerce/product-rating {\"isDescendentOfQueryLoop\":true,\"textColor\":\"luminous-vivid-amber\",\"fontSize\":\"medium\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"bottom\":\"0px\"}}}} /-->\n\n<!-- wp:post-excerpt {\"showMoreOnNewLine\":false,\"excerptLength\":23,\"fontSize\":\"small\",\"__woocommerceNamespace\":\"woocommerce/product-collection/product-summary\"} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n<!-- /wp:woocommerce/product-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"متن یا بلوک‌هایی را اضافه نمایید تا هنگامی که کوئری نتیجه‌ای نداشت نمایش داده شوند.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:woocommerce/product-collection -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:77:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collection-rows/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:22:29\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:76;a:18:{s:2:\"ID\";i:163;s:7:\"site_id\";i:231214916;s:5:\"title\";s:23:\"Product Collection Grid\";s:4:\"name\";s:23:\"product-collection-grid\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1891:\"<!-- wp:woocommerce/product-collection {\"queryId\":20,\"query\":{\"perPage\":4,\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"asc\",\"orderBy\":\"title\",\"search\":\"\",\"exclude\":[],\"inherit\":false,\"taxQuery\":[],\"isProductCollectionBlock\":true,\"woocommerceOnSale\":false,\"woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"],\"woocommerceAttributes\":[],\"woocommerceHandPickedProducts\":[]},\"tagName\":\"div\",\"displayLayout\":{\"type\":\"flex\",\"columns\":4,\"shrinkColumns\":true},\"queryContextIncludes\":[\"collection\"],\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collection-grid\",\"name\":\"Product Collection Grid\"}} -->\n<div class=\"wp-block-woocommerce-product-collection\"><!-- wp:woocommerce/product-template -->\n<!-- wp:woocommerce/product-image {\"imageSizing\":\"thumbnail\",\"isDescendentOfQueryLoop\":true} /-->\n\n<!-- wp:post-title {\"textAlign\":\"left\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}},\"typography\":{\"lineHeight\":\"1\"}},\"fontSize\":\"small\",\"__woocommerceNamespace\":\"woocommerce/product-collection/product-title\"} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"textAlign\":\"left\",\"style\":{\"typography\":{\"fontSize\":\"0.8rem\",\"lineHeight\":\"1\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}}} /-->\n<!-- /wp:woocommerce/product-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"متن یا بلوک‌هایی را اضافه نمایید تا هنگامی که کوئری نتیجه‌ای نداشت نمایش داده شوند.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:woocommerce/product-collection -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:77:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collection-grid/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:21:55\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:77;a:18:{s:2:\"ID\";i:161;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Product Collection Full Grid\";s:4:\"name\";s:28:\"product-collection-full-grid\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2050:\"<!-- wp:woocommerce/product-collection {\"queryId\":19,\"query\":{\"perPage\":3,\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"asc\",\"orderBy\":\"title\",\"search\":\"\",\"exclude\":[],\"inherit\":false,\"taxQuery\":[],\"isProductCollectionBlock\":true,\"woocommerceOnSale\":false,\"woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"],\"woocommerceAttributes\":[],\"woocommerceHandPickedProducts\":[]},\"tagName\":\"div\",\"displayLayout\":{\"type\":\"flex\",\"columns\":3,\"shrinkColumns\":true},\"queryContextIncludes\":[\"collection\"],\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collection-full-grid\",\"name\":\"Product Collection Full Grid\"}} -->\n<div class=\"wp-block-woocommerce-product-collection\"><!-- wp:woocommerce/product-template -->\n<!-- wp:woocommerce/product-image {\"imageSizing\":\"thumbnail\",\"isDescendentOfQueryLoop\":true} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"textAlign\":\"left\",\"fontSize\":\"medium\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"lineHeight\":\"1\"}}} /-->\n\n<!-- wp:post-title {\"textAlign\":\"left\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}},\"typography\":{\"lineHeight\":\"1\"}},\"fontSize\":\"small\",\"__woocommerceNamespace\":\"woocommerce/product-collection/product-title\"} /-->\n\n<!-- wp:woocommerce/product-button {\"textAlign\":\"left\",\"width\":50,\"isDescendentOfQueryLoop\":true,\"style\":{\"typography\":{\"fontSize\":\"0.8rem\"}}} /-->\n<!-- /wp:woocommerce/product-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"متن یا بلوک‌هایی را اضافه نمایید تا هنگامی که کوئری نتیجه‌ای نداشت نمایش داده شوند.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:woocommerce/product-collection -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:82:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collection-full-grid/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:21:05\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:78;a:18:{s:2:\"ID\";i:158;s:7:\"site_id\";i:231214916;s:5:\"title\";s:25:\"Product Collection Banner\";s:4:\"name\";s:25:\"product-collection-banner\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3055:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collection-banner\",\"name\":\"Product Collection Banner\"},\"align\":\"wide\",\"layout\":{\"type\":\"constrained\",\"contentSize\":\"1000px\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#ffedf5\"}}} -->\n<div class=\"wp-block-columns alignwide has-background\" style=\"background-color:#ffedf5\"><!-- wp:column {\"width\":\"58%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:58%\"><!-- wp:cover {\"url\":\"https://s0.wp.com/i/woo-block-patterns/2024/06/beach-landscape-sea-coast-nature-person.jpg\",\"id\":159,\"dimRatio\":20,\"customOverlayColor\":\"#9aacbd\",\"minHeight\":430,\"minHeightUnit\":\"px\",\"isDark\":false,\"style\":{\"spacing\":{\"padding\":{\"top\":\"80px\",\"right\":\"80px\",\"bottom\":\"80px\",\"left\":\"80px\"}}}} -->\n<div class=\"wp-block-cover is-light\" style=\"padding-top:80px;padding-right:80px;padding-bottom:80px;padding-left:80px;min-height:430px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-20 has-background-dim\" style=\"background-color:#9aacbd\"></span><img class=\"wp-block-cover__image-background wp-image-159\" alt=\"\" src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/beach-landscape-sea-coast-nature-person.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"نوشتن عنوان…\",\"style\":{\"typography\":{\"fontSize\":\"40px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"lineHeight\":\"1.3\"},\"color\":{\"text\":\"#ffffff\"}},\"fontFamily\":\"inter\"} -->\n<p class=\"has-text-align-center has-text-color has-inter-font-family\" style=\"color:#ffffff;font-size:40px;font-style:normal;font-weight:700;line-height:1.3;text-transform:uppercase\">Brand New for the Holidays</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"22px\",\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"lineHeight\":\"1.3\"},\"color\":{\"text\":\"#000000\"}},\"fontFamily\":\"inter\"} -->\n<p class=\"has-text-color has-inter-font-family\" style=\"color:#000000;font-size:22px;font-style:normal;font-weight:300;line-height:1.3\">Check out our brand new collection of holiday products and find the right gift for anyone.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"color\":{\"background\":\"#ff7179\",\"text\":\"#000000\"},\"border\":{\"radius\":\"100px\",\"width\":\"0px\",\"style\":\"none\"}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\" style=\"border-style:none;border-width:0px;border-radius:100px;color:#000000;background-color:#ff7179\">اکنون خرید کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:79:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collection-banner/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:19:42\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:79;a:18:{s:2:\"ID\";i:153;s:7:\"site_id\";i:231214916;s:5:\"title\";s:14:\"Minimal Header\";s:4:\"name\";s:14:\"minimal-header\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1538:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/header-minimal\",\"name\":\"Minimal Header\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"40px\",\"bottom\":\"24px\",\"left\":\"40px\",\"top\":\"24px\"},\"margin\":{\"top\":\"0px\",\"bottom\":\"0px\"}}},\"className\":\"wc-blocks-pattern-header-minimal wc-blocks-header-pattern sticky-header\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-header-minimal wc-blocks-header-pattern sticky-header\" style=\"margin-top:0px;margin-bottom:0px;padding-top:24px;padding-right:40px;padding-bottom:24px;padding-left:40px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"20px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo {\"shouldSyncIcon\":false,\"className\":\"is-style-default\"} /-->\n\n<!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/mini-cart /-->\n\n<!-- wp:navigation {\"ref\":24,\"overlayMenu\":\"always\",\"metadata\":{\"ignoredHookedBlocks\":[\"woocommerce/customer-account\"]},\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} /-->\n\n<!-- wp:woocommerce/customer-account {\"displayStyle\":\"icon_only\",\"style\":{\"spacing\":{\"margin\":{\"left\":\"0.5em\"}}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:68:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/minimal-header/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:14:02\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:80;a:18:{s:2:\"ID\";i:151;s:7:\"site_id\";i:231214916;s:5:\"title\";s:17:\"Large Header Dark\";s:4:\"name\";s:17:\"large-header-dark\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2045:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/header-large-dark\",\"name\":\"Large Header Dark\"},\"align\":\"full\",\"style\":{\"spacing\":{\"blockGap\":\"0px\",\"padding\":{\"top\":\"1rem\",\"right\":\"1rem\",\"bottom\":\"1rem\",\"left\":\"1rem\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"wc-blocks-header-pattern has-background-color\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignfull wc-blocks-header-pattern has-background-color has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"padding-top:1rem;padding-right:1rem;padding-bottom:1rem;padding-left:1rem\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"1rem\"}},\"className\":\"has-small-font-size\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\"}} -->\n<div class=\"wp-block-group has-small-font-size\"><!-- wp:search {\"label\":\"Search\",\"showLabel\":false,\"placeholder\":\"Search\",\"width\":100,\"widthUnit\":\"%\",\"buttonText\":\"Search\",\"buttonUseIcon\":true,\"query\":{\"post_type\":\"product\"},\"style\":{\"border\":{\"radius\":\"0px\"}}} /-->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/customer-account {\"displayStyle\":\"icon_only\",\"iconClass\":\"wc-block-customer-account__account-icon\",\"fontSize\":\"small\"} /-->\n\n<!-- wp:woocommerce/mini-cart {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"16px\",\"padding\":{\"top\":\"1rem\",\"left\":\"0px\",\"bottom\":\"2rem\"}}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\" style=\"padding-top:1rem;padding-bottom:2rem;padding-left:0px\"><!-- wp:site-logo {\"shouldSyncIcon\":false} /-->\n\n<!-- wp:site-title /--></div>\n<!-- /wp:group -->\n\n<!-- wp:navigation {\"ref\":24,\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} /--></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:71:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/large-header-dark/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:13:31\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:81;a:18:{s:2:\"ID\";i:149;s:7:\"site_id\";i:231214916;s:5:\"title\";s:12:\"Large Header\";s:4:\"name\";s:12:\"large-header\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2444:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/header-large\",\"name\":\"Large Header\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"40px\",\"left\":\"40px\",\"top\":\"24px\",\"bottom\":\"24px\"}}},\"className\":\"wc-blocks-pattern-header-large wc-blocks-header-pattern\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-header-large wc-blocks-header-pattern\" style=\"padding-top:24px;padding-right:40px;padding-bottom:24px;padding-left:40px\"><!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignfull\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"isStackedOnMobile\":false,\"align\":\"full\"} -->\n<div class=\"wp-block-columns alignfull are-vertically-aligned-center is-not-stacked-on-mobile\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"70%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:70%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo {\"shouldSyncIcon\":false} /-->\n\n<!-- wp:site-title {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"200px\"}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/customer-account {\"displayStyle\":\"icon_only\",\"iconClass\":\"wc-block-customer-account__account-icon\"} /-->\n\n<!-- wp:woocommerce/mini-cart /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull\"><!-- wp:navigation {\"ref\":24} /-->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"padding-right:0;padding-left:0\"><!-- wp:search {\"label\":\"\",\"showLabel\":false,\"placeholder\":\"Search\",\"buttonText\":\"Search\",\"buttonUseIcon\":true,\"query\":{\"post_type\":\"product\"},\"style\":{\"border\":{\"radius\":\"0px\"}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:66:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/large-header/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:13:05\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:82;a:18:{s:2:\"ID\";i:147;s:7:\"site_id\";i:231214916;s:5:\"title\";s:21:\"Essential Header Dark\";s:4:\"name\";s:21:\"essential-header-dark\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1885:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/header-essential-dark\",\"name\":\"Essential Header Dark\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"2%\",\"bottom\":\"32px\",\"left\":\"2%\",\"top\":\"32px\"},\"margin\":{\"top\":\"0px\",\"bottom\":\"0px\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"wc-blocks-header-pattern sticky-header has-background-color\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull wc-blocks-header-pattern sticky-header has-background-color has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"margin-top:0px;margin-bottom:0px;padding-top:32px;padding-right:2%;padding-bottom:32px;padding-left:2%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"40px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo {\"shouldSyncIcon\":false} /-->\n\n<!-- wp:search {\"label\":\"Search\",\"showLabel\":false,\"placeholder\":\"Search\",\"width\":100,\"widthUnit\":\"%\",\"buttonText\":\"Search\",\"buttonUseIcon\":true,\"query\":{\"post_type\":\"product\"},\"style\":{\"border\":{\"radius\":\"0px\"}},\"backgroundColor\":\"contrast-2\"} /-->\n\n<!-- wp:navigation {\"ref\":24,\"textColor\":\"background\",\"overlayTextColor\":\"contrast\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"},\"layout\":{\"selfStretch\":\"fill\",\"flexSize\":null}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/customer-account {\"displayStyle\":\"icon_only\",\"iconStyle\":\"alt\",\"iconClass\":\"wc-block-customer-account__account-icon\"} /-->\n\n<!-- wp:woocommerce/mini-cart /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:75:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/essential-header-dark/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:12:34\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:83;a:18:{s:2:\"ID\";i:145;s:7:\"site_id\";i:231214916;s:5:\"title\";s:16:\"Essential Header\";s:4:\"name\";s:16:\"essential-header\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1298:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/header-essential\",\"name\":\"Essential Header\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"40px\",\"bottom\":\"40px\",\"left\":\"40px\",\"right\":\"40px\"}}},\"className\":\"wc-blocks-pattern-header-essential wc-blocks-header-pattern\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-header-essential wc-blocks-header-pattern\" style=\"padding-top:40px;padding-right:40px;padding-bottom:40px;padding-left:40px\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo /--></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"10px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/mini-cart /-->\n\n<!-- wp:woocommerce/customer-account {\"displayStyle\":\"icon_only\",\"iconClass\":\"wc-block-customer-account__account-icon\"} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:navigation {\"ref\":24,\"style\":{\"spacing\":{\"blockGap\":\"24px\"}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:70:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/essential-header/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:12:09\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:84;a:18:{s:2:\"ID\";i:143;s:7:\"site_id\";i:231214916;s:5:\"title\";s:20:\"Centered Header Menu\";s:4:\"name\";s:20:\"centered-header-menu\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2534:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/header-centered-menu\",\"name\":\"Centered Header Menu\"},\"align\":\"full\",\"className\":\"wc-blocks-pattern-header-centered-menu wc-blocks-header-pattern\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-header-centered-menu wc-blocks-header-pattern\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"isStackedOnMobile\":false,\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"24px\",\"bottom\":\"24px\",\"left\":\"40px\",\"right\":\"40px\"}}}} -->\n<div class=\"wp-block-columns alignfull are-vertically-aligned-center is-not-stacked-on-mobile\" style=\"padding-top:24px;padding-right:40px;padding-bottom:24px;padding-left:40px\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"70%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:70%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo {\"shouldSyncIcon\":false} /-->\n\n<!-- wp:site-title {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"200px\"},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/customer-account {\"displayStyle\":\"icon_only\",\"iconClass\":\"wc-block-customer-account__account-icon\"} /-->\n\n<!-- wp:woocommerce/mini-cart /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"align\":\"full\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"0px\"}}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignfull has-alpha-channel-opacity is-style-wide\" style=\"margin-top:0px;margin-bottom:0px\"/>\n<!-- /wp:separator -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:navigation {\"ref\":24,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\"},\"spacing\":{\"blockGap\":\"30px\"}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:separator {\"align\":\"full\",\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignfull has-alpha-channel-opacity is-style-wide\"/>\n<!-- /wp:separator --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:74:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/centered-header-menu/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:11:37\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:85;a:18:{s:2:\"ID\";i:141;s:7:\"site_id\";i:231214916;s:5:\"title\";s:17:\"Footer with menus\";s:4:\"name\";s:17:\"footer-with-menus\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2902:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-with-3-menus\",\"name\":\"Footer with menus\"},\"align\":\"full\",\"style\":{\"spacing\":{\"blockGap\":\"40px\",\"padding\":{\"top\":\"40px\",\"right\":\"40px\",\"bottom\":\"40px\",\"left\":\"40px\"}}},\"className\":\"wc-blocks-pattern-footer-with-3-menus wc-blocks-footer-pattern\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-footer-with-3-menus wc-blocks-footer-pattern\" style=\"padding-top:40px;padding-right:40px;padding-bottom:40px;padding-left:40px\"><!-- wp:columns {\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"className\":\"are-vertically-aligned-top\"} -->\n<div class=\"wp-block-columns are-vertically-aligned-top\" style=\"padding-right:0;padding-left:0\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"60%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:60%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"32px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"verticalAlignment\":\"top\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo /-->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|50\"}},\"layout\":{\"selfStretch\":\"fill\",\"flexSize\":null}}} -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:navigation {\"ref\":24,\"overlayMenu\":\"never\",\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"},\"style\":{\"spacing\":{\"blockGap\":\"10px\"}}} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"10%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:10%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"stretch\",\"width\":\"30%\",\"style\":{\"spacing\":{\"blockGap\":\"60px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-stretch\" style=\"flex-basis:30%\"><!-- wp:search {\"label\":\"Search\",\"showLabel\":false,\"placeholder\":\"Search\",\"width\":100,\"widthUnit\":\"%\",\"buttonText\":\"Search\",\"buttonUseIcon\":true,\"query\":{\"post_type\":\"product\"},\"style\":{\"border\":{\"radius\":\"0px\"}}} /-->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\",\"padding\":{\"right\":\"0\",\"left\":\"0\"},\"margin\":{\"top\":\"56px\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:56px;margin-bottom:0;padding-right:0;padding-left:0\"><!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}}} /-->\n\n<!-- wp:paragraph {\"align\":\"right\"} -->\n<p class=\"has-text-align-right\">\n					Powered by <a href=\"https://wordpress.org\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WordPress</a> with <a href=\"https://woocommerce.com\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>				</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:71:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/footer-with-menus/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:11:08\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:86;a:18:{s:2:\"ID\";i:139;s:7:\"site_id\";i:231214916;s:5:\"title\";s:24:\"Footer with 2 Menus Dark\";s:4:\"name\";s:24:\"footer-with-2-menus-dark\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3699:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-with-2-menus-dark\",\"name\":\"Footer with 2 Menus Dark\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"32px\",\"right\":\"4%\",\"bottom\":\"32px\",\"left\":\"4%\"},\"blockGap\":\"40px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"wc-blocks-footer-pattern has-background-color\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-footer-pattern has-background-color has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"padding-top:32px;padding-right:4%;padding-bottom:32px;padding-left:4%\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"32px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo {\"shouldSyncIcon\":false} /-->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:navigation {\"ref\":24} /-->\n\n<!-- wp:navigation {\"ref\":24} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group has-background-color has-text-color\"><!-- wp:paragraph {\"textColor\":\"background\",\"fontSize\":\"medium\"} -->\n<p class=\"has-background-color has-text-color has-medium-font-size\"><strong>Join our community</strong>\n				</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\">با محصولات جدید و تخفیف‌ها آشنا شوید!</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:social-links {\"iconColor\":\"background\",\"iconColorValue\":\"#ffffff\",\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-icon-color is-style-logos-only\"><!-- wp:social-link {\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"16px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull has-background-color has-text-color has-link-color\" style=\"padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"12px\"}}} -->\n<p style=\"font-size:12px\">@ 2022</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"fontSize\":\"12px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\"><em>\n			Built with <a href=\"https://woocommerce.com/\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</em></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:78:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/footer-with-2-menus-dark/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:10:37\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:87;a:18:{s:2:\"ID\";i:137;s:7:\"site_id\";i:231214916;s:5:\"title\";s:19:\"Footer with 2 Menus\";s:4:\"name\";s:19:\"footer-with-2-menus\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3042:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-with-2-menus\",\"name\":\"Footer with 2 Menus\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"32px\",\"right\":\"4%\",\"bottom\":\"32px\",\"left\":\"4%\"},\"blockGap\":\"40px\"}},\"className\":\"wc-blocks-footer-pattern\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-footer-pattern\" style=\"padding-top:32px;padding-right:4%;padding-bottom:32px;padding-left:4%\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"32px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo {\"shouldSyncIcon\":false} /-->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:navigation {\"ref\":24} /-->\n\n<!-- wp:navigation {\"ref\":24} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"fontSize\":\"medium\"} -->\n<p class=\"has-medium-font-size\"><strong>Join our community</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\">با محصولات جدید و تخفیف‌ها آشنا شوید!</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:social-links {\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links is-style-logos-only\"><!-- wp:social-link {\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"16px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"12px\"}}} -->\n<p style=\"font-size:12px\">@ 2022</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"fontSize\":\"12px\"}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\"><em>\n			Built with <a href=\"https://woocommerce.com/\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</em></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:73:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/footer-with-2-menus/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:10:01\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:88;a:18:{s:2:\"ID\";i:135;s:7:\"site_id\";i:231214916;s:5:\"title\";s:23:\"Footer with Simple Menu\";s:4:\"name\";s:23:\"footer-with-simple-menu\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2412:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-simple-menu\",\"name\":\"Footer with Simple Menu\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"40px\",\"bottom\":\"40px\",\"left\":\"40px\",\"right\":\"40px\"}}},\"className\":\"wc-blocks-pattern-footer-simple-menu wc-blocks-footer-pattern\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-footer-simple-menu wc-blocks-footer-pattern\" style=\"padding-top:40px;padding-right:40px;padding-bottom:40px;padding-left:40px\"><!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-right:0;padding-left:0\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"24px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:search {\"label\":\"Search\",\"showLabel\":false,\"placeholder\":\"Search\",\"width\":100,\"widthUnit\":\"%\",\"buttonText\":\"Search\",\"buttonUseIcon\":true,\"query\":{\"post_type\":\"product\"},\"style\":{\"border\":{\"radius\":\"0px\"}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:navigation {\"ref\":24,\"overlayMenu\":\"never\",\"layout\":{\"type\":\"flex\",\"orientation\":\"horizontal\",\"justifyContent\":\"left\",\"flexWrap\":\"wrap\"},\"style\":{\"spacing\":{\"blockGap\":\"24px\"}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:separator {\"align\":\"full\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\"}}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignfull has-alpha-channel-opacity is-style-wide\" style=\"margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40)\"/>\n<!-- /wp:separator -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"5px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-title /-->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">\n			Powered by <a href=\"https://wordpress.org\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WordPress</a> with <a href=\"https://woocommerce.com\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:77:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/footer-with-simple-menu/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:09:23\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:89;a:18:{s:2:\"ID\";i:133;s:7:\"site_id\";i:231214916;s:5:\"title\";s:18:\"Simple Footer Dark\";s:4:\"name\";s:18:\"simple-footer-dark\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2951:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-simple-dark\",\"name\":\"Simple Footer Dark\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"32px\",\"right\":\"48px\",\"bottom\":\"32px\",\"left\":\"48px\"},\"blockGap\":\"40px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"wc-blocks-footer-pattern has-background-color\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-footer-pattern has-background-color has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"padding-top:32px;padding-right:48px;padding-bottom:32px;padding-left:48px\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"32px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo /-->\n\n<!-- wp:woocommerce/customer-account {\"fontSize\":\"small\"} /-->\n\n<!-- wp:navigation {\"ref\":24} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:50%\"><!-- wp:social-links {\"iconColor\":\"background\",\"iconColorValue\":\"#ffffff\",\"className\":\"is-style-logos-only\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<ul class=\"wp-block-social-links has-icon-color is-style-logos-only\"><!-- wp:social-link {\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"12px\"}},\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull has-background-color has-text-color\" style=\"padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"12px\"}}} -->\n<p style=\"font-size:12px\">@ 2022</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"fontSize\":\"12px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\"><em>\n			Built with <a href=\"https://woocommerce.com/\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</em></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:72:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/simple-footer-dark/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:08:48\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:90;a:18:{s:2:\"ID\";i:131;s:7:\"site_id\";i:231214916;s:5:\"title\";s:13:\"Simple Footer\";s:4:\"name\";s:13:\"simple-footer\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2499:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-simple\",\"name\":\"Simple Footer\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"32px\",\"right\":\"48px\",\"bottom\":\"32px\",\"left\":\"48px\"},\"blockGap\":\"40px\"}},\"className\":\"wc-blocks-footer-pattern\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-footer-pattern\" style=\"padding-top:32px;padding-right:48px;padding-bottom:32px;padding-left:48px\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"32px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo /-->\n\n<!-- wp:woocommerce/customer-account {\"fontSize\":\"small\"} /-->\n\n<!-- wp:navigation {\"ref\":24} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:50%\"><!-- wp:social-links {\"className\":\"is-style-logos-only\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<ul class=\"wp-block-social-links is-style-logos-only\"><!-- wp:social-link {\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"12px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"12px\"}}} -->\n<p style=\"font-size:12px\">@ 2022</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"fontSize\":\"12px\"}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\"><em>\n			Built with <a href=\"https://woocommerce.com/\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</em></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:67:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/simple-footer/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:07:40\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:91;a:18:{s:2:\"ID\";i:129;s:7:\"site_id\";i:231214916;s:5:\"title\";s:17:\"Large Footer Dark\";s:4:\"name\";s:17:\"large-footer-dark\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4235:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-large-dark\",\"name\":\"Large Footer Dark\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"32px\",\"right\":\"4%\",\"bottom\":\"32px\",\"left\":\"4%\"},\"blockGap\":\"40px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"wc-blocks-footer-pattern has-background-color\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-footer-pattern has-background-color has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"padding-top:32px;padding-right:4%;padding-bottom:32px;padding-left:4%\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"45%\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"50px\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-right:50px;flex-basis:45%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group has-background-color has-text-color\"><!-- wp:site-logo /-->\n\n<!-- wp:spacer {\"height\":\"0px\",\"style\":{\"layout\":{\"flexSize\":\"30px\",\"selfStretch\":\"fixed\"}}} -->\n<div style=\"height:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">به انجمن بپیوندید</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>با محصولات جدید و تخفیف‌ها آشنا شوید!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"0px\",\"style\":{\"layout\":{\"flexSize\":\"20px\",\"selfStretch\":\"fixed\"}}} -->\n<div style=\"height:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:social-links {\"iconColor\":\"background\",\"iconColorValue\":\"#ffffff\",\"size\":\"has-small-icon-size\",\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"https://www.facebook.com\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://www.x.com\",\"service\":\"x\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://www.instagram.com\",\"service\":\"instagram\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0px;flex-basis:20%\"><!-- wp:navigation {\"ref\":24,\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"20%\",\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:20%\"><!-- wp:navigation {\"ref\":24,\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"20%\",\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:20%\"><!-- wp:woocommerce/customer-account {\"displayStyle\":\"text_only\",\"fontSize\":\"small\"} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"10px\"}},\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull has-background-color has-text-color\" style=\"padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group has-background-color has-text-color has-link-color\"><!-- wp:paragraph -->\n<p>@ 2024</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:site-title /--></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p><em>\n			Built with <a href=\"https://woocommerce.com/\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</em></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:71:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/large-footer-dark/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:06:19\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:92;a:18:{s:2:\"ID\";i:125;s:7:\"site_id\";i:231214916;s:5:\"title\";s:12:\"Large Footer\";s:4:\"name\";s:12:\"large-footer\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3649:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-large\",\"name\":\"Large Footer\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"40px\",\"right\":\"40px\",\"bottom\":\"40px\",\"left\":\"40px\"},\"blockGap\":\"40px\"}},\"className\":\"wc-blocks-pattern-footer-large wc-blocks-footer-pattern\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-footer-large wc-blocks-footer-pattern\" style=\"padding-top:40px;padding-right:40px;padding-bottom:40px;padding-left:40px\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"32px\",\"padding\":{\"right\":\"0px\",\"left\":\"0px\"}}}} -->\n<div class=\"wp-block-columns alignwide\" style=\"padding-right:0px;padding-left:0px\"><!-- wp:column {\"width\":\"60%\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"50px\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-right:50px;flex-basis:60%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo /-->\n\n<!-- wp:heading {\"level\":5,\"style\":{\"typography\":{\"textTransform\":\"none\"},\"spacing\":{\"margin\":{\"top\":\"40px\"}}}} -->\n<h5 class=\"wp-block-heading\" style=\"margin-top:40px;text-transform:none\">به انجمن بپیوندید</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"40px\"}}}} -->\n<p style=\"margin-bottom:40px\">با محصولات جدید و تخفیف‌ها آشنا شوید!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:social-links {\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"16px\"}}},\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-small-icon-size is-style-logos-only\"><!-- wp:social-link {\"url\":\"https://www.facebook.com\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://www.x.com\",\"service\":\"x\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://www.instagram.com\",\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://www.twitch.com\",\"service\":\"twitch\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0px;flex-basis:20%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"20%\",\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:20%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"20%\",\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:20%\"><!-- wp:navigation {\"ref\":24,\"overlayMenu\":\"never\",\"layout\":{\"overlayMenu\":\"never\",\"type\":\"flex\",\"orientation\":\"vertical\"},\"style\":{\"spacing\":{\"blockGap\":\"10px\"}}} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"10px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}}} /-->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">\n			Powered by <a href=\"https://wordpress.org\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WordPress</a> with <a href=\"https://woocommerce.com\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:66:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/large-footer/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:05:20\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:93;a:18:{s:2:\"ID\";i:119;s:7:\"site_id\";i:231214916;s:5:\"title\";s:36:\"Featured Products: Fresh &amp; Tasty\";s:4:\"name\";s:29:\"featured-products-fresh-tasty\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5122:\"<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":120,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"full\"} -->\n<figure class=\"wp-block-image alignfull size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/sweet-organic-lemons.png\" alt=\"\" class=\"wp-image-120\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\"},\"margin\":{\"top\":\"5px\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-columns\" style=\"margin-top:5px;margin-bottom:0\"><!-- wp:column {\"width\":\"67%\",\"style\":{\"typography\":{\"fontWeight\":\"600\"}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-column\" style=\"font-weight:600;flex-basis:67%\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">لیموهای ارگانیک شیرین</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33%\"><!-- wp:paragraph {\"align\":\"left\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-left has-small-font-size\">از 1.99 دلار</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":121,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"full\"} -->\n<figure class=\"wp-block-image alignfull size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/fresh-organic-tomatoes.png\" alt=\"\" class=\"wp-image-121\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\"},\"margin\":{\"top\":\"5px\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-columns\" style=\"margin-top:5px;margin-bottom:0\"><!-- wp:column {\"width\":\"67%\",\"style\":{\"typography\":{\"fontWeight\":\"600\"}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-column\" style=\"font-weight:600;flex-basis:67%\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">گوجه فرنگی تازه ارگانیک</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33%\"><!-- wp:paragraph {\"align\":\"left\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-left has-small-font-size\">از 2.99 دلار</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":122,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"full\"} -->\n<figure class=\"wp-block-image alignfull size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/fresh-lettuce-washed.png\" alt=\"\" class=\"wp-image-122\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\"},\"margin\":{\"top\":\"5px\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-columns\" style=\"margin-top:5px;margin-bottom:0\"><!-- wp:column {\"width\":\"67%\",\"style\":{\"typography\":{\"fontWeight\":\"600\"}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-column\" style=\"font-weight:600;flex-basis:67%\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">کاهوی تازه (شسته شده)</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33%\"><!-- wp:paragraph {\"align\":\"left\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-left has-small-font-size\">از 0.99 دلار</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":123,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"full\"} -->\n<figure class=\"wp-block-image alignfull size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/russet-organic-potatoes.png\" alt=\"\" class=\"wp-image-123\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\"},\"margin\":{\"top\":\"5px\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-columns\" style=\"margin-top:5px;margin-bottom:0\"><!-- wp:column {\"width\":\"67%\",\"style\":{\"typography\":{\"fontWeight\":\"600\"}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-column\" style=\"font-weight:600;flex-basis:67%\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">سیب‌زمینی ارگانیک زنگارگون</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33%\"><!-- wp:paragraph {\"align\":\"left\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-left has-small-font-size\">از 1.49 دلار</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:83:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/featured-products-fresh-tasty/\";s:13:\"modified_date\";s:19:\"2024-06-17 13:47:45\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:94;a:18:{s:2:\"ID\";i:115;s:7:\"site_id\";i:231214916;s:5:\"title\";s:26:\"Discount Banner with Image\";s:4:\"name\";s:26:\"discount-banner-with-image\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3268:\"<!-- wp:columns {\"verticalAlignment\":\"center\",\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/discount-banner-with-image\",\"name\":\"Discount Banner with Image\"},\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#254094\"},\"spacing\":{\"padding\":{\"top\":\"30px\",\"right\":\"30px\",\"bottom\":\"30px\",\"left\":\"30px\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center has-background\" style=\"background-color:#254094;padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"15px\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"350px\"}} -->\n<div class=\"wp-block-group\" style=\"padding-top:15px\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\",\"fontSize\":\"45px\",\"lineHeight\":\"0\"},\"color\":{\"text\":\"#ffffff\"}}} -->\n<p class=\"has-text-color\" style=\"color:#ffffff;font-size:45px;font-style:normal;font-weight:500;line-height:0\">UP TO</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#fdf251\"},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"800\",\"fontSize\":\"90px\",\"lineHeight\":\"0.8\"}}} -->\n<p class=\"has-text-color\" style=\"color:#fdf251;font-size:90px;font-style:normal;font-weight:800;line-height:0.8\">40% off</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"fontSize\":\"35px\",\"lineHeight\":\"0\"},\"color\":{\"text\":\"#ffffff\"},\"spacing\":{\"margin\":{\"bottom\":\"40px\"}}}} -->\n<p class=\"has-text-color\" style=\"color:#ffffff;margin-bottom:40px;font-size:35px;font-style:normal;font-weight:300;line-height:0\">Select products</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"color\":{\"background\":\"#ff7179\",\"text\":\"#ffffff\"},\"border\":{\"radius\":\"40px\",\"width\":\"0px\",\"style\":\"none\"},\"spacing\":{\"padding\":{\"top\":\"10px\",\"bottom\":\"10px\",\"left\":\"30px\",\"right\":\"30px\"}}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\" style=\"border-style:none;border-width:0px;border-radius:40px;color:#ffffff;background-color:#ff7179;padding-top:10px;padding-right:30px;padding-bottom:10px;padding-left:30px\">اکنون خرید کنید</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"id\":117,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"center\",\"style\":{\"border\":{\"radius\":{\"topLeft\":\"100px\",\"topRight\":\"10px\",\"bottomLeft\":\"10px\",\"bottomRight\":\"100px\"}}}} -->\n<figure class=\"wp-block-image aligncenter size-full has-custom-border\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/table-floor-interior-atmosphere-living-room-furniture-square-lg.png\" alt=\"\" class=\"wp-image-117\" style=\"border-top-left-radius:100px;border-top-right-radius:10px;border-bottom-left-radius:10px;border-bottom-right-radius:100px\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:80:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/discount-banner-with-image/\";s:13:\"modified_date\";s:19:\"2024-06-17 13:45:36\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:95;a:18:{s:2:\"ID\";i:113;s:7:\"site_id\";i:231214916;s:5:\"title\";s:15:\"Discount banner\";s:4:\"name\";s:15:\"discount-banner\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2312:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/discount-banner\",\"name\":\"Discount Banner\"},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"470px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}},\"color\":{\"background\":\"#254094\"}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"\"}} -->\n<div class=\"wp-block-group has-background\" style=\"background-color:#254094;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\",\"fontSize\":\"45px\"},\"color\":{\"text\":\"#ffffff\"}}} -->\n<p class=\"has-text-color\" style=\"color:#ffffff;font-size:45px;font-style:normal;font-weight:500\">UP TO</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#fdf251\"},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"800\",\"fontSize\":\"90px\",\"lineHeight\":\"0.1\"}}} -->\n<p class=\"has-text-color\" style=\"color:#fdf251;font-size:90px;font-style:normal;font-weight:800;line-height:0.1\">40% off</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"fontSize\":\"35px\"},\"color\":{\"text\":\"#ffffff\"}}} -->\n<p class=\"has-text-color\" style=\"color:#ffffff;font-size:35px;font-style:normal;font-weight:300\">Select products</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"color\":{\"background\":\"#ff7179\",\"text\":\"#ffffff\"},\"border\":{\"radius\":\"40px\",\"width\":\"0px\",\"style\":\"none\"},\"spacing\":{\"padding\":{\"top\":\"10px\",\"bottom\":\"10px\",\"left\":\"30px\",\"right\":\"30px\"}}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\" style=\"border-style:none;border-width:0px;border-radius:40px;color:#ffffff;background-color:#ff7179;padding-top:10px;padding-right:30px;padding-bottom:10px;padding-left:30px\">\n					Shop now\n				</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:69:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/discount-banner/\";s:13:\"modified_date\";s:19:\"2024-06-17 13:39:37\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:96;a:18:{s:2:\"ID\";i:99;s:7:\"site_id\";i:231214916;s:5:\"title\";s:23:\"Featured Category Focus\";s:4:\"name\";s:22:\"feature-category-focus\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1621:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/featured-category-focus\",\"name\":\"Featured Category Focus\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"right\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\",\"left\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--70);padding-right:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70);padding-left:var(--wp--preset--spacing--70)\"><!-- wp:image {\"id\":100,\"width\":\"469px\",\"height\":\"348px\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/white-black-black-and-white-photograph-monochrome-photography.jpg\" alt=\"\" class=\"wp-image-100\" style=\"object-fit:cover;width:469px;height:348px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"large\"} -->\n<p class=\"has-text-align-center has-large-font-size\">Black and white high-quality prints</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\" style=\"border-style:none;border-width:0px\">Shop prints</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:21:\"_woo_featured_selling\";a:3:{s:4:\"slug\";s:21:\"_woo_featured_selling\";s:5:\"title\";s:21:\"_woo_featured_selling\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:76:\"https://wooblockpatterns.wpcomstaging.com/2024/06/14/feature-category-focus/\";s:13:\"modified_date\";s:19:\"2024-07-18 16:17:19\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:97;a:18:{s:2:\"ID\";i:90;s:7:\"site_id\";i:231214916;s:5:\"title\";s:27:\"Large Image Product Gallery\";s:4:\"name\";s:27:\"large-image-product-gallery\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3144:\"<!-- wp:group {\"metadata\":{\"name\":\"Large Image Product Gallery\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:query {\"queryId\":3,\"query\":{\"perPage\":\"4\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\"} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"grid\",\"columnCount\":2},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:woocommerce/product-image {\"saleBadgeAlign\":\"left\",\"isDescendentOfQueryLoop\":true,\"aspectRatio\":\"2/3\"} /-->\n\n<!-- wp:post-title {\"textAlign\":\"center\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"medium\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"textAlign\":\"center\",\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /-->\n<!-- /wp:post-template --></div>\n<!-- /wp:query -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:21:\"_woo_featured_selling\";a:3:{s:4:\"slug\";s:21:\"_woo_featured_selling\";s:5:\"title\";s:21:\"_woo_featured_selling\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/06/14/large-image-product-gallery/\";s:13:\"modified_date\";s:19:\"2024-07-02 10:55:34\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:98;a:18:{s:2:\"ID\";i:83;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Product Collection 3 Columns\";s:4:\"name\";s:28:\"product-collection-3-columns\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3351:\"<!-- wp:group {\"metadata\":{\"name\":\"Product Collection 3 Columns\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:woocommerce/product-collection {\"queryId\":26,\"query\":{\"perPage\":3,\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"asc\",\"orderBy\":\"title\",\"search\":\"\",\"exclude\":[],\"inherit\":false,\"taxQuery\":[],\"isProductCollectionBlock\":true,\"woocommerceOnSale\":false,\"woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"],\"woocommerceAttributes\":[],\"woocommerceHandPickedProducts\":[]},\"tagName\":\"div\",\"displayLayout\":{\"type\":\"flex\",\"columns\":3},\"queryContextIncludes\":[\"collection\"],\"align\":\"wide\"} -->\n<div class=\"wp-block-woocommerce-product-collection alignwide\"><!-- wp:woocommerce/product-template -->\n<!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true,\"aspectRatio\":\"3/5\"} /-->\n\n<!-- wp:woocommerce/product-rating {\"isDescendentOfQueryLoop\":true,\"textAlign\":\"center\"} /-->\n\n<!-- wp:post-title {\"textAlign\":\"center\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"medium\",\"__woocommerceNamespace\":\"woocommerce/product-collection/product-title\"} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"textAlign\":\"center\",\"fontSize\":\"small\"} /-->\n<!-- /wp:woocommerce/product-template --></div>\n<!-- /wp:woocommerce/product-collection -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:21:\"_woo_featured_selling\";a:3:{s:4:\"slug\";s:21:\"_woo_featured_selling\";s:5:\"title\";s:21:\"_woo_featured_selling\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:82:\"https://wooblockpatterns.wpcomstaging.com/2024/06/14/product-collection-3-columns/\";s:13:\"modified_date\";s:19:\"2024-07-02 10:35:33\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}}", "on");
INSERT INTO `wp_options` VALUES("78808", "updraft_lock_aios_15_minutes_cron_event", "0", "no");
INSERT INTO `wp_options` VALUES("1118", "wtier_bfcm_twenty_twenty_four_banner_state", "4", "auto");
INSERT INTO `wp_options` VALUES("1114", "wt_iew_admin_modules", "a:3:{s:7:\"history\";i:1;s:6:\"export\";i:1;s:6:\"import\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("1115", "wt_p_iew_basic_start_date", "1740661283", "auto");
INSERT INTO `wp_options` VALUES("1577", "widget_currency_switcher_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("1578", "woocommerce_woocommerce_payments_settings", "a:19:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";s:17:\"platform_checkout\";s:2:\"no\";s:35:\"payment_request_button_branded_type\";s:0:\"\";}", "on");
INSERT INTO `wp_options` VALUES("1579", "woocommerce_woocommerce_payments_alipay_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1580", "woocommerce_woocommerce_payments_bancontact_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1581", "woocommerce_woocommerce_payments_sepa_debit_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1582", "woocommerce_woocommerce_payments_giropay_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1583", "woocommerce_woocommerce_payments_sofort_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1584", "woocommerce_woocommerce_payments_p24_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1585", "woocommerce_woocommerce_payments_ideal_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1586", "woocommerce_woocommerce_payments_au_becs_debit_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1587", "woocommerce_woocommerce_payments_eps_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1588", "woocommerce_woocommerce_payments_link_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1589", "woocommerce_woocommerce_payments_affirm_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1590", "woocommerce_woocommerce_payments_afterpay_clearpay_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1591", "woocommerce_woocommerce_payments_klarna_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1592", "woocommerce_woocommerce_payments_grabpay_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1593", "woocommerce_woocommerce_payments_wechat_pay_settings", "a:17:{s:7:\"enabled\";s:2:\"no\";s:28:\"account_statement_descriptor\";s:0:\"\";s:14:\"manual_capture\";s:2:\"no\";s:11:\"saved_cards\";s:3:\"yes\";s:9:\"test_mode\";s:2:\"no\";s:14:\"enable_logging\";s:2:\"no\";s:23:\"payment_request_details\";s:0:\"\";s:15:\"payment_request\";s:3:\"yes\";s:27:\"payment_request_button_type\";s:7:\"default\";s:28:\"payment_request_button_theme\";s:4:\"dark\";s:29:\"payment_request_button_height\";s:2:\"44\";s:28:\"payment_request_button_label\";s:7:\"Buy now\";s:32:\"payment_request_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:30:\"upe_enabled_payment_method_ids\";a:1:{i:0;s:4:\"card\";}s:27:\"payment_request_button_size\";s:6:\"medium\";s:34:\"platform_checkout_button_locations\";a:3:{i:0;s:7:\"product\";i:1;s:4:\"cart\";i:2;s:8:\"checkout\";}s:32:\"platform_checkout_custom_message\";s:84:\"By placing this order, you agree to our [terms] and understand our [privacy_policy].\";}", "on");
INSERT INTO `wp_options` VALUES("1594", "wcpay_activation_timestamp", "1740676163", "auto");
INSERT INTO `wp_options` VALUES("1595", "woocommerce_woocommerce_payments_version", "9.0.0", "auto");
INSERT INTO `wp_options` VALUES("1596", "wcpay_multi_currency_store_currency", "IRR", "auto");
INSERT INTO `wp_options` VALUES("1602", "wcpay_recommended_payment_methods__US__fa_IR", "a:3:{s:4:\"data\";a:11:{i:0;a:7:{s:2:\"id\";s:4:\"card\";s:4:\"type\";s:7:\"enabled\";s:5:\"title\";s:17:\"Credit/debit card\";s:11:\"description\";s:40:\"Accepts all major credit and debit cards\";s:8:\"priority\";i:1;s:8:\"required\";b:1;s:4:\"icon\";s:44:\"https://s0.wp.com/i/payment-methods/card.svg\";}i:1;a:7:{s:2:\"id\";s:9:\"apple_pay\";s:4:\"type\";s:7:\"enabled\";s:5:\"title\";s:9:\"Apple Pay\";s:11:\"description\";s:65:\"Give your shoppers an easy and secure way to pay, with Apple Pay.\";s:8:\"priority\";i:2;s:8:\"required\";b:0;s:4:\"icon\";s:49:\"https://s0.wp.com/i/payment-methods/apple_pay.svg\";}i:2;a:7:{s:2:\"id\";s:10:\"google_pay\";s:4:\"type\";s:7:\"enabled\";s:5:\"title\";s:10:\"Google Pay\";s:11:\"description\";s:70:\"Offer customers a fast and secure checkout experience with Google Pay.\";s:8:\"priority\";i:3;s:8:\"required\";b:0;s:4:\"icon\";s:50:\"https://s0.wp.com/i/payment-methods/google_pay.svg\";}i:3;a:7:{s:2:\"id\";s:6:\"woopay\";s:4:\"type\";s:7:\"enabled\";s:5:\"title\";s:6:\"WooPay\";s:11:\"description\";s:91:\"Boost conversions and customer loyalty by offering a secure way to pay with a single click.\";s:8:\"priority\";i:4;s:8:\"required\";b:0;s:4:\"icon\";s:46:\"https://s0.wp.com/i/payment-methods/woopay.svg\";}i:4;a:7:{s:2:\"id\";s:6:\"affirm\";s:4:\"type\";s:7:\"enabled\";s:5:\"title\";s:6:\"Affirm\";s:11:\"description\";s:49:\"Allow your shoppers to pay over time with Affirm.\";s:8:\"priority\";i:5;s:8:\"required\";b:0;s:4:\"icon\";s:46:\"https://s0.wp.com/i/payment-methods/affirm.svg\";}i:5;a:7:{s:2:\"id\";s:17:\"afterpay_clearpay\";s:4:\"type\";s:7:\"enabled\";s:5:\"title\";s:8:\"Afterpay\";s:11:\"description\";s:51:\"Allow your shoppers to pay over time with Afterpay.\";s:8:\"priority\";i:6;s:8:\"required\";b:0;s:4:\"icon\";s:57:\"https://s0.wp.com/i/payment-methods/afterpay_clearpay.svg\";}i:6;a:7:{s:2:\"id\";s:6:\"klarna\";s:4:\"type\";s:7:\"enabled\";s:5:\"title\";s:6:\"Klarna\";s:11:\"description\";s:49:\"Allow your shoppers to pay over time with Klarna.\";s:8:\"priority\";i:7;s:8:\"required\";b:0;s:4:\"icon\";s:46:\"https://s0.wp.com/i/payment-methods/klarna.svg\";}i:7;a:7:{s:2:\"id\";s:10:\"bancontact\";s:4:\"type\";s:9:\"available\";s:5:\"title\";s:10:\"Bancontact\";s:11:\"description\";s:102:\"Bancontact is a bank redirect payment method offered by more than 80% of online businesses in Belgium.\";s:8:\"priority\";i:8;s:8:\"required\";b:0;s:4:\"icon\";s:50:\"https://s0.wp.com/i/payment-methods/bancontact.svg\";}i:8;a:7:{s:2:\"id\";s:3:\"eps\";s:4:\"type\";s:9:\"available\";s:5:\"title\";s:3:\"EPS\";s:11:\"description\";s:68:\"Accept your payment with EPS — a common payment method in Austria.\";s:8:\"priority\";i:9;s:8:\"required\";b:0;s:4:\"icon\";s:43:\"https://s0.wp.com/i/payment-methods/eps.svg\";}i:9;a:7:{s:2:\"id\";s:5:\"ideal\";s:4:\"type\";s:9:\"available\";s:5:\"title\";s:5:\"iDEAL\";s:11:\"description\";s:127:\"iDEAL is a Netherlands-based payment method that allows customers to complete transactions online using their bank credentials.\";s:8:\"priority\";i:10;s:8:\"required\";b:0;s:4:\"icon\";s:45:\"https://s0.wp.com/i/payment-methods/ideal.svg\";}i:10;a:7:{s:2:\"id\";s:3:\"p24\";s:4:\"type\";s:9:\"available\";s:5:\"title\";s:10:\"Przelewy24\";s:11:\"description\";s:81:\"Accept payments with Przelewy24 (P24), the most popular payment method in Poland.\";s:8:\"priority\";i:11;s:8:\"required\";b:0;s:4:\"icon\";s:43:\"https://s0.wp.com/i/payment-methods/p24.svg\";}}s:7:\"fetched\";i:1740676164;s:7:\"errored\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("1606", "wcpay_menu_badge_hidden", "yes", "auto");
INSERT INTO `wp_options` VALUES("1607", "jetpack_tos_agreed", "1", "auto");
INSERT INTO `wp_options` VALUES("1608", "jetpack_secrets", "a:1:{s:19:\"jetpack_authorize_1\";a:3:{s:8:\"secret_1\";s:32:\"RsxhsIDw0rPwJBBOZ47atzAih9IoRlzj\";s:8:\"secret_2\";s:32:\"tDAwyidryW4NzL3G03vNXsqMzD8a5w0G\";s:3:\"exp\";i:1740683495;}}", "no");
INSERT INTO `wp_options` VALUES("1612", "jetpack_package_versions", "a:1:{s:10:\"connection\";s:5:\"6.2.0\";}", "auto");
INSERT INTO `wp_options` VALUES("1609", "jetpack_sync_https_history_site_url", "a:5:{i:0;s:5:\"https\";i:1;s:5:\"https\";i:2;s:5:\"https\";i:3;s:5:\"https\";i:4;s:5:\"https\";}", "auto");
INSERT INTO `wp_options` VALUES("1610", "jetpack_sync_https_history_home_url", "a:5:{i:0;s:5:\"https\";i:1;s:5:\"https\";i:2;s:5:\"https\";i:3;s:5:\"https\";i:4;s:5:\"https\";}", "auto");
INSERT INTO `wp_options` VALUES("1611", "_transient_jetpack_assumed_site_creation_date", "2020-12-11 09:25:01", "on");
INSERT INTO `wp_options` VALUES("1613", "jetpack_private_options", "a:1:{s:10:\"blog_token\";s:65:\"k2lolX64BYcGjjBbr7Hhie@)^3xySnUh.hEP#j7PG66u!pW69%kiugeHIg0WEqGDm\";}", "auto");
INSERT INTO `wp_options` VALUES("1614", "jetpack_sync_settings_custom_queue_table_enabled", "1", "on");
INSERT INTO `wp_options` VALUES("1615", "jetpack_sync_settings_max_queue_size", "5000", "on");
INSERT INTO `wp_options` VALUES("1616", "jetpack_sync_settings_max_queue_lag", "7200", "on");
INSERT INTO `wp_options` VALUES("1752", "jetpack_sync_full_status", "a:4:{s:7:\"started\";i:1740676353;s:8:\"finished\";i:1740676360;s:8:\"progress\";a:7:{s:9:\"constants\";a:1:{s:8:\"finished\";b:1;}s:9:\"functions\";a:1:{s:8:\"finished\";b:1;}s:7:\"options\";a:1:{s:8:\"finished\";b:1;}s:5:\"posts\";a:4:{s:5:\"total\";i:140;s:4:\"sent\";i:140;s:8:\"finished\";b:1;s:9:\"last_sent\";s:1:\"2\";}s:7:\"updates\";a:1:{s:8:\"finished\";b:1;}s:11:\"woocommerce\";a:4:{s:5:\"total\";i:0;s:4:\"sent\";i:0;s:8:\"finished\";b:1;s:9:\"last_sent\";s:2:\"~0\";}s:23:\"woocommerce_hpos_orders\";a:4:{s:5:\"total\";i:0;s:4:\"sent\";i:0;s:8:\"finished\";b:1;s:9:\"last_sent\";s:2:\"~0\";}}s:6:\"config\";a:12:{s:8:\"comments\";b:1;s:9:\"constants\";b:1;s:9:\"functions\";b:1;s:7:\"options\";b:1;s:5:\"posts\";b:1;s:18:\"term_relationships\";b:1;s:5:\"terms\";b:1;s:6:\"themes\";b:1;s:7:\"updates\";b:1;s:5:\"users\";b:1;s:11:\"woocommerce\";b:1;s:23:\"woocommerce_hpos_orders\";b:1;}}", "no");
INSERT INTO `wp_options` VALUES("1618", "jetpack_sync_settings_dequeue_max_bytes", "500000", "on");
INSERT INTO `wp_options` VALUES("1619", "jetpack_sync_settings_upload_max_bytes", "600000", "on");
INSERT INTO `wp_options` VALUES("1620", "jetpack_sync_settings_upload_max_rows", "500", "on");
INSERT INTO `wp_options` VALUES("1621", "jetpack_sync_settings_sync_wait_time", "10", "on");
INSERT INTO `wp_options` VALUES("1622", "jetpack_sync_settings_sync_wait_threshold", "10", "on");
INSERT INTO `wp_options` VALUES("1623", "jetpack_sync_settings_enqueue_wait_time", "1", "on");
INSERT INTO `wp_options` VALUES("1624", "jetpack_sync_settings_queue_max_writes_sec", "100", "on");
INSERT INTO `wp_options` VALUES("1625", "jetpack_sync_settings_post_types_blacklist", "a:45:{i:0;s:10:\"_term_meta\";i:1;s:11:\"ai1ec_event\";i:2;s:6:\"ai_log\";i:3;s:17:\"amp_validated_url\";i:4;s:9:\"bwg_album\";i:5;s:11:\"bwg_gallery\";i:6;s:19:\"customize_changeset\";i:7;s:12:\"dn_wp_yt_log\";i:8;s:16:\"flamingo_contact\";i:9;s:16:\"flamingo_inbound\";i:10;s:17:\"flamingo_outbound\";i:11;s:4:\"http\";i:12;s:8:\"idx_page\";i:13;s:19:\"jetpack_inspect_log\";i:14;s:17:\"jetpack_migration\";i:15;s:14:\"jp_img_sitemap\";i:16;s:20:\"jp_img_sitemap_index\";i:17;s:10:\"jp_sitemap\";i:18;s:16:\"jp_sitemap_index\";i:19;s:17:\"jp_sitemap_master\";i:20;s:14:\"jp_vid_sitemap\";i:21;s:20:\"jp_vid_sitemap_index\";i:22;s:11:\"msm_sitemap\";i:23;s:17:\"postman_sent_mail\";i:24;s:10:\"rssap-feed\";i:25;s:15:\"rssmi_feed_item\";i:26;s:16:\"scheduled-action\";i:27;s:20:\"secupress_log_action\";i:28;s:17:\"sg_optimizer_jobs\";i:29;s:14:\"sl-insta-media\";i:30;s:6:\"snitch\";i:31;s:19:\"vip-legacy-redirect\";i:32;s:15:\"wp-rest-api-log\";i:33;s:12:\"wp_automatic\";i:34;s:6:\"wp_log\";i:35;s:17:\"wpephpcompat_jobs\";i:36;s:15:\"wprss_feed_item\";i:37;s:18:\"memberships_coupon\";i:38;s:16:\"memberships_gift\";i:39;s:15:\"tribe-ea-record\";i:40;s:17:\"wphb_minify_group\";i:41;s:16:\"bigcommerce_task\";i:42;s:20:\"secupress_log_err404\";i:43;s:20:\"iw_omnibus_price_log\";i:44;s:14:\"od_url_metrics\";}", "on");
INSERT INTO `wp_options` VALUES("1800", "woocommerce_bacs_accounts", "a:2:{i:0;a:6:{s:12:\"account_name\";s:0:\"\";s:14:\"account_number\";s:0:\"\";s:9:\"bank_name\";s:0:\"\";s:9:\"sort_code\";s:0:\"\";s:4:\"iban\";s:0:\"\";s:3:\"bic\";s:0:\"\";}i:1;a:6:{s:12:\"account_name\";s:0:\"\";s:14:\"account_number\";s:0:\"\";s:9:\"bank_name\";s:0:\"\";s:9:\"sort_code\";s:0:\"\";s:4:\"iban\";s:0:\"\";s:3:\"bic\";s:0:\"\";}}", "auto");
INSERT INTO `wp_options` VALUES("1629", "jetpack_sync_settings_dedicated_sync_enabled", "1", "on");
INSERT INTO `wp_options` VALUES("1631", "jetpack_sync_settings_taxonomies_blacklist", "a:149:{i:0;s:9:\"ancestors\";i:1;s:13:\"archives_link\";i:2;s:13:\"attached_file\";i:3;s:14:\"attached_media\";i:4;s:19:\"attached_media_args\";i:5;s:10:\"attachment\";i:6;s:19:\"available_languages\";i:7;s:6:\"avatar\";i:8;s:20:\"avatar_comment_types\";i:9;s:11:\"avatar_data\";i:10;s:10:\"avatar_url\";i:11;s:12:\"bloginfo_rss\";i:12;s:13:\"blogs_of_user\";i:13;s:13:\"bookmark_link\";i:14;s:9:\"bookmarks\";i:15;s:8:\"calendar\";i:16;s:13:\"canonical_url\";i:17;s:19:\"categories_per_page\";i:18;s:19:\"categories_taxonomy\";i:19;s:13:\"category_form\";i:20;s:20:\"category_form_fields\";i:21;s:17:\"category_form_pre\";i:22;s:7:\"comment\";i:23;s:10:\"comment_ID\";i:24;s:14:\"comment_author\";i:25;s:17:\"comment_author_IP\";i:26;s:20:\"comment_author_email\";i:27;s:19:\"comment_author_link\";i:28;s:18:\"comment_author_url\";i:29;s:23:\"comment_author_url_link\";i:30;s:12:\"comment_date\";i:31;s:15:\"comment_excerpt\";i:32;s:12:\"comment_link\";i:33;s:20:\"comment_misc_actions\";i:34;s:12:\"comment_text\";i:35;s:12:\"comment_time\";i:36;s:12:\"comment_type\";i:37;s:13:\"comments_link\";i:38;s:15:\"comments_number\";i:39;s:21:\"comments_pagenum_link\";i:40;s:11:\"custom_logo\";i:41;s:8:\"date_sql\";i:42;s:22:\"default_comment_status\";i:43;s:16:\"delete_post_link\";i:44;s:18:\"edit_bookmark_link\";i:45;s:17:\"edit_comment_link\";i:46;s:14:\"edit_post_link\";i:47;s:13:\"edit_tag_link\";i:48;s:14:\"edit_term_link\";i:49;s:14:\"edit_user_link\";i:50;s:8:\"enclosed\";i:51;s:15:\"feed_build_date\";i:52;s:13:\"form_advanced\";i:53;s:17:\"form_after_editor\";i:54;s:16:\"form_after_title\";i:55;s:21:\"form_before_permalink\";i:56;s:8:\"form_top\";i:57;s:18:\"handle_product_cat\";i:58;s:16:\"header_image_tag\";i:59;s:16:\"header_video_url\";i:60;s:9:\"image_tag\";i:61;s:15:\"image_tag_class\";i:62;s:12:\"lastpostdate\";i:63;s:16:\"lastpostmodified\";i:64;s:4:\"link\";i:65;s:18:\"link_category_form\";i:66;s:25:\"link_category_form_fields\";i:67;s:22:\"link_category_form_pre\";i:68;s:15:\"main_network_id\";i:69;s:5:\"media\";i:70;s:15:\"media_item_args\";i:71;s:7:\"ms_user\";i:72;s:7:\"network\";i:73;s:12:\"object_terms\";i:74;s:6:\"option\";i:75;s:4:\"page\";i:76;s:9:\"page_form\";i:77;s:15:\"page_of_comment\";i:78;s:8:\"page_uri\";i:79;s:12:\"pagenum_link\";i:80;s:5:\"pages\";i:81;s:6:\"plugin\";i:82;s:4:\"post\";i:83;s:14:\"post_galleries\";i:84;s:12:\"post_gallery\";i:85;s:9:\"post_link\";i:86;s:18:\"post_modified_time\";i:87;s:11:\"post_status\";i:88;s:9:\"post_time\";i:89;s:8:\"postmeta\";i:90;s:14:\"posts_per_page\";i:91;s:19:\"product_search_form\";i:92;s:11:\"profile_url\";i:93;s:4:\"pung\";i:94;s:9:\"role_list\";i:95;s:16:\"sample_permalink\";i:96;s:21:\"sample_permalink_html\";i:97;s:8:\"schedule\";i:98;s:11:\"search_form\";i:99;s:12:\"search_query\";i:100;s:9:\"shortlink\";i:101;s:4:\"site\";i:102;s:18:\"site_email_content\";i:103;s:13:\"site_icon_url\";i:104;s:11:\"site_option\";i:105;s:13:\"space_allowed\";i:106;s:3:\"tag\";i:107;s:8:\"tag_form\";i:108;s:15:\"tag_form_fields\";i:109;s:12:\"tag_form_pre\";i:110;s:8:\"tag_link\";i:111;s:4:\"tags\";i:112;s:13:\"tags_per_page\";i:113;s:4:\"term\";i:114;s:9:\"term_link\";i:115;s:18:\"term_relationships\";i:116;s:15:\"term_taxonomies\";i:117;s:13:\"term_taxonomy\";i:118;s:5:\"terms\";i:119;s:10:\"terms_args\";i:120;s:14:\"terms_defaults\";i:121;s:12:\"terms_fields\";i:122;s:13:\"terms_orderby\";i:123;s:23:\"the_archive_description\";i:124;s:17:\"the_archive_title\";i:125;s:14:\"the_categories\";i:126;s:8:\"the_date\";i:127;s:11:\"the_excerpt\";i:128;s:8:\"the_guid\";i:129;s:17:\"the_modified_date\";i:130;s:17:\"the_modified_time\";i:131;s:25:\"the_post_type_description\";i:132;s:8:\"the_tags\";i:133;s:9:\"the_terms\";i:134;s:8:\"the_time\";i:135;s:21:\"theme_starter_content\";i:136;s:7:\"to_ping\";i:137;s:4:\"user\";i:138;s:17:\"user_created_user\";i:139;s:9:\"user_form\";i:140;s:12:\"user_profile\";i:141;s:19:\"user_profile_update\";i:142;s:8:\"usermeta\";i:143;s:12:\"usernumposts\";i:144;s:12:\"users_drafts\";i:145;s:7:\"webhook\";i:146;s:6:\"widget\";i:147;s:19:\"woocommerce_archive\";i:148;s:12:\"wp_title_rss\";}", "on");
INSERT INTO `wp_options` VALUES("1633", "jetpack_sync_settings_render_filtered_content", "0", "on");
INSERT INTO `wp_options` VALUES("1634", "jetpack_sync_settings_post_meta_whitelist", "a:112:{i:0;s:24:\"_feedback_akismet_values\";i:1;s:15:\"_feedback_email\";i:2;s:22:\"_feedback_extra_fields\";i:3;s:21:\"_g_feedback_shortcode\";i:4;s:23:\"_jetpack_post_thumbnail\";i:5;s:25:\"_last_editor_used_jetpack\";i:6;s:18:\"_menu_item_classes\";i:7;s:27:\"_menu_item_menu_item_parent\";i:8;s:17:\"_menu_item_object\";i:9;s:20:\"_menu_item_object_id\";i:10;s:19:\"_menu_item_orphaned\";i:11;s:15:\"_menu_item_type\";i:12;s:14:\"_menu_item_xfn\";i:13;s:24:\"_publicize_facebook_user\";i:14;s:23:\"_publicize_twitter_user\";i:15;s:13:\"_thumbnail_id\";i:16;s:17:\"_wp_attached_file\";i:17;s:27:\"_wp_attachment_backup_sizes\";i:18;s:22:\"_wp_attachment_context\";i:19;s:24:\"_wp_attachment_image_alt\";i:20;s:35:\"_wp_attachment_is_custom_background\";i:21;s:31:\"_wp_attachment_is_custom_header\";i:22;s:23:\"_wp_attachment_metadata\";i:23;s:17:\"_wp_page_template\";i:24;s:30:\"_wp_trash_meta_comments_status\";i:25;s:21:\"_wpas_feature_enabled\";i:26;s:10:\"_wpas_mess\";i:27;s:13:\"_wpas_options\";i:28;s:24:\"advanced_seo_description\";i:29;s:13:\"content_width\";i:30;s:14:\"custom_css_add\";i:31;s:23:\"custom_css_preprocessor\";i:32;s:9:\"enclosure\";i:33;s:9:\"imagedata\";i:34;s:10:\"nova_price\";i:35;s:17:\"publicize_results\";i:36;s:16:\"sharing_disabled\";i:37;s:18:\"switch_like_status\";i:38;s:15:\"videopress_guid\";i:39;s:18:\"vimeo_poster_image\";i:40;s:28:\"_jetpack_blogging_prompt_key\";i:41;s:9:\"footnotes\";i:42;s:11:\"_visibility\";i:43;s:4:\"_sku\";i:44;s:6:\"_price\";i:45;s:14:\"_regular_price\";i:46;s:11:\"_sale_price\";i:47;s:22:\"_sale_price_dates_from\";i:48;s:20:\"_sale_price_dates_to\";i:49;s:11:\"total_sales\";i:50;s:11:\"_tax_status\";i:51;s:10:\"_tax_class\";i:52;s:13:\"_manage_stock\";i:53;s:11:\"_backorders\";i:54;s:18:\"_sold_individually\";i:55;s:7:\"_weight\";i:56;s:7:\"_length\";i:57;s:6:\"_width\";i:58;s:7:\"_height\";i:59;s:11:\"_upsell_ids\";i:60;s:14:\"_crosssell_ids\";i:61;s:14:\"_purchase_note\";i:62;s:19:\"_default_attributes\";i:63;s:19:\"_product_attributes\";i:64;s:8:\"_virtual\";i:65;s:13:\"_downloadable\";i:66;s:15:\"_download_limit\";i:67;s:16:\"_download_expiry\";i:68;s:9:\"_featured\";i:69;s:19:\"_downloadable_files\";i:70;s:16:\"_wc_rating_count\";i:71;s:18:\"_wc_average_rating\";i:72;s:16:\"_wc_review_count\";i:73;s:22:\"_variation_description\";i:75;s:11:\"_file_paths\";i:76;s:22:\"_product_image_gallery\";i:77;s:16:\"_product_version\";i:78;s:12:\"_wp_old_slug\";i:79;s:10:\"_order_key\";i:80;s:15:\"_order_currency\";i:81;s:13:\"_billing_city\";i:82;s:14:\"_billing_state\";i:83;s:17:\"_billing_postcode\";i:84;s:16:\"_billing_country\";i:85;s:14:\"_shipping_city\";i:86;s:15:\"_shipping_state\";i:87;s:18:\"_shipping_postcode\";i:88;s:17:\"_shipping_country\";i:89;s:15:\"_completed_date\";i:90;s:10:\"_paid_date\";i:91;s:14:\"_cart_discount\";i:92;s:18:\"_cart_discount_tax\";i:93;s:15:\"_order_shipping\";i:94;s:19:\"_order_shipping_tax\";i:95;s:10:\"_order_tax\";i:96;s:12:\"_order_total\";i:97;s:15:\"_payment_method\";i:98;s:21:\"_payment_method_title\";i:99;s:12:\"_created_via\";i:100;s:14:\"_order_version\";i:101;s:19:\"_prices_include_tax\";i:102;s:15:\"_date_completed\";i:103;s:10:\"_date_paid\";i:104;s:15:\"_payment_tokens\";i:105;s:15:\"_recorded_sales\";i:106;s:29:\"_recorded_coupon_usage_counts\";i:107;s:29:\"_download_permissions_granted\";i:108;s:20:\"_order_stock_reduced\";i:109;s:10:\"_cart_hash\";i:111;s:14:\"_refund_amount\";i:112;s:12:\"_refunded_by\";i:113;s:14:\"_refund_reason\";}", "on");
INSERT INTO `wp_options` VALUES("1636", "jetpack_sync_settings_comment_meta_whitelist", "a:1:{i:0;s:6:\"rating\";}", "on");
INSERT INTO `wp_options` VALUES("1638", "jetpack_sync_settings_max_enqueue_full_sync", "100", "on");
INSERT INTO `wp_options` VALUES("1639", "jetpack_sync_settings_max_queue_size_full_sync", "1000", "on");
INSERT INTO `wp_options` VALUES("1640", "jetpack_sync_settings_sync_via_cron", "1", "on");
INSERT INTO `wp_options` VALUES("1641", "jetpack_sync_settings_cron_sync_time_limit", "240", "on");
INSERT INTO `wp_options` VALUES("1642", "jetpack_sync_settings_known_importers", "a:6:{s:16:\"Blogger_Importer\";s:7:\"blogger\";s:13:\"LJ_API_Import\";s:11:\"livejournal\";s:9:\"MT_Import\";s:2:\"mt\";s:10:\"RSS_Import\";s:3:\"rss\";s:20:\"WC_Tax_Rate_Importer\";s:12:\"woo-tax-rate\";s:9:\"WP_Import\";s:9:\"wordpress\";}", "on");
INSERT INTO `wp_options` VALUES("1643", "jetpack_sync_settings_term_relationships_full_sync_item_size", "100", "on");
INSERT INTO `wp_options` VALUES("1644", "jetpack_sync_settings_sync_sender_enabled", "1", "on");
INSERT INTO `wp_options` VALUES("1645", "jetpack_sync_settings_full_sync_sender_enabled", "1", "on");
INSERT INTO `wp_options` VALUES("1646", "jetpack_sync_settings_full_sync_send_duration", "9", "on");
INSERT INTO `wp_options` VALUES("1647", "jetpack_sync_settings_full_sync_limits", "a:7:{s:8:\"comments\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:10;}s:5:\"posts\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:1;}s:18:\"term_relationships\";a:2:{s:10:\"chunk_size\";i:1000;s:10:\"max_chunks\";i:10;}s:5:\"terms\";a:2:{s:10:\"chunk_size\";i:1000;s:10:\"max_chunks\";i:10;}s:5:\"users\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:10;}s:11:\"woocommerce\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:10;}s:23:\"woocommerce_hpos_orders\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:10;}}", "on");
INSERT INTO `wp_options` VALUES("1648", "jetpack_sync_settings_checksum_disable", "0", "on");
INSERT INTO `wp_options` VALUES("1649", "jetpack_sync_settings_wpcom_rest_api_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("1653", "jetpack_plugin_api_action_links", "a:4:{s:63:\"product-import-export-for-woo/product-import-export-for-woo.php\";a:5:{s:17:\"برون‌بری\";s:83:\"https://erictarot.com/wp-admin/admin.php?page=wt_import_export_for_woo_basic_export\";s:19:\"درون‌ریزی\";s:83:\"https://erictarot.com/wp-admin/admin.php?page=wt_import_export_for_woo_basic_import\";s:14:\"مستندات\";s:78:\"https://www.webtoffee.com/product-import-export-plugin-woocommerce-user-guide/\";s:16:\"پشتیبانی\";s:67:\"https://wordpress.org/support/plugin/product-import-export-for-woo/\";s:15:\"Premium Upgrade\";s:185:\"https://www.webtoffee.com/product/product-import-export-woocommerce/?utm_source=free_plugin_listing&utm_medium=product_imp_exp_basic&utm_campaign=Product_Import_Export&utm_content=2.4.9\";}s:27:\"woocommerce/woocommerce.php\";a:1:{s:16:\"پیکربندی\";s:57:\"https://erictarot.com/wp-admin/admin.php?page=wc-settings\";}s:45:\"woocommerce-payments/woocommerce-payments.php\";a:1:{s:8:\"Settings\";s:99:\"https://erictarot.com/wp-admin/admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments\";}s:27:\"js_composer/js_composer.php\";a:1:{s:14:\"تنظیمات\";s:56:\"https://erictarot.com/wp-admin/admin.php?page=vc-general\";}}", "auto");
INSERT INTO `wp_options` VALUES("1793", "jetpack_updates_sync_checksum", "a:1:{s:14:\"update_plugins\";i:1362536085;}", "auto");
INSERT INTO `wp_options` VALUES("2016", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("1771", "wcpay_session_store_id", "st_8Zj49aSHTfK.zR$Ppc3SBGP40GL9Z", "auto");
INSERT INTO `wp_options` VALUES("1786", "woocommerce_bacs_settings", "a:11:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:36:\"انتقال مستقیم بانکی\";s:11:\"description\";s:325:\"پرداخت خود را مستقیما به حساب بانکی ما واریز کنید.خواهشمندیم شماره سفارش خود را بعنوان کد ارجاع پرداخت استفاده کنید.سفارش شما تا زمانی که وجوه به حساب ما وارد نشود ارسال نخواهد شد.\";s:12:\"instructions\";s:0:\"\";s:15:\"account_details\";s:0:\"\";s:12:\"account_name\";s:0:\"\";s:14:\"account_number\";s:0:\"\";s:9:\"sort_code\";s:0:\"\";s:9:\"bank_name\";s:0:\"\";s:4:\"iban\";s:0:\"\";s:3:\"bic\";s:0:\"\";}", "on");
INSERT INTO `wp_options` VALUES("1770", "wcpay_fraud_services_data", "a:3:{s:4:\"data\";a:2:{s:6:\"stripe\";a:0:{}s:4:\"sift\";a:2:{s:10:\"beacon_key\";s:10:\"affbdadb36\";s:18:\"sandbox_beacon_key\";s:10:\"6ad0ad748b\";}}s:7:\"fetched\";i:1740677262;s:7:\"errored\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("1689", "jetpack_constants_sync_checksum", "a:32:{s:7:\"ABSPATH\";i:2505157080;s:17:\"ALTERNATE_WP_CRON\";i:634125391;s:16:\"ATOMIC_CLIENT_ID\";i:634125391;s:26:\"AUTOMATIC_UPDATER_DISABLED\";i:634125391;s:15:\"DISABLE_WP_CRON\";i:634125391;s:18:\"DISALLOW_FILE_EDIT\";i:634125391;s:18:\"DISALLOW_FILE_MODS\";i:634125391;s:16:\"EMPTY_TRASH_DAYS\";i:2473281379;s:9:\"FS_METHOD\";i:634125391;s:12:\"IS_PRESSABLE\";i:634125391;s:11:\"PHP_VERSION\";i:2447860117;s:19:\"WP_ACCESSIBLE_HOSTS\";i:634125391;s:19:\"WP_AUTO_UPDATE_CORE\";i:634125391;s:14:\"WP_CONTENT_DIR\";i:2191329225;s:20:\"WP_CRON_LOCK_TIMEOUT\";i:3994858278;s:8:\"WP_DEBUG\";i:734881840;s:22:\"WP_HTTP_BLOCK_EXTERNAL\";i:634125391;s:19:\"WP_MAX_MEMORY_LIMIT\";i:1839787262;s:15:\"WP_MEMORY_LIMIT\";i:3065409971;s:17:\"WP_POST_REVISIONS\";i:4261170317;s:14:\"WC_PLUGIN_FILE\";i:2407185525;s:10:\"WC_ABSPATH\";i:1062197996;s:18:\"WC_PLUGIN_BASENAME\";i:1149093810;s:10:\"WC_VERSION\";i:3452169262;s:19:\"WOOCOMMERCE_VERSION\";i:3452169262;s:21:\"WC_ROUNDING_PRECISION\";i:498629140;s:25:\"WC_DISCOUNT_ROUNDING_MODE\";i:450215437;s:20:\"WC_TAX_ROUNDING_MODE\";i:2212294583;s:12:\"WC_DELIMITER\";i:2455911554;s:10:\"WC_LOG_DIR\";i:2935435176;s:22:\"WC_SESSION_CACHE_GROUP\";i:4278978988;s:22:\"WC_TEMPLATE_DEBUG_MODE\";i:734881840;}", "auto");
INSERT INTO `wp_options` VALUES("1690", "jpsq_sync_checkout", "0:0", "no");
INSERT INTO `wp_options` VALUES("1744", "jetpack_sync_health_status", "a:2:{s:6:\"status\";s:7:\"in_sync\";s:9:\"timestamp\";d:1740676330.5222899913787841796875;}", "auto");
INSERT INTO `wp_options` VALUES("1697", "jetpack_callables_sync_checksum", "a:10:{s:8:\"site_url\";i:2851096161;s:8:\"home_url\";i:2851096161;s:11:\"get_plugins\";i:1974948571;s:10:\"get_themes\";i:1826732690;s:14:\"paused_plugins\";i:223132457;s:13:\"paused_themes\";i:223132457;s:8:\"timezone\";i:203370178;s:23:\"wp_get_environment_type\";i:1138987844;s:18:\"wp_max_upload_size\";i:2450289511;s:10:\"wp_version\";i:245578873;}", "no");
INSERT INTO `wp_options` VALUES("1698", "jetpack_next_sync_time_sync", "1740676304", "on");
INSERT INTO `wp_options` VALUES("1699", "jp_sync_lock_full_sync", "", "off");
INSERT INTO `wp_options` VALUES("1701", "jp_sync_retry_after_immediate-send", "1740676415.9992", "off");
INSERT INTO `wp_options` VALUES("1702", "jp_sync_error_log_immediate-send", "a:3:{s:15:\"1740676295.2331\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:51:\"jetpack_sync_send_error_concurrent_processing_error\";a:1:{i:0;s:61:\"There is another sync processing running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:51:\"jetpack_sync_send_error_concurrent_processing_error\";a:1:{s:6:\"status\";i:429;}}s:18:\"\0*\0additional_data\";a:0:{}}s:15:\"1740676295.5152\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:51:\"jetpack_sync_send_error_concurrent_processing_error\";a:1:{i:0;s:61:\"There is another sync processing running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:51:\"jetpack_sync_send_error_concurrent_processing_error\";a:1:{s:6:\"status\";i:429;}}s:18:\"\0*\0additional_data\";a:0:{}}s:15:\"1740676355.9994\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:27:\"concurrent_processing_error\";a:1:{i:0;s:61:\"There is another sync processing running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:27:\"concurrent_processing_error\";a:5:{s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 27 Feb 2025 17:12:35 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";a:2:{i:0;s:15:\"Accept-Encoding\";i:1;s:20:\"accept, content-type\";}s:8:\"x-hacker\";s:62:\"Want root?  Visit join.a8c.com/hacker and mention this header.\";s:11:\"host-header\";s:13:\"WordPress.com\";s:22:\"jetpack-dedicated-sync\";s:2:\"on\";s:16:\"content-encoding\";s:2:\"br\";s:4:\"x-ac\";s:17:\"4.arn _dca BYPASS\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";}s:4:\"body\";s:472:\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<methodResponse>\n  <fault>\n    <value>\n      <struct>\n        <member>\n          <name>faultCode</name>\n          <value><int>400</int></value>\n        </member>\n        <member>\n          <name>faultString</name>\n          <value><string>Jetpack: [concurrent_processing_error] There is another sync processing running for the same blog ID</string></value>\n        </member>\n      </struct>\n    </value>\n  </fault>\n</methodResponse>\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;}}s:18:\"\0*\0additional_data\";a:1:{s:27:\"concurrent_processing_error\";a:1:{i:0;i:400;}}}}", "auto");
INSERT INTO `wp_options` VALUES("1703", "jetpack_next_sync_time_full-sync-enqueue", "1740676360", "on");
INSERT INTO `wp_options` VALUES("1706", "jp_sync_last_success_immediate-send", "1740676360.6294", "off");
INSERT INTO `wp_options` VALUES("1707", "jetpack_persistent_blog_id", "242119308", "off");
INSERT INTO `wp_options` VALUES("1708", "woocommerce_setup_jetpack_opted_in", "1", "auto");
INSERT INTO `wp_options` VALUES("1710", "jp_sync_last_success_sync", "1740680583.3082", "off");
INSERT INTO `wp_options` VALUES("90247", "_transient_woocommerce_product_task_product_count_transient", "18", "on");
INSERT INTO `wp_options` VALUES("7374", "woocommerce_cod_settings", "a:6:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:36:\"پرداخت هنگام دریافت\";s:11:\"description\";s:42:\"پرداخت نقدی پس از تحویل\";s:12:\"instructions\";s:42:\"پرداخت نقدی پس از تحویل\";s:18:\"enable_for_methods\";a:1:{i:0;s:13:\"free_shipping\";}s:18:\"enable_for_virtual\";s:3:\"yes\";}", "on");
INSERT INTO `wp_options` VALUES("121717", "_transient_timeout_jetpack_update_remote_package_last_query", "1765603000", "off");
INSERT INTO `wp_options` VALUES("104801", "_transient_timeout_woocommerce_blocks_asset_api_script_data_ssl", "1766222718", "off");
INSERT INTO `wp_options` VALUES("16601", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"tabmehrnaz@gmail.com\";s:7:\"version\";s:3:\"6.9\";s:9:\"timestamp\";i:1764742619;}", "off");
INSERT INTO `wp_options` VALUES("2490", "lyte_version", "1.7.26", "auto");
INSERT INTO `wp_options` VALUES("2492", "widget_wylwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("7199", "woocommerce_attribute_lookup_enabled", "yes", "auto");
INSERT INTO `wp_options` VALUES("2048", "woocommerce_no_sales_tax", "1", "auto");
INSERT INTO `wp_options` VALUES("2049", "woocommerce_task_list_completed_lists", "a:1:{i:0;s:5:\"setup\";}", "auto");
INSERT INTO `wp_options` VALUES("2050", "woocommerce_default_homepage_layout", "two_columns", "auto");
INSERT INTO `wp_options` VALUES("10753", "woocommerce_task_list_reminder_bar_hidden", "yes", "auto");
INSERT INTO `wp_options` VALUES("78807", "simba_tfa_priv_key_format", "1", "off");
INSERT INTO `wp_options` VALUES("78805", "aiowpsec_firewall_version", "1.0.8", "auto");
INSERT INTO `wp_options` VALUES("116864", "wp_notes_notify", "1", "on");
INSERT INTO `wp_options` VALUES("121701", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:63:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.9.zip\";s:6:\"locale\";s:5:\"fa_IR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:63:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.9.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.9\";s:7:\"version\";s:3:\"6.9\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1765602791;s:15:\"version_checked\";s:3:\"6.9\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("121697", "_site_transient_timeout_wp_theme_files_patterns-3159d8e5f1c21340092e5887d99bc2ef", "1765604542", "off");
INSERT INTO `wp_options` VALUES("121698", "_site_transient_wp_theme_files_patterns-3159d8e5f1c21340092e5887d99bc2ef", "a:2:{s:7:\"version\";s:5:\"0.0.2\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("121354", "aiowps_captcha_string_info_3kj8g5aydm", "MTc2NTU0NDA3MzVrcGdhZWZ1bHo2OWQ0eTQ3MnRrOQ==", "off");
INSERT INTO `wp_options` VALUES("121355", "aiowps_captcha_string_info_time_3kj8g5aydm", "1765544073", "off");
INSERT INTO `wp_options` VALUES("121366", "aiowps_captcha_string_info_time_r50fdb0i8y", "1765544653", "off");
INSERT INTO `wp_options` VALUES("121378", "aiowps_captcha_string_info_rn7z3xc1mg", "MTc2NTU0NzAxMzVrcGdhZWZ1bHo2OWQ0eTQ3MnRrMzI=", "off");
INSERT INTO `wp_options` VALUES("121379", "aiowps_captcha_string_info_time_rn7z3xc1mg", "1765547013", "off");
INSERT INTO `wp_options` VALUES("29096", "wp_crontrol_paused", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("37497", "GTranslate", "a:39:{s:11:\"pro_version\";s:0:\"\";s:18:\"enterprise_version\";s:0:\"\";s:16:\"wrapper_selector\";s:19:\".gtranslate_wrapper\";s:14:\"custom_domains\";s:0:\"\";s:19:\"custom_domains_data\";s:0:\"\";s:15:\"url_translation\";s:0:\"\";s:17:\"add_hreflang_tags\";s:0:\"\";s:17:\"email_translation\";s:0:\"\";s:23:\"email_translation_debug\";s:0:\"\";s:12:\"show_in_menu\";s:12:\"us_main_menu\";s:26:\"floating_language_selector\";s:11:\"bottom_left\";s:21:\"native_language_names\";s:0:\"\";s:10:\"enable_cdn\";s:0:\"\";s:23:\"detect_browser_language\";s:0:\"\";s:12:\"add_new_line\";i:1;s:21:\"select_language_label\";s:15:\"Select Language\";s:10:\"custom_css\";s:0:\"\";s:16:\"default_language\";s:2:\"fa\";s:11:\"widget_look\";s:5:\"float\";s:9:\"flag_size\";i:24;s:10:\"flag_style\";s:2:\"2d\";s:10:\"globe_size\";i:60;s:11:\"globe_color\";s:7:\"#66aaff\";s:10:\"incl_langs\";a:10:{i:0;s:2:\"ar\";i:1;s:5:\"zh-CN\";i:2;s:2:\"nl\";i:3;s:2:\"en\";i:4;s:2:\"fr\";i:5;s:2:\"de\";i:6;s:2:\"it\";i:7;s:2:\"pt\";i:8;s:2:\"ru\";i:9;s:2:\"es\";}s:11:\"fincl_langs\";a:11:{i:0;s:2:\"ar\";i:1;s:5:\"zh-CN\";i:2;s:2:\"nl\";i:3;s:2:\"en\";i:4;s:2:\"fr\";i:5;s:2:\"de\";i:6;s:2:\"it\";i:7;s:2:\"fa\";i:8;s:2:\"pt\";i:9;s:2:\"ru\";i:10;s:2:\"es\";}s:9:\"alt_flags\";a:0:{}s:19:\"switcher_text_color\";s:4:\"#666\";s:20:\"switcher_arrow_color\";s:4:\"#666\";s:21:\"switcher_border_color\";s:4:\"#ccc\";s:25:\"switcher_background_color\";s:4:\"#fff\";s:32:\"switcher_background_shadow_color\";s:7:\"#efefef\";s:31:\"switcher_background_hover_colo