<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

update_option( 'us_license_activated', 1 );

/**
 * Theme functions and definitions
 */

if ( ! defined( 'US_ACTIVATION_THEMENAME' ) ) {
	define( 'US_ACTIVATION_THEMENAME', 'Zephyr' );
}

global $us_theme_supports;
$us_theme_supports = array(
	'plugins' => array(
		'js_composer' => 'plugins-support/js_composer/js_composer.php',
		'Ultimate_VC_Addons' => 'plugins-support/Ultimate_VC_Addons.php',
		'revslider' => 'plugins-support/revslider.php',
		'contact-form-7' => NULL,
		'woocommerce' => 'plugins-support/woocommerce.php',
		'tablepress' => 'plugins-support/tablepress.php',
		'tiny_mce' => 'plugins-support/tiny_mce.php',
		'post_views_counter' => 'plugins-support/post_views_counter.php',
		'the-events-calendar' => 'plugins-support/the_events_calendar.php',
	),
	// Include plugins that relate to translations and can be used in helpers.php
	'translate_plugins' => array(
		'wpml' => 'plugins-support/wpml.php',
		'polylang' => 'plugins-support/polylang.php',
	),
);

require dirname( __FILE__ ) . '/common/framework.php';

add_filter( 'woocommerce_product_add_to_cart_text', 'woocommerce_custom_product_add_to_cart_text' );  
function woocommerce_custom_product_add_to_cart_text() {
    return __( 'zum Angebot', 'woocommerce' );
}











// شورتکد نمایش لیست درخواست‌ها و حذف آنها
add_shortcode('ai_tarot_requests_list', function() {
    if (!current_user_can('manage_options')) {
        return 'دسترسی ندارید.';
    }

    global $wpdb;
    $table_name = $wpdb->prefix . 'ai_tarot_requests';

    // حذف درخواست در صورت ارسال آی‌دی
    if (isset($_GET['delete_request']) && is_numeric($_GET['delete_request'])) {
        $delete_id = intval($_GET['delete_request']);
        $wpdb->delete($table_name, ['id' => $delete_id]);
        echo '<div style="color:green;">ردیف با موفقیت حذف شد.</div>';
    }

    $requests = $wpdb->get_results("SELECT * FROM $table_name ORDER BY request_time DESC");

    ob_start();
    ?>
    <style>
        .ai-tarot-table { border-collapse: collapse; width: 100%; max-width: 900px; }
        .ai-tarot-table th, .ai-tarot-table td { border: 1px solid #ccc; padding: 8px; text-align: center; }
        .ai-tarot-table th { background: #f0f0f0; }
        .ai-delete-btn { color: red; cursor: pointer; }
    </style>

    <table class="ai-tarot-table">
        <thead>
            <tr>
                <th>شناسه</th>
                <th>نام</th>
                <th>شماره موبایل</th>
                <th>زمان درخواست</th>
                <th>حذف</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($requests): ?>
                <?php foreach ($requests as $req): ?>
                    <tr>
                        <td><?php echo esc_html($req->id); ?></td>
                        <td><?php echo esc_html($req->name); ?></td>
                        <td dir="ltr"><?php echo esc_html($req->mobile); ?></td>
                        <td><?php echo esc_html($req->request_time); ?></td>
                        <td>
                            <a href="<?php echo esc_url(add_query_arg('delete_request', $req->id)); ?>" onclick="return confirm('آیا از حذف این ردیف مطمئن هستید؟');" class="ai-delete-btn">حذف</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr><td colspan="5">هیچ درخواستی یافت نشد.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
    <?php
    return ob_get_clean();
});
