<?php
/*
Plugin Name: AI Tarot Reading
Description: Simple tarot reading plugin with GPT interpretation
Version: 1.0
Author: Your Name
*/

add_shortcode('ai_tarot_form', 'ai_tarot_render_form');
add_action('wp_enqueue_scripts', 'ai_tarot_enqueue_scripts');
add_action('wp_ajax_ai_tarot_get_reading', 'ai_tarot_get_reading');
add_action('wp_ajax_nopriv_ai_tarot_get_reading', 'ai_tarot_get_reading');

function ai_tarot_enqueue_scripts() {
    wp_enqueue_script('ai-tarot-js', plugin_dir_url(__FILE__) . 'ai-tarot.js', ['jquery'], null, true);
    wp_localize_script('ai-tarot-js', 'ai_tarot_ajax', [
        'ajax_url' => admin_url('admin-ajax.php'),
    ]);
    wp_enqueue_style('ai-tarot-style', plugin_dir_url(__FILE__) . 'ai-tarot.css');
}

function ai_tarot_render_form() {
    ob_start();
    ?>
    <div class="ai-tarot">
        <label for="user_question">سؤال خود را بنویسید:</label>
        <textarea id="user_question"></textarea>
        <button id="draw_cards">فال بگیر</button>
        <div id="tarot_result"></div>
    </div>
    <?php
    return ob_get_clean();
}

function ai_tarot_get_reading() {
    $cards = ['The Fool', 'The Lovers', 'Death', 'Strength', 'The Hermit', 'Wheel of Fortune', 'The Moon', 'The Sun'];
    shuffle($cards);
    $selected_cards = array_slice($cards, 0, 3);
    $question = sanitize_text_field($_POST['question']);

    $prompt = "کارت‌های تاروت انتخاب‌شده: " . implode(', ', $selected_cards) . ". تعبیر این کارت‌ها را به زبان ساده و روان، براساس سؤال زیر بده: \n\n" . $question;

    $response = wp_remote_post('https://api.openai.com/v1/completions', [
        'headers' => [
            'Content-Type' => 'application/json',
    'Authorization' => 'Bearer ' . OPENAI_API_KEY,

        ],
        'body' => json_encode([
            'model' => 'text-davinci-003',
            'prompt' => $prompt,
            'max_tokens' => 300
        ])
    ]);

    if (is_wp_error($response)) {
        wp_send_json_error('مشکلی در اتصال به هوش مصنوعی پیش آمد.');
    } else {
        $body = json_decode(wp_remote_retrieve_body($response), true);
        $ai_text = $body['choices'][0]['text'] ?? 'پاسخی دریافت نشد.';
        wp_send_json_success([
            'cards' => $selected_cards,
            'reading' => $ai_text
        ]);
    }
}
